/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.tree;

import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaHighlightingSessionStatisticsCollector;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaInheritanceKt;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import com.jetbrains.jsonSchema.impl.tree.Operation;
import com.jetbrains.jsonSchema.impl.tree.ProcessDefinitionsOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0016J \u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/jsonSchema/impl/tree/IfThenElseBranchOperation;", "Lcom/jetbrains/jsonSchema/impl/tree/Operation;", "schemaObject", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "expansionRequest", "Lcom/jetbrains/jsonSchema/impl/tree/JsonSchemaNodeExpansionRequest;", "jsonSchemaService", "Lcom/jetbrains/jsonSchema/ide/JsonSchemaService;", "<init>", "(Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;Lcom/jetbrains/jsonSchema/impl/tree/JsonSchemaNodeExpansionRequest;Lcom/jetbrains/jsonSchema/ide/JsonSchemaService;)V", "map", "", "visited", "", "reduce", "computeEffectiveIfThenElseBranches", "", "parent", "getContainingObjectAdapterOrSelf", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonValueAdapter;", "inspectedValueAdapter", "intellij.json.backend"})
@SourceDebugExtension(value={"SMAP\nIfThenElseBranchOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IfThenElseBranchOperation.kt\ncom/jetbrains/jsonSchema/impl/tree/IfThenElseBranchOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1642#2,10:82\n1915#2:92\n1916#2:94\n1652#2:95\n1586#2:96\n1661#2,3:97\n1#3:93\n*S KotlinDebug\n*F\n+ 1 IfThenElseBranchOperation.kt\ncom/jetbrains/jsonSchema/impl/tree/IfThenElseBranchOperation\n*L\n19#1:82,10\n19#1:92\n19#1:94\n19#1:95\n24#1:96\n24#1:97,3\n19#1:93\n*E\n"})
public final class IfThenElseBranchOperation
extends Operation {
    @NotNull
    private final JsonSchemaService jsonSchemaService;

    public IfThenElseBranchOperation(@NotNull JsonSchemaObject schemaObject, @Nullable JsonSchemaNodeExpansionRequest expansionRequest, @NotNull JsonSchemaService jsonSchemaService) {
        Intrinsics.checkNotNullParameter((Object)schemaObject, (String)"schemaObject");
        Intrinsics.checkNotNullParameter((Object)jsonSchemaService, (String)"jsonSchemaService");
        super(schemaObject, expansionRequest);
        this.jsonSchemaService = jsonSchemaService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void map(@NotNull Set<JsonSchemaObject> visited) {
        List list;
        Intrinsics.checkNotNullParameter(visited, (String)"visited");
        if (visited.contains(this.mySourceNode)) {
            return;
        }
        JsonSchemaHighlightingSessionStatisticsCollector.Companion.getInstance().reportSchemaUsageFeature(JsonSchemaFusCountedFeature.IfElseExpanded);
        JsonSchemaNodeExpansionRequest jsonSchemaNodeExpansionRequest = this.myExpansionRequest;
        Intrinsics.checkNotNullExpressionValue((Object)jsonSchemaNodeExpansionRequest, (String)"myExpansionRequest");
        JsonSchemaObject jsonSchemaObject = this.mySourceNode;
        Intrinsics.checkNotNullExpressionValue((Object)jsonSchemaObject, (String)"mySourceNode");
        Iterable<JsonSchemaObject> iterable = this.computeEffectiveIfThenElseBranches(jsonSchemaNodeExpansionRequest, jsonSchemaObject);
        if (iterable != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable2 = iterable;
            boolean $i$f$mapNotNull = false;
            void var6_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JsonSchemaObject jsonSchemaObject2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JsonSchemaObject it = (JsonSchemaObject)element$iv$iv;
                boolean bl2 = false;
                if (visited.contains(it)) {
                    jsonSchemaObject2 = null;
                } else {
                    JsonSchemaObject jsonSchemaObject3 = this.mySourceNode;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonSchemaObject3, (String)"mySourceNode");
                    jsonSchemaObject2 = JsonSchemaInheritanceKt.inheritBaseSchemaIfNeeded(jsonSchemaObject3, it);
                }
                if (jsonSchemaObject2 == null) continue;
                JsonSchemaObject it$iv$iv = jsonSchemaObject2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List effectiveBranches = list;
        iterable = effectiveBranches;
        if (!(iterable == null || iterable.isEmpty())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = effectiveBranches;
            List list2 = this.myChildOperations;
            boolean $i$f$map = false;
            void $i$f$mapNotNull = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonSchemaObject $i$f$forEach = (JsonSchemaObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ProcessDefinitionsOperation((JsonSchemaObject)it, this.jsonSchemaService, this.myExpansionRequest));
            }
            list2.addAll((List)destination$iv$iv);
        }
    }

    @Override
    public void reduce() {
        if (!this.myChildOperations.isEmpty()) {
            for (Operation operation : this.myChildOperations) {
                List<JsonSchemaObject> list = operation.myAnyOfGroup;
                Intrinsics.checkNotNullExpressionValue(list, (String)"myAnyOfGroup");
                this.myAnyOfGroup.addAll((Collection)list);
                List<List<JsonSchemaObject>> list2 = operation.myOneOfGroup;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"myOneOfGroup");
                this.myOneOfGroup.addAll((Collection)list2);
            }
        } else {
            this.myAnyOfGroup.add(this.mySourceNode);
        }
    }

    private final List<JsonSchemaObject> computeEffectiveIfThenElseBranches(JsonSchemaNodeExpansionRequest expansionRequest, JsonSchemaObject parent) {
        List<IfThenElse> list = parent.getIfThenElse();
        if (list == null) {
            return null;
        }
        List<IfThenElse> conditionsList = list;
        JsonValueAdapter effectiveElementAdapter = this.getContainingObjectAdapterOrSelf(expansionRequest.getInspectedValueAdapter());
        return effectiveElementAdapter == null || !expansionRequest.getStrictIfElseBranchChoice() ? SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)conditionsList), IfThenElseBranchOperation::computeEffectiveIfThenElseBranches$lambda$0)), arg_0 -> IfThenElseBranchOperation.computeEffectiveIfThenElseBranches$lambda$1(parent, arg_0))) : SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)conditionsList), arg_0 -> IfThenElseBranchOperation.computeEffectiveIfThenElseBranches$lambda$2(effectiveElementAdapter, arg_0)), arg_0 -> IfThenElseBranchOperation.computeEffectiveIfThenElseBranches$lambda$3(parent, arg_0)));
    }

    private final JsonValueAdapter getContainingObjectAdapterOrSelf(JsonValueAdapter inspectedValueAdapter) {
        JsonValueAdapter myInspectedRootElementAdapter = null;
        if (inspectedValueAdapter != null && inspectedValueAdapter.isObject()) {
            myInspectedRootElementAdapter = inspectedValueAdapter;
        } else {
            JsonObjectValueAdapter parentObjectAdapter;
            JsonPropertyAdapter parentPropertyAdapter;
            JsonPropertyAdapter jsonPropertyAdapter;
            JsonLikePsiWalker psiWalker;
            PsiElement inspectedValuePsi;
            JsonValueAdapter jsonValueAdapter = inspectedValueAdapter;
            PsiElement psiElement = inspectedValuePsi = jsonValueAdapter != null ? jsonValueAdapter.getDelegate() : null;
            JsonLikePsiWalker jsonLikePsiWalker = psiWalker = psiElement == null ? null : JsonLikePsiWalker.getWalker(psiElement);
            if (jsonLikePsiWalker != null) {
                PsiElement psiElement2 = inspectedValuePsi;
                Intrinsics.checkNotNull((Object)psiElement2);
                jsonPropertyAdapter = jsonLikePsiWalker.getParentPropertyAdapter(psiElement2);
            } else {
                jsonPropertyAdapter = null;
            }
            JsonPropertyAdapter jsonPropertyAdapter2 = parentPropertyAdapter = jsonPropertyAdapter;
            JsonObjectValueAdapter jsonObjectValueAdapter = parentObjectAdapter = jsonPropertyAdapter2 != null ? jsonPropertyAdapter2.getParentObject() : null;
            myInspectedRootElementAdapter = jsonObjectValueAdapter != null ? (JsonValueAdapter)jsonObjectValueAdapter : inspectedValueAdapter;
        }
        return myInspectedRootElementAdapter;
    }

    private static final Sequence computeEffectiveIfThenElseBranches$lambda$0(IfThenElse condition) {
        Object[] objectArray = new JsonSchemaObject[]{condition.getThen(), condition.getElse()};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private static final JsonSchemaObject computeEffectiveIfThenElseBranches$lambda$1(JsonSchemaObject $parent, JsonSchemaObject branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return JsonSchemaInheritanceKt.inheritBaseSchemaIfNeeded($parent, branch);
    }

    private static final JsonSchemaObject computeEffectiveIfThenElseBranches$lambda$2(JsonValueAdapter $effectiveElementAdapter, IfThenElse condition) {
        return JsonSchemaResolver.isCorrect($effectiveElementAdapter, condition.getIf()) ? condition.getThen() : condition.getElse();
    }

    private static final JsonSchemaObject computeEffectiveIfThenElseBranches$lambda$3(JsonSchemaObject $parent, JsonSchemaObject branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return JsonSchemaInheritanceKt.inheritBaseSchemaIfNeeded($parent, branch);
    }
}

