/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.datagrid.GridRow;
import com.intellij.database.dialects.bigquery.BQTypeNode;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0016J\n\u0010\t\u001a\u00020\nH\u0096\u0080\u0004J<\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/bigquery/BQArrayNode;", "Lcom/intellij/database/dialects/bigquery/BQTypeNode;", "child", "<init>", "(Lcom/intellij/database/dialects/bigquery/BQTypeNode;)V", "getChild", "()Lcom/intellij/database/dialects/bigquery/BQTypeNode;", "children", "", "toString", "", "set", "Lkotlin/Pair;", "", "newRows", "", "Lcom/intellij/database/datagrid/GridRow;", "o", "", "row", "column", "intellij.database.dialects.bigquery.ex"})
@SourceDebugExtension(value={"SMAP\nBigQueryGridColumnsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryGridColumnsManager.kt\ncom/intellij/database/dialects/bigquery/BQArrayNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
final class BQArrayNode
implements BQTypeNode {
    @NotNull
    private final BQTypeNode child;

    public BQArrayNode(@NotNull BQTypeNode child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        this.child = child;
    }

    @NotNull
    public final BQTypeNode getChild() {
        return this.child;
    }

    @Override
    @NotNull
    public List<BQTypeNode> children() {
        return CollectionsKt.listOf((Object)this.child);
    }

    @NotNull
    public String toString() {
        String it = this.child.toString();
        boolean bl = false;
        return ((CharSequence)it).length() == 0 ? "ARRAY" : "ARRAY<" + this.child + ">";
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> set(@NotNull List<GridRow> newRows, @Nullable Object o, int row, int column) {
        Intrinsics.checkNotNullParameter(newRows, (String)"newRows");
        List list = o instanceof List ? (List)o : null;
        if (list == null) {
            return new Pair((Object)0, (Object)0);
        }
        List list2 = list;
        int rowCount = 0;
        int columnCount = 0;
        for (Map item : list2) {
            Object v = item.get("v");
            Pair<Integer, Integer> pair = this.child.set(newRows, v, row + rowCount, column);
            int valueRowCount = ((Number)pair.component1()).intValue();
            int valueColumnCount = ((Number)pair.component2()).intValue();
            rowCount += valueRowCount;
            columnCount = Math.max(columnCount, valueColumnCount);
        }
        return new Pair((Object)rowCount, (Object)columnCount);
    }
}

