/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery.psi;

import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlAsExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u0007H\u0002R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/dialects/bigquery/psi/BigQueryAsExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlAsExpressionImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "computeDasType", "Lcom/intellij/database/types/DasType;", "isUnnestExpression", "", "createUnnestType", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "getCallExpression", "()Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "intellij.database.dialects.bigquery"})
public class BigQueryAsExpressionImpl
extends SqlAsExpressionImpl {
    public BigQueryAsExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    protected DasType computeDasType() {
        DasType dasType;
        if (this.isUnnestExpression()) {
            dasType = this.createUnnestType();
        } else {
            DasType dasType2 = super.computeDasType();
            dasType = dasType2;
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"computeDasType(...)");
        }
        return dasType;
    }

    public final boolean isUnnestExpression() {
        SqlFunctionCallExpression sqlFunctionCallExpression = this.getCallExpression();
        return Intrinsics.areEqual((Object)(sqlFunctionCallExpression != null && (sqlFunctionCallExpression = sqlFunctionCallExpression.getFunctionDefinition()) != null ? sqlFunctionCallExpression.getName() : null), (Object)"unnest");
    }

    private final DasType createUnnestType() {
        SqlTableType type;
        SqlFunctionCallExpression sqlFunctionCallExpression = this.getCallExpression();
        DasType dasType = sqlFunctionCallExpression != null ? sqlFunctionCallExpression.getDasType() : null;
        SqlTableType sqlTableType = type = dasType instanceof SqlTableType ? (SqlTableType)dasType : null;
        if (type == null || type.getColumnCount() != 1) {
            DasType dasType2 = super.computeDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"computeDasType(...)");
            return dasType2;
        }
        DasType colDasType = type.getColumnDasType(0);
        SqlTableType sqlTableType2 = SqlTableTypeBase.createType((PsiElement)((PsiElement)this), (DasType)colDasType, (String)this.getName(), (boolean)false, (boolean)false, (boolean)true, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType2, (String)"createType(...)");
        return (DasType)sqlTableType2;
    }

    private final SqlFunctionCallExpression getCallExpression() {
        SqlExpression sqlExpression = this.getExpression();
        PsiElement psiElement = sqlExpression != null ? sqlExpression.getFirstChild() : null;
        return psiElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)psiElement : null;
    }
}

