/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dialects.oracle.debugger.OraLineBreakpointProperties;
import com.intellij.database.dialects.oracle.debugger.OraNamespace;
import com.intellij.database.dialects.oracle.debugger.OraProgram;
import com.intellij.database.dialects.oracle.debugger.OraProgramFile;
import com.intellij.database.dialects.oracle.debugger.OraProgramLineMapper;
import com.intellij.database.dialects.oracle.debugger.OraProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramPositionFile;
import com.intellij.database.dialects.oracle.debugger.OraRealLineBreakpoint;
import com.intellij.database.dialects.oracle.debugger.OraScriptPosition;
import com.intellij.database.dialects.oracle.debugger.ProblematicResult;
import com.intellij.database.dialects.oracle.debugger.Result;
import com.intellij.database.dialects.oracle.debugger.ResultKt;
import com.intellij.database.dialects.oracle.debugger.SuccessfulResult;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001f\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001a*\u0016\u0010\u0000\"\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u001b"}, d2={"OraXLineBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointProperties;", "prepareScriptLineBreakpoint", "Lcom/intellij/database/dialects/oracle/debugger/Result;", "Lcom/intellij/database/dialects/oracle/debugger/OraRealLineBreakpoint;", "xbp", "Lcom/intellij/database/dialects/oracle/debugger/OraXLineBreakpoint;", "scriptFirstLineNr", "", "prepareProgramLineBreakpoint", "project", "Lcom/intellij/openapi/project/Project;", "mapper", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramLineMapper;", "findOraPositionByVirtualFileLine", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramPositionFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "findOraProgramByVirtualFile", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramFile;", "inReadAction", "X", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.dialects.oracle.ex"})
@JvmName(name="OracleDebugHelper")
@SourceDebugExtension(value={"SMAP\nOraDebugHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraDebugHelper.kt\ncom/intellij/database/dialects/oracle/debugger/OracleDebugHelper\n+ 2 Result.kt\ncom/intellij/database/dialects/oracle/debugger/ResultKt\n*L\n1#1,72:1\n39#2,4:73\n33#2,4:77\n*S KotlinDebug\n*F\n+ 1 OraDebugHelper.kt\ncom/intellij/database/dialects/oracle/debugger/OracleDebugHelper\n*L\n28#1:73,4\n37#1:77,4\n*E\n"})
public final class OracleDebugHelper {
    @NotNull
    public static final Result<OraRealLineBreakpoint> prepareScriptLineBreakpoint(@NotNull XLineBreakpoint<OraLineBreakpointProperties> xbp, int scriptFirstLineNr) {
        Intrinsics.checkNotNullParameter(xbp, (String)"xbp");
        OraScriptPosition position = new OraScriptPosition(xbp.getLine() - scriptFirstLineNr + 1);
        OraRealLineBreakpoint rbp = new OraRealLineBreakpoint(xbp, position, null, 0, false, false, null, 120, null);
        return ResultKt.success(rbp);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result<OraRealLineBreakpoint> prepareProgramLineBreakpoint(@NotNull XLineBreakpoint<OraLineBreakpointProperties> xbp, @NotNull Project project, @NotNull OraProgramLineMapper mapper) {
        Result result;
        void $this$transform$iv;
        Result<OraProgramPositionFile> pf;
        Intrinsics.checkNotNullParameter(xbp, (String)"xbp");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        String fileUrl = xbp.getFileUrl();
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        if (virtualFile == null) {
            return ResultKt.problem("Preparing breakpoint: file not found (URL: " + fileUrl + ")");
        }
        VirtualFile file = virtualFile;
        Result<OraProgramPositionFile> result2 = pf = OracleDebugHelper.findOraPositionByVirtualFileLine(file, xbp.getLine(), project, mapper);
        String description$iv = "Preparing breakpoint";
        boolean $i$f$transform = false;
        void var9_9 = $this$transform$iv;
        if (var9_9 instanceof SuccessfulResult) {
            OraProgramPositionFile it = (OraProgramPositionFile)((SuccessfulResult)$this$transform$iv).getValue();
            boolean bl = false;
            result = ResultKt.success(new OraRealLineBreakpoint(xbp, it.getPosition(), it.getModelElement(), 0, false, false, null, 120, null));
        } else if (var9_9 instanceof ProblematicResult) {
            result = ResultKt.problem(description$iv + ": " + ((ProblematicResult)$this$transform$iv).getProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @NotNull
    public static final Result<OraProgramPositionFile> findOraPositionByVirtualFileLine(@NotNull VirtualFile file, int line, @NotNull Project project, @NotNull OraProgramLineMapper mapper) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Result<OraProgramFile> $this$transform$iv = OracleDebugHelper.findOraProgramByVirtualFile(file, project);
        boolean $i$f$transform = false;
        Result<OraProgramFile> result2 = $this$transform$iv;
        if (result2 instanceof SuccessfulResult) {
            OraProgramFile it = (OraProgramFile)((SuccessfulResult)$this$transform$iv).getValue();
            boolean bl = false;
            result = ResultKt.success(new OraProgramPositionFile(new OraProgramPosition(it.getProgram(), mapper.mapFileToOra((BasicSourceAware)it.getModelElement(), line)), it.getModelElement(), it.getVirtualFile()));
        } else if (result2 instanceof ProblematicResult) {
            result = ResultKt.problem(((ProblematicResult)$this$transform$iv).getProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @NotNull
    public static final Result<OraProgramFile> findOraProgramByVirtualFile(@NotNull VirtualFile file, @NotNull Project project) {
        OraNamespace oraNamespace;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DbElement dbElement = DbImplUtilCore.findElement((Project)project, (VirtualFile)file);
        if (dbElement == null) {
            return ResultKt.problem("Cannot find a model element for file: " + file);
        }
        Object element = dbElement;
        Object object = element.getDelegate();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDelegate(...)");
        Object object2 = element = object;
        OraSourceAware oraSourceAware = object2 instanceof OraSourceAware ? (OraSourceAware)object2 : null;
        if (oraSourceAware == null) {
            return ResultKt.problem("The model element corresponded to file " + file + " is not source-aware (the element class is " + element.getClass() + ")");
        }
        OraSourceAware sao = oraSourceAware;
        Object object3 = sao.getSchema();
        if (object3 == null || (object3 = object3.getRealName()) == null) {
            return ResultKt.problem("The model element corresponded to file " + file + " has no schema");
        }
        Object schemaName = object3;
        String string = sao.getRealName();
        if (string == null) {
            return ResultKt.problem("The model element corresponded to file " + file + " has no name");
        }
        String programName = string;
        OraSourceAware oraSourceAware2 = sao;
        if (oraSourceAware2 instanceof OraRoutine) {
            oraNamespace = OraNamespace.NS_TOP;
        } else if (oraSourceAware2 instanceof OraModule) {
            oraNamespace = OraNamespace.NS_TOP;
        } else if (oraSourceAware2 instanceof OraBody) {
            oraNamespace = OraNamespace.NS_BODY;
        } else if (oraSourceAware2 instanceof OraTrigger) {
            oraNamespace = OraNamespace.NS_TRIGGER;
        } else {
            return ResultKt.problem("The model element corresponded to file " + file + " is not supported (the element kind " + ((OraSourceAware)element).getKind().code() + ")");
        }
        OraNamespace namespace = oraNamespace;
        OraProgram program = new OraProgram(namespace, (String)schemaName, programName);
        return ResultKt.success(new OraProgramFile(program, sao, file));
    }

    public static final <X> X inReadAction(@NotNull Function0<? extends X> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return (X)ApplicationManager.getApplication().runReadAction(() -> OracleDebugHelper.inReadAction$lambda$0(f));
    }

    private static final Object inReadAction$lambda$0(Function0 $f) {
        return $f.invoke();
    }
}

