/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.descriptor.value.CssValueValidatorStub;
import com.intellij.psi.css.impl.descriptor.value.CssGroupAllValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtilCore;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0013\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u001a\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J\"\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J\"\u0010$\u001a\u0004\u0018\u00010\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0%2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002J(\u0010&\u001a\u0004\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper;", "", "myStartElement", "Lcom/intellij/psi/PsiElement;", "myStopElement", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "termList", "Lcom/intellij/psi/css/CssTermList;", "(Lcom/intellij/psi/css/CssTermList;)V", "mapValue", "Lcom/intellij/psi/css/descriptor/value/CssValueMatchData;", "descriptor", "Lcom/intellij/psi/css/descriptor/value/CssValueDescriptor;", "logSOE", "", "current", "match", "element", "addDescriptorForCompletion", "addTermForCompletion", "matchGroupValue", "Lcom/intellij/psi/css/impl/descriptor/value/CssGroupValue;", "matchInlineValue", "Lcom/intellij/psi/css/impl/descriptor/value/CssInlineValue;", "descriptorProvider", "Lcom/intellij/psi/css/CssElementDescriptorProvider;", "matchPropertyReferenceValue", "Lcom/intellij/psi/css/impl/descriptor/value/CssPropertyReferenceValue;", "mapGroupAllDescriptor", "mapGroupAnyDescriptor", "mapGroupAndDescriptor", "mapGroupOrDescriptor", "matchAllLongest", "", "descriptors", "matchFirstLongest", "", "nextElement", "whitespacesShouldBeIgnored", "", "defaultElement", "nextVisibleSibling", "Companion", "intellij.css.common.psi"})
@SourceDebugExtension(value={"SMAP\nCssValueDescriptorMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssValueDescriptorMapper.kt\ncom/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,609:1\n1586#2:610\n1661#2,3:611\n*S KotlinDebug\n*F\n+ 1 CssValueDescriptorMapper.kt\ncom/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper\n*L\n199#1:610\n199#1:611,3\n*E\n"})
public class CssValueDescriptorMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PsiElement myStartElement;
    @Nullable
    private final PsiElement myStopElement;
    @NotNull
    private static final Logger LOG;

    public CssValueDescriptorMapper(@Nullable PsiElement myStartElement, @Nullable PsiElement myStopElement) {
        this.myStartElement = myStartElement;
        this.myStopElement = myStopElement;
    }

    public CssValueDescriptorMapper(@Nullable CssTermList termList) {
        this(CssPsiUtilCore.getFirstDeepestTerm((PsiElement)termList), CssPsiUtilCore.getLastDeepestTerm((PsiElement)termList));
    }

    @NotNull
    public final CssValueMatchData mapValue(@NotNull CssValueDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        try {
            return this.mapValue(this.myStartElement, descriptor);
        }
        catch (StackOverflowError stackOverflowError) {
            this.logSOE();
            return new CssValueMatchData(descriptor, false);
        }
    }

    private final void logSOE() {
        StringBuilder message = new StringBuilder("StackOverflowError. ");
        Language language = CssPsiUtilCore.getStylesheetLanguage(this.myStartElement);
        if (language != null) {
            message.append(language);
        }
        Class[] classArray = new Class[]{CssTermList.class};
        CssTermList termList = (CssTermList)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myStartElement, (Class[])classArray);
        if (termList != null) {
            PsiElement parent = termList.getParent();
            message.append(" [").append(parent.getText()).append("]");
            StringBuilder stringBuilder = message.append(", offset=");
            PsiElement psiElement = this.myStartElement;
            Intrinsics.checkNotNull((Object)psiElement);
            stringBuilder.append(psiElement.getTextRange().getStartOffset() - parent.getTextRange().getStartOffset());
        }
        LOG.error(message.toString());
    }

    private final CssValueMatchData mapValue(PsiElement current, CssValueDescriptor descriptor) {
        CssValueMatchData firstMatchData;
        PsiElement current2 = current;
        ProgressManager.checkCanceled();
        current2 = CssPsiUtilCore.getFirstDeepestTerm(current2);
        int maxOccur = descriptor.getMaxOccur();
        int minOccur = descriptor.getMinOccur();
        boolean matched = true;
        ArrayList<CssValueMatchData> matchData = new ArrayList<CssValueMatchData>();
        int attempt = 0;
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtilCore.findDescriptorProvider(current2);
        CssValueDescriptor separator = null;
        if (descriptorProvider != null) {
            Collection<? extends CssValueDescriptor> collection = descriptorProvider.getNamedValueDescriptors("comma-separator", descriptor);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getNamedValueDescriptors(...)");
            separator = (CssValueDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
        }
        while (attempt++ < maxOccur || maxOccur == -1) {
            CssTerm[] fallbackTerms = Companion.getVarFallbackTerms(current2);
            if (fallbackTerms != null) {
                current2 = (PsiElement)fallbackTerms[0];
            }
            boolean separatorMatched = true;
            if (attempt != 1 && descriptor.isCommaSeparated()) {
                if (separator == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                CssValueMatchData separatorMatchData = this.mapValue(current2, separator);
                matchData.add(separatorMatchData);
                separatorMatched = separatorMatchData.isMatched();
                if (separatorMatched) {
                    current2 = this.nextElement(separatorMatchData.getLastMatchedElement(), true, current2);
                }
            }
            CssValueMatchData nodeMatch = this.match(descriptor, current2);
            if (separatorMatched && nodeMatch.isMatched()) {
                PsiElement lastMatchedElement = nodeMatch.getLastMatchedElement();
                if (lastMatchedElement != null) {
                    current2 = lastMatchedElement;
                }
            } else {
                if (attempt > minOccur) break;
                matched = false;
                matchData.add(nodeMatch);
                break;
            }
            matchData.add(nodeMatch);
            if (attempt < maxOccur || maxOccur == -1) {
                current2 = CssValueDescriptorMapper.nextElement$default(this, current2, true, null, 4, null);
            }
            if (current2 != null) continue;
            if (attempt >= minOccur) break;
            matched = false;
            break;
        }
        if (matchData.size() == 1 && (firstMatchData = (CssValueMatchData)CollectionsKt.firstOrNull((List)matchData)) != null) {
            return matched != firstMatchData.isMatched() ? new CssValueMatchData(firstMatchData.getDescriptor(), matched, firstMatchData.getChildren()) : firstMatchData;
        }
        return new CssValueMatchData(descriptor, matched, (List)matchData);
    }

    private final CssValueMatchData match(CssValueDescriptor descriptor, PsiElement element) {
        CssValueMatchData result;
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtilCore.findDescriptorProvider(element);
        if (descriptor instanceof CssGroupValue) {
            return this.matchGroupValue((CssGroupValue)descriptor, element);
        }
        if (descriptor instanceof CssInlineValue && descriptorProvider != null) {
            if (Intrinsics.areEqual((Object)((CssInlineValue)descriptor).getRefId(), (Object)"font-family")) {
                this.addDescriptorForCompletion(descriptor);
            }
            return this.matchInlineValue((CssInlineValue)descriptor, element, descriptorProvider);
        }
        if (descriptor instanceof CssPropertyReferenceValue && descriptorProvider != null) {
            return this.matchPropertyReferenceValue((CssPropertyReferenceValue)descriptor, element, descriptorProvider);
        }
        if (element == null) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor);
            Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
            return cssValueMatchData;
        }
        if (element instanceof CssTerm) {
            this.addTermForCompletion(descriptor, element);
        }
        if ((result = new CssValueMatchData(descriptor, CssValueDescriptorMapper.Companion.getValueValidator(element).isValid(element, descriptor))).isMatched()) {
            result.addMatchedElement(element);
        }
        return result;
    }

    protected void addDescriptorForCompletion(@NotNull CssValueDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    protected void addTermForCompletion(@NotNull CssValueDescriptor descriptor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    private final CssValueMatchData matchGroupValue(CssGroupValue descriptor, PsiElement element) {
        return switch (WhenMappings.$EnumSwitchMapping$0[descriptor.getType().ordinal()]) {
            case 1 -> this.mapGroupOrDescriptor(descriptor, element);
            case 2 -> this.mapGroupAndDescriptor(descriptor, element);
            case 3 -> this.mapGroupAnyDescriptor(descriptor, element);
            case 4 -> this.mapGroupAllDescriptor(descriptor, element);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final CssValueMatchData matchInlineValue(CssInlineValue descriptor, PsiElement element, CssElementDescriptorProvider descriptorProvider) {
        Collection<? extends CssValueDescriptor> collection = CssDescriptorsUtilCore.sortDescriptors(descriptorProvider.getNamedValueDescriptors(descriptor.getRefId(), descriptor));
        Intrinsics.checkNotNullExpressionValue(collection, (String)"sortDescriptors(...)");
        Collection<? extends CssValueDescriptor> inlineValues = collection;
        CssValueMatchData matchData = this.matchFirstLongest(inlineValues, element);
        if (matchData != null) {
            Object[] objectArray = new CssValueMatchData[]{matchData};
            return new CssValueMatchData((CssValueDescriptor)descriptor, matchData.isMatched(), CollectionsKt.mutableListOf((Object[])objectArray));
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
        return cssValueMatchData;
    }

    /*
     * WARNING - void declaration
     */
    private final CssValueMatchData matchPropertyReferenceValue(CssPropertyReferenceValue descriptor, PsiElement element, CssElementDescriptorProvider descriptorProvider) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<? extends CssPropertyDescriptor> collection = descriptorProvider.findPropertyDescriptors(descriptor.getPropertyName(), element);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findPropertyDescriptors(...)");
        Collection<? extends CssPropertyDescriptor> propertyDescriptors = collection;
        Object[] objectArray = (Object[])propertyDescriptors;
        CssValueDescriptorMapper cssValueDescriptorMapper = this;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CssPropertyDescriptor cssPropertyDescriptor = (CssPropertyDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(CssValueDescriptorModificator.withParent(it.getValueDescriptor(), descriptor));
        }
        CssValueMatchData matchData = cssValueDescriptorMapper.matchFirstLongest((List)destination$iv$iv, element);
        if (matchData != null) {
            objectArray = new CssValueMatchData[]{matchData};
            return new CssValueMatchData((CssValueDescriptor)descriptor, matchData.isMatched(), CollectionsKt.mutableListOf((Object[])objectArray));
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
        return cssValueMatchData;
    }

    private final CssValueMatchData mapGroupAllDescriptor(CssGroupValue descriptor, PsiElement element) {
        PsiElement element2 = element;
        CssValueDescriptor separator = descriptor.getValuesSeparator();
        boolean whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        Intrinsics.checkNotNull((Object)descriptor, (String)"null cannot be cast to non-null type com.intellij.psi.css.impl.descriptor.value.CssGroupAllValue");
        boolean myRequiredNonEmpty = ((CssGroupAllValue)descriptor).getRequiredNonEmpty();
        ArrayList<CssValueMatchData> childrenMatchData = new ArrayList<CssValueMatchData>();
        boolean anyMatched = false;
        for (CssValueDescriptor child : ((CssGroupAllValue)descriptor).getChildren()) {
            boolean matched;
            Intrinsics.checkNotNull((Object)child);
            boolean childIsRequired = CssValueDescriptorMapper.Companion.isRequired(child);
            if (separator != null && CssValueDescriptorMapper.Companion.lastIsNotSeparator(childrenMatchData, separator)) {
                CssValueMatchData separatorMatchData = this.mapValue(element2, separator);
                if (separatorMatchData.isMatched()) {
                    childrenMatchData.add(separatorMatchData);
                } else if (childIsRequired) {
                    childrenMatchData.add(separatorMatchData);
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
                    return cssValueMatchData;
                }
                element2 = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element2);
            }
            CssValueMatchData childMatchData = this.mapValue(element2, child);
            boolean bl = matched = element2 != null && (whitespacesShouldBeIgnored || !(element2 instanceof PsiWhiteSpace)) && childMatchData.isMatched();
            if (matched) {
                childrenMatchData.add(childMatchData);
                anyMatched = true;
            } else if (childIsRequired) {
                childrenMatchData.add(childMatchData);
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
                return cssValueMatchData;
            }
            element2 = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element2);
        }
        if (separator != null && CssValueDescriptorMapper.Companion.lastIsSeparator(childrenMatchData, separator)) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
            Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
            return cssValueMatchData;
        }
        if (myRequiredNonEmpty && !anyMatched) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
            Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.success((CssValueDescriptor)descriptor, (List)childrenMatchData);
        Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"success(...)");
        return cssValueMatchData;
    }

    /*
     * Unable to fully structure code
     */
    private final CssValueMatchData mapGroupAnyDescriptor(CssGroupValue descriptor, PsiElement element) {
        restChildrenDescriptors = new ArrayList<CssValueDescriptor>(descriptor.getChildren());
        separator = descriptor.getValuesSeparator();
        whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        element = element;
        childrenMatchData = new ArrayList<CssValueMatchData>();
        first = true;
        while (((Collection)restChildrenDescriptors).isEmpty() == false && (element != null || first)) {
            block19: {
                if (separator == null || !com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper$Companion.access$lastIsNotSeparator(CssValueDescriptorMapper.Companion, childrenMatchData, separator)) break block19;
                separatorMatchData = this.mapValue(element, separator);
                if (separatorMatchData.isMatched()) ** GOTO lbl-1000
                v0 = separatorMatchData.getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDescriptor(...)");
                if (com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper$Companion.access$isRequired(CssValueDescriptorMapper.Companion, v0)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = b = false;
                }
                if (separatorMatchData.isMatched()) ** GOTO lbl-1000
                v2 = separatorMatchData.getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDescriptor(...)");
                if (!com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper$Companion.access$isRequired(CssValueDescriptorMapper.Companion, v2) && com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper$Companion.access$hasRequired(CssValueDescriptorMapper.Companion, restChildrenDescriptors)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = c = false;
                }
                if (separatorMatchData.isMatched()) {
                    childrenMatchData.add(separatorMatchData);
                } else {
                    v4 = separatorMatchData.getDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getDescriptor(...)");
                    if (com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper$Companion.access$isRequired(CssValueDescriptorMapper.Companion, v4) || com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper$Companion.access$hasRequired(CssValueDescriptorMapper.Companion, restChildrenDescriptors)) {
                        childrenMatchData.add(separatorMatchData);
                        v5 = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"fail(...)");
                        return v5;
                    }
                }
                element = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
            }
            if (element == null) {
                for (CssValueDescriptor requiredChild : CssValueDescriptorMapper.Companion.getAllRequired((Collection<CssValueDescriptor>)restChildrenDescriptors)) {
                    childrenMatchData.add(this.match(requiredChild, null));
                }
                v6 = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"fail(...)");
                return v6;
            }
            longestMatchedChildrenData = this.matchAllLongest((Collection<CssValueDescriptor>)restChildrenDescriptors, element);
            if (longestMatchedChildrenData.isEmpty()) {
                if (!first) break;
                v7 = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"fail(...)");
                return v7;
            }
            v8 = CollectionsKt.firstOrNull((Iterable)longestMatchedChildrenData);
            if (v8 == null) {
                var12_16 = "Required value was null.";
                throw new IllegalStateException(var12_16.toString());
            }
            childMatchData = (CssValueMatchData)v8;
            if (longestMatchedChildrenData.size() > 1 && (nextElement = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, CssValueDescriptorMapper.nextElement$default(this, element, whitespacesShouldBeIgnored, null, 4, null))) != null) {
                Intrinsics.checkNotNullExpressionValue(restChildrenDescriptors.iterator(), (String)"iterator(...)");
                while (var12_16.hasNext()) {
                    childDescriptor = (CssValueDescriptor)var12_16.next();
                    Intrinsics.checkNotNull((Object)childDescriptor);
                    nextChildData = this.mapValue(nextElement, childDescriptor);
                    if (!nextChildData.isMatched()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)nextChildData.getDescriptor(), (String)"getDescriptor(...)");
                    iterator = longestMatchedChildrenData.iterator();
                    while (iterator.hasNext()) {
                        matchData = iterator.next();
                        if (!Intrinsics.areEqual((Object)matchData.getDescriptor(), (Object)nextChildDataDescriptor)) continue;
                        iterator.remove();
                    }
                }
                v9 = ContainerUtil.getFirstItem(longestMatchedChildrenData, (Object)childMatchData);
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getFirstItem(...)");
                childMatchData = (CssValueMatchData)v9;
            }
            lastMatched = (CssValueMatchData)CollectionsKt.lastOrNull((List)childrenMatchData);
            childrenMatchData.add(childMatchData);
            if (!childMatchData.isMatched()) {
                if (lastMatched == null) {
                    v10 = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"fail(...)");
                    return v10;
                }
                if (lastMatched.getDescriptor() != separator) {
                    v11 = CssValueMatchData.success((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"success(...)");
                    return v11;
                }
                v12 = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"fail(...)");
                return v12;
            }
            restChildrenDescriptors.remove(childMatchData.getDescriptor());
            element = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
            first = false;
        }
        if (separator != null && com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper$Companion.access$lastIsSeparator(CssValueDescriptorMapper.Companion, childrenMatchData, separator)) {
            v13 = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"fail(...)");
            return v13;
        }
        v14 = CssValueMatchData.success((CssValueDescriptor)descriptor, (List)childrenMatchData);
        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"success(...)");
        return v14;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final CssValueMatchData mapGroupAndDescriptor(CssGroupValue descriptor, PsiElement element) {
        PsiElement element2 = element;
        ArrayList<CssValueDescriptor> restChildrenDescriptors = new ArrayList<CssValueDescriptor>(descriptor.getChildren());
        CssValueDescriptor separator = descriptor.getValuesSeparator();
        ArrayList<CssValueMatchData> childrenMatchData = new ArrayList<CssValueMatchData>();
        boolean whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        boolean first = true;
        while (!((Collection)restChildrenDescriptors).isEmpty() && (element2 != null || first)) {
            first = false;
            if (separator != null && CssValueDescriptorMapper.Companion.lastIsNotSeparator(childrenMatchData, separator)) {
                CssValueMatchData separatorMatchData = this.mapValue(element2, separator);
                childrenMatchData.add(separatorMatchData);
                if (!separatorMatchData.isMatched()) {
                    CssValueDescriptor cssValueDescriptor = separatorMatchData.getDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)cssValueDescriptor, (String)"getDescriptor(...)");
                    if (CssValueDescriptorMapper.Companion.isRequired(cssValueDescriptor) && CssValueDescriptorMapper.Companion.hasRequired(restChildrenDescriptors)) {
                        CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                        Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
                        return cssValueMatchData;
                    }
                }
                element2 = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element2);
            }
            CssValueMatchData childMatchData = null;
            if (element2 == null) {
                CssValueDescriptor optionalChild = CssValueDescriptorMapper.Companion.findFirstOptional(restChildrenDescriptors);
                if (optionalChild == null) {
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
                    return cssValueMatchData;
                }
                childMatchData = CssValueMatchData.success((CssValueDescriptor)optionalChild);
            } else {
                childMatchData = this.matchFirstLongest((Collection<? extends CssValueDescriptor>)restChildrenDescriptors, element2);
            }
            if (childMatchData == null) {
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
                return cssValueMatchData;
            }
            childrenMatchData.add(childMatchData);
            if (!childMatchData.isMatched()) {
                CssValueDescriptor cssValueDescriptor = childMatchData.getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)cssValueDescriptor, (String)"getDescriptor(...)");
                if (CssValueDescriptorMapper.Companion.isRequired(cssValueDescriptor)) {
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
                    return cssValueMatchData;
                }
            }
            restChildrenDescriptors.remove(childMatchData.getDescriptor());
            element2 = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element2);
        }
        if (!((Collection)restChildrenDescriptors).isEmpty() && !((Collection)Companion.getAllRequired((Collection<CssValueDescriptor>)restChildrenDescriptors)).isEmpty()) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
            Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
            return cssValueMatchData;
        }
        if (separator != null && CssValueDescriptorMapper.Companion.lastIsSeparator(childrenMatchData, separator)) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
            Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"fail(...)");
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.success((CssValueDescriptor)descriptor, (List)childrenMatchData);
        Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"success(...)");
        return cssValueMatchData;
    }

    private final CssValueMatchData mapGroupOrDescriptor(CssGroupValue descriptor, PsiElement element) {
        Collection<CssValueDescriptor> collection = descriptor.getChildren();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getChildren(...)");
        boolean required = CssValueDescriptorMapper.Companion.hasRequired(collection);
        if (element == null) {
            return new CssValueMatchData((CssValueDescriptor)descriptor, !required);
        }
        Collection<CssValueDescriptor> collection2 = descriptor.getChildren();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getChildren(...)");
        CssValueMatchData matchData = this.matchFirstLongest(collection2, element);
        if (!(required || matchData != null && matchData.isMatched())) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.success((CssValueDescriptor)descriptor);
            Intrinsics.checkNotNullExpressionValue((Object)cssValueMatchData, (String)"success(...)");
            return cssValueMatchData;
        }
        Object[] objectArray = new CssValueMatchData[]{matchData};
        return new CssValueMatchData((CssValueDescriptor)descriptor, matchData != null && matchData.isMatched(), CollectionsKt.mutableListOf((Object[])objectArray));
    }

    private final Collection<CssValueMatchData> matchAllLongest(Collection<CssValueDescriptor> descriptors, PsiElement element) {
        boolean somethingAlreadyMatched = false;
        LinkedList<CssValueMatchData> result = new LinkedList<CssValueMatchData>();
        int maxWeight = -1;
        for (CssValueDescriptor descriptor : descriptors) {
            int weight;
            CssValueMatchData childData = this.mapValue(element, descriptor);
            if (somethingAlreadyMatched && !childData.isMatched()) continue;
            if (!somethingAlreadyMatched && childData.isMatched()) {
                result.clear();
                somethingAlreadyMatched = true;
            }
            if ((weight = CssValueDescriptorMapper.Companion.weightMatchData(childData)) == maxWeight) {
                result.add(childData);
                continue;
            }
            if (weight <= maxWeight) continue;
            maxWeight = weight;
            result.clear();
            result.add(childData);
        }
        return result;
    }

    private final CssValueMatchData matchFirstLongest(Collection<? extends CssValueDescriptor> descriptors, PsiElement element) {
        CssValueMatchData matchedLongestResult = null;
        CssValueMatchData unmatchedLongestResult = null;
        for (CssValueDescriptor cssValueDescriptor : descriptors) {
            CssValueMatchData data = this.mapValue(element, cssValueDescriptor);
            if (data.isMatched()) {
                matchedLongestResult = CssValueDescriptorMapper.Companion.compareAndGetMostMatched(matchedLongestResult, data);
                continue;
            }
            unmatchedLongestResult = CssValueDescriptorMapper.Companion.compareAndGetMostMatched(unmatchedLongestResult, data);
        }
        return (CssValueMatchData)ObjectUtils.chooseNotNull(matchedLongestResult, unmatchedLongestResult);
    }

    private final PsiElement nextElement(PsiElement element, boolean whitespacesShouldBeIgnored, PsiElement defaultElement) {
        PsiElement firstChild;
        PsiElement parent;
        Class[] classArray;
        CssElement parentTermList;
        PsiElement element2 = element;
        if (element2 == null) {
            return defaultElement;
        }
        PsiElement nextSibling = this.nextVisibleSibling(element2, whitespacesShouldBeIgnored);
        PsiElement varTerm = Companion.getVarFunctionTermElementIfIsLastFallbackTerm(element2);
        if (varTerm != null) {
            element2 = varTerm;
            nextSibling = this.nextVisibleSibling(varTerm, whitespacesShouldBeIgnored);
        }
        if (nextSibling == null && (parentTermList = (CssElement)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])(classArray = new Class[]{CssTermList.class, CssTerm.class}))) != null && (nextSibling = this.nextVisibleSibling((PsiElement)parentTermList, whitespacesShouldBeIgnored)) == null && (parent = parentTermList.getParent()) instanceof CssTerm) {
            nextSibling = this.nextVisibleSibling(parent, whitespacesShouldBeIgnored);
        }
        if (nextSibling instanceof CssTerm && (firstChild = ((CssTerm)nextSibling).getFirstChild()) instanceof CssTermList) {
            return CssPsiUtilCore.getFirstDeepestTerm(((CssTerm)nextSibling).getFirstChild());
        }
        return CssPsiUtilCore.getFirstDeepestTerm(nextSibling);
    }

    static /* synthetic */ PsiElement nextElement$default(CssValueDescriptorMapper cssValueDescriptorMapper, PsiElement psiElement, boolean bl, PsiElement psiElement2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextElement");
        }
        if ((n & 4) != 0) {
            psiElement2 = null;
        }
        return cssValueDescriptorMapper.nextElement(psiElement, bl, psiElement2);
    }

    private final PsiElement nextVisibleSibling(PsiElement element, boolean whitespacesShouldBeIgnored) {
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (Intrinsics.areEqual((Object)nextSibling, (Object)this.myStopElement)) {
                return nextSibling;
            }
            if (this.myStopElement != null && nextSibling.getTextRange().getEndOffset() > this.myStopElement.getTextRange().getEndOffset()) {
                return null;
            }
            if (nextSibling instanceof PsiComment || whitespacesShouldBeIgnored && nextSibling instanceof PsiWhiteSpace) continue;
            return nextSibling;
        }
        return null;
    }

    static {
        Logger logger = Logger.getInstance(CssValueDescriptorMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u0012\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001d\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00192\b\u0010 \u001a\u0004\u0018\u00010\u0019J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0019H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0010H\u0002J\u0016\u0010&\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "compareAndGetMostMatched", "Lcom/intellij/psi/css/descriptor/value/CssValueMatchData;", "first", "second", "lastIsNotSeparator", "", "childrenMatchData", "", "separator", "Lcom/intellij/psi/css/descriptor/value/CssValueDescriptor;", "lastIsSeparator", "findFirstOptional", "descriptors", "", "getAllRequired", "", "isVarFunction", "element", "Lcom/intellij/psi/PsiElement;", "getVarFallbackTerms", "", "Lcom/intellij/psi/css/CssTerm;", "maybeVarTerm", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/css/CssTerm;", "getVarFunctionTermElementIfIsLastFallbackTerm", "varFallbackTerm", "getValueValidator", "Lcom/intellij/psi/css/descriptor/value/CssValueValidator;", "context", "isRequired", "descriptor", "hasRequired", "weightMatchData", "", "matchData", "intellij.css.common.psi"})
    @SourceDebugExtension(value={"SMAP\nCssValueDescriptorMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssValueDescriptorMapper.kt\ncom/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,609:1\n1#2:610\n777#3:611\n873#3,2:612\n1807#3,3:614\n*S KotlinDebug\n*F\n+ 1 CssValueDescriptorMapper.kt\ncom/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper$Companion\n*L\n541#1:611\n541#1:612,2\n601#1:614,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final CssValueMatchData compareAndGetMostMatched(CssValueMatchData first, CssValueMatchData second) {
            if (first == null && second == null) {
                return null;
            }
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            PsiElement firstLastMatchedElement = first.getLastMatchedElement();
            PsiElement secondLastMatchedElement = second.getLastMatchedElement();
            if (firstLastMatchedElement == null) {
                return second;
            }
            if (secondLastMatchedElement == null) {
                return first;
            }
            return firstLastMatchedElement.getTextRange().getEndOffset() >= secondLastMatchedElement.getTextRange().getEndOffset() ? first : second;
        }

        private final boolean lastIsNotSeparator(List<CssValueMatchData> childrenMatchData, CssValueDescriptor separator) {
            CssValueMatchData lastMatched = (CssValueMatchData)CollectionsKt.lastOrNull(childrenMatchData);
            return lastMatched != null && lastMatched.getDescriptor() != separator;
        }

        private final boolean lastIsSeparator(List<CssValueMatchData> childrenMatchData, CssValueDescriptor separator) {
            CssValueMatchData lastMatched = (CssValueMatchData)CollectionsKt.lastOrNull(childrenMatchData);
            return lastMatched != null && lastMatched.getDescriptor() == separator;
        }

        private final CssValueDescriptor findFirstOptional(Collection<CssValueDescriptor> descriptors) {
            Object v0;
            block1: {
                Iterable iterable = descriptors;
                for (Object t : iterable) {
                    CssValueDescriptor it = (CssValueDescriptor)t;
                    boolean bl = false;
                    if (!(!Companion.isRequired(it))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<CssValueDescriptor> getAllRequired(@NotNull Collection<CssValueDescriptor> descriptors) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Iterable $this$filter$iv = descriptors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CssValueDescriptor it = (CssValueDescriptor)element$iv$iv;
                boolean bl = false;
                if (!Companion.isRequired(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isVarFunction(PsiElement element) {
            return element instanceof CssFunction && Intrinsics.areEqual((Object)((CssFunction)element).getName(), (Object)"var");
        }

        @Nullable
        public final CssTerm[] getVarFallbackTerms(@Nullable PsiElement maybeVarTerm) {
            PsiElement maybeNestedVarFunction;
            CssTerm maybeNestedVarTerm;
            Object[] terms;
            CssTermList termList;
            if (maybeVarTerm == null) {
                return null;
            }
            PsiElement maybeVarFunction = maybeVarTerm.getFirstChild();
            if (!this.isVarFunction(maybeVarFunction)) {
                return null;
            }
            Intrinsics.checkNotNull((Object)maybeVarFunction, (String)"null cannot be cast to non-null type com.intellij.psi.css.CssFunction");
            CssTermList cssTermList = termList = ((CssFunction)maybeVarFunction).getValue();
            Object object = terms = cssTermList != null ? cssTermList.getTerms() : null;
            if (terms == null || terms.length < 2) {
                return null;
            }
            CssTerm[] fallbackTerms = (CssTerm[])ArraysKt.copyOfRange((Object[])terms, (int)1, (int)terms.length);
            CssTerm cssTerm = maybeNestedVarTerm = fallbackTerms != null ? fallbackTerms[0] : null;
            Object object2 = maybeNestedVarFunction = cssTerm != null ? cssTerm.getFirstChild() : null;
            boolean bl = fallbackTerms != null ? fallbackTerms.length == 1 : false;
            if (bl && this.isVarFunction(maybeNestedVarFunction)) {
                fallbackTerms = this.getVarFallbackTerms((PsiElement)maybeNestedVarTerm);
            }
            return fallbackTerms;
        }

        @Nullable
        public final PsiElement getVarFunctionTermElementIfIsLastFallbackTerm(@Nullable PsiElement varFallbackTerm) {
            PsiElement maybeVarFunction;
            PsiElement termList;
            if (varFallbackTerm == null) {
                return null;
            }
            PsiElement psiElement = termList = varFallbackTerm.getParent();
            Object object = maybeVarFunction = psiElement != null ? psiElement.getParent() : null;
            if (this.isVarFunction(maybeVarFunction)) {
                Intrinsics.checkNotNull((Object)termList, (String)"null cannot be cast to non-null type com.intellij.psi.css.CssTermList");
                CssTerm[] cssTermArray = ((CssTermList)termList).getTerms();
                Intrinsics.checkNotNullExpressionValue((Object)cssTermArray, (String)"getTerms(...)");
                CssTerm[] terms = cssTermArray;
                if (terms.length > 1 && Intrinsics.areEqual((Object)terms[terms.length - 1], (Object)varFallbackTerm)) {
                    PsiElement psiElement2 = maybeVarFunction;
                    Intrinsics.checkNotNull((Object)psiElement2);
                    return this.getVarFunctionTermElementIfIsLastFallbackTerm(psiElement2.getParent());
                }
            }
            if (this.isVarFunction(varFallbackTerm.getFirstChild())) {
                return varFallbackTerm;
            }
            return null;
        }

        private final CssValueValidator getValueValidator(PsiElement context) {
            CssElementDescriptorProvider provider = CssDescriptorsUtilCore.findDescriptorProvider(context);
            if (provider == null) {
                return new CssValueValidatorStub();
            }
            CssValueValidator cssValueValidator = provider.getValueValidator();
            Intrinsics.checkNotNullExpressionValue((Object)cssValueValidator, (String)"getValueValidator(...)");
            return cssValueValidator;
        }

        private final boolean isRequired(CssValueDescriptor descriptor) {
            return descriptor.getMinOccur() != 0;
        }

        private final boolean hasRequired(Collection<CssValueDescriptor> descriptors) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = descriptors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CssValueDescriptor descriptor = (CssValueDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!(descriptor.getMinOccur() == 0)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return !bl;
        }

        private final int weightMatchData(CssValueMatchData matchData) {
            PsiElement lastMatchedElement;
            PsiElement psiElement = lastMatchedElement = matchData.getLastMatchedElement();
            return psiElement != null ? psiElement.getTextRange().getEndOffset() : -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CssGroupValue.Type.values().length];
            try {
                nArray[CssGroupValue.Type.OR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CssGroupValue.Type.AND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CssGroupValue.Type.ANY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CssGroupValue.Type.ALL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

