/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsConfigValueSearcher;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlKeyValueProcessor;", "Lcom/intellij/util/Processor;", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "params", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "processor", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "<init>", "(Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;Lcom/intellij/util/Processor;)V", "keyName", "", "Lorg/jetbrains/annotations/NotNull;", "process", "", "yamlKeyValue", "intellij.quarkus.config.yaml"})
@SourceDebugExtension(value={"SMAP\nQsYamlConfigFileContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsYamlConfigFileContributor.kt\ncom/intellij/quarkus/config/yaml/QsYamlKeyValueProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1642#2,10:139\n1915#2:149\n1916#2:151\n1652#2:152\n1586#2:153\n1661#2,3:154\n1786#2,3:157\n1#3:150\n*S KotlinDebug\n*F\n+ 1 QsYamlConfigFileContributor.kt\ncom/intellij/quarkus/config/yaml/QsYamlKeyValueProcessor\n*L\n128#1:139,10\n128#1:149\n128#1:151\n128#1:152\n129#1:153\n129#1:154,3\n133#1:157,3\n128#1:150\n*E\n"})
final class QsYamlKeyValueProcessor
implements Processor<YAMLKeyValue> {
    @NotNull
    private final QsConfigValueSearcher.QsConfigValueSearchParams params;
    @NotNull
    private final Processor<? super QsConfigValueSearcher.QsConfigValueResult> processor;
    @NotNull
    private final String keyName;

    public QsYamlKeyValueProcessor(@NotNull QsConfigValueSearcher.QsConfigValueSearchParams params, @NotNull Processor<? super QsConfigValueSearcher.QsConfigValueResult> processor2) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.params = params;
        this.processor = processor2;
        String string = this.params.getConfigKey().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.keyName = string;
    }

    /*
     * WARNING - void declaration
     */
    public boolean process(@NotNull YAMLKeyValue yamlKeyValue) {
        Intrinsics.checkNotNullParameter((Object)yamlKeyValue, (String)"yamlKeyValue");
        ProgressManager.checkCanceled();
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedConfigKeyName(...)");
        String originalKey = string;
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED};
        boolean isIndexed = this.params.getConfigKey().isAccessType(accessTypeArray);
        String keyWithoutIndex = isIndexed ? QsConfigUtils.INSTANCE.trimIndex(originalKey) : originalKey;
        String qualifiedKeyName = QsConfigUtils.INSTANCE.trimProfile(keyWithoutIndex);
        if (Intrinsics.areEqual((Object)qualifiedKeyName, (Object)this.keyName)) {
            boolean bl;
            block11: {
                void $this$mapTo$iv$iv;
                List list;
                Object element$iv$iv$iv;
                Iterable destination$iv$iv;
                PsiElement psiElement = yamlKeyValue.getKey();
                if (psiElement == null) {
                    return true;
                }
                PsiElement keyElement = psiElement;
                YAMLValue valueElement = yamlKeyValue.getValue();
                if (valueElement instanceof YAMLMapping) {
                    return true;
                }
                if (valueElement instanceof YAMLSequence && isIndexed) {
                    void $this$mapNotNullTo$iv$iv;
                    List list2 = ((YAMLSequence)valueElement).getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                    Iterable $this$mapNotNull$iv = list2;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        YAMLSequenceItem it = (YAMLSequenceItem)element$iv$iv;
                        boolean bl3 = false;
                        YAMLValue yAMLValue = it.getValue();
                        if ((yAMLValue != null ? yAMLValue.getText() : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    YAMLValue yAMLValue = valueElement;
                    list = CollectionsKt.listOfNotNull((Object)(yAMLValue != null ? yAMLValue.getText() : null));
                }
                List valueTexts = list;
                Iterable $this$map$iv = valueTexts;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void valueText;
                    element$iv$iv$iv = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl5 = false;
                    String string2 = ConfigYamlUtils.sanitizeNumberValueIfNeeded((String)valueText, () -> QsYamlKeyValueProcessor.process$lambda$1$0(this));
                    if (string2 == null) {
                        string2 = valueText;
                    }
                    collection.add(string2);
                }
                List sanitizedTexts = (List)destination$iv$iv2;
                Iterable $this$all$iv = sanitizedTexts;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl6 = false;
                        if (this.processor.process((Object)new QsConfigValueSearcher.QsConfigValueResult(keyElement, (PsiElement)valueElement, it, this.params))) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return true;
    }

    private static final PsiType process$lambda$1$0(QsYamlKeyValueProcessor this$0) {
        return this$0.params.getConfigKey().getEffectiveValueElementType();
    }
}

