/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.gradle;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.execution.jar.JarApplicationConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.gradle.QsGradleJarBuildUtilsKt;
import com.intellij.quarkus.gradle.QsGradleRunConfiguration;
import com.intellij.quarkus.run.QsRunConfiguration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tH\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"isQuarkusGradleRunConfig", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "prepareJarRunConfigurationSettings", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "onReady", "Lkotlin/Function1;", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "createJarRunConfiguration", "Lcom/intellij/execution/jar/JarApplicationConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.quarkus.gradle"})
@SourceDebugExtension(value={"SMAP\nQsGradleRunUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsGradleRunUtils.kt\ncom/intellij/quarkus/gradle/QsGradleRunUtilsKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,36:1\n19#2:37\n19#2:38\n*S KotlinDebug\n*F\n+ 1 QsGradleRunUtils.kt\ncom/intellij/quarkus/gradle/QsGradleRunUtilsKt\n*L\n20#1:37\n35#1:38\n*E\n"})
public final class QsGradleRunUtilsKt {
    public static final boolean isQuarkusGradleRunConfig(@NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof QsRunConfiguration && ((QsRunConfiguration)profile).getDelegateConfiguration() instanceof QsGradleRunConfiguration;
    }

    public static final void prepareJarRunConfigurationSettings(@NotNull ExecutionEnvironment environment, @NotNull Function1<? super RunnerAndConfigurationSettings, Unit> onReady) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(onReady, (String)"onReady");
        RunProfile $this$asSafely$iv = environment.getRunProfile();
        boolean $i$f$asSafely = false;
        RunProfile runProfile = $this$asSafely$iv;
        if (!(runProfile instanceof QsRunConfiguration)) {
            runProfile = null;
        }
        QsRunConfiguration qsRunConfiguration = (QsRunConfiguration)runProfile;
        if (qsRunConfiguration == null) {
            return;
        }
        QsRunConfiguration qsRunConfiguration2 = qsRunConfiguration;
        Project project = qsRunConfiguration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        QsGradleJarBuildUtilsKt.buildQuarkusJar(qsRunConfiguration2, (Function0<Unit>)((Function0)() -> QsGradleRunUtilsKt.prepareJarRunConfigurationSettings$lambda$0(project2, qsRunConfiguration2, onReady)));
    }

    @Nullable
    public static final JarApplicationConfiguration createJarRunConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunConfiguration $this$asSafely$iv = JarApplicationConfigurationType.getInstance().createTemplateConfiguration(project);
        boolean $i$f$asSafely = false;
        RunConfiguration runConfiguration = $this$asSafely$iv;
        if (!(runConfiguration instanceof JarApplicationConfiguration)) {
            runConfiguration = null;
        }
        return (JarApplicationConfiguration)runConfiguration;
    }

    private static final Unit prepareJarRunConfigurationSettings$lambda$0(Project $project, QsRunConfiguration $qsRunConfiguration, Function1 $onReady) {
        JarApplicationConfiguration jarApplicationConfiguration = QsGradleRunUtilsKt.createJarRunConfiguration($project);
        if (jarApplicationConfiguration == null) {
            return Unit.INSTANCE;
        }
        JarApplicationConfiguration jarAppRunConfiguration = jarApplicationConfiguration;
        jarAppRunConfiguration.setJarPath(QsGradleJarBuildUtilsKt.getQsJarPath());
        jarAppRunConfiguration.setName($qsRunConfiguration.getName());
        RunManager runManager = RunManager.Companion.getInstance($project);
        RunConfiguration runConfiguration = (RunConfiguration)jarAppRunConfiguration;
        ConfigurationFactory configurationFactory = jarAppRunConfiguration.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory);
        $onReady.invoke((Object)runManager.createConfiguration(runConfiguration, configurationFactory));
        return Unit.INSTANCE;
    }
}

