/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.maven;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.externalSystem.service.execution.cmd.ParametersListLexer;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.maven.QsMavenRunConfiguration;
import com.intellij.quarkus.run.QsRunUtilsKt;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\b\u0010\u0017\u001a\u00020\bH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/quarkus/maven/QsMavenRunConfigurationSettingsEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "mainPanel", "Ljavax/swing/JComponent;", "argumentsEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "profilesEditor", "Lcom/intellij/ui/EditorTextField;", "emulateTerminalCheckBox", "Ljavax/swing/JCheckBox;", "resolveToWorkspaceCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "isEmulationAvailable", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "resetEditorFrom", "", "s", "applyEditorTo", "createEditor", "intellij.quarkus.maven"})
@SourceDebugExtension(value={"SMAP\nQsMavenRunConfigurationSettingsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsMavenRunConfigurationSettingsEditor.kt\ncom/intellij/quarkus/maven/QsMavenRunConfigurationSettingsEditor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,137:1\n19#2:138\n19#2:139\n*S KotlinDebug\n*F\n+ 1 QsMavenRunConfigurationSettingsEditor.kt\ncom/intellij/quarkus/maven/QsMavenRunConfigurationSettingsEditor\n*L\n106#1:138\n133#1:139\n*E\n"})
public final class QsMavenRunConfigurationSettingsEditor
extends SettingsEditor<MavenRunConfiguration> {
    @NotNull
    private final JComponent mainPanel;
    @NotNull
    private final RawCommandLineEditor argumentsEditor;
    @NotNull
    private final EditorTextField profilesEditor;
    @NotNull
    private final JCheckBox emulateTerminalCheckBox;
    private JBCheckBox resolveToWorkspaceCheckBox;
    @NotNull
    private final AtomicBooleanProperty isEmulationAvailable;

    public QsMavenRunConfigurationSettingsEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.argumentsEditor = new RawCommandLineEditor();
        this.emulateTerminalCheckBox = new JCheckBox(QuarkusBundle.message("run.configuration.emulate.terminal", new Object[0]));
        this.isEmulationAvailable = new AtomicBooleanProperty(QsRunUtilsKt.isTerminalEmulationAvailable());
        if (project.isDefault()) {
            this.profilesEditor = new EditorTextField();
        } else {
            TextFieldCompletionProvider profilesCompletionProvider2 = new TextFieldCompletionProvider(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(true);
                }

                protected void addCompletionVariants(String text, int offset, String prefix, CompletionResultSet result) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    MavenProjectsManager manager = MavenProjectsManager.getInstance((Project)this.$project);
                    for (String profile : manager.getAvailableProfiles()) {
                        String[] stringArray = new String[]{profile};
                        result.addElement((LookupElement)LookupElementBuilder.create((String)ParametersListUtil.join((String[])stringArray)));
                    }
                }

                protected String getPrefix(String currentTextPrefix) {
                    Intrinsics.checkNotNullParameter((Object)currentTextPrefix, (String)"currentTextPrefix");
                    ParametersListLexer lexer = new ParametersListLexer(currentTextPrefix);
                    while (lexer.nextToken()) {
                        String string;
                        String prefix;
                        block4: {
                            block3: {
                                if (lexer.getTokenEnd() != currentTextPrefix.length()) continue;
                                string = prefix = lexer.getCurrentToken();
                                Intrinsics.checkNotNull((Object)string);
                                if (StringsKt.startsWith$default((String)string, (String)"-", (boolean)false, (int)2, null)) break block3;
                                string = prefix;
                                Intrinsics.checkNotNull((Object)string);
                                if (!StringsKt.startsWith$default((String)string, (String)"!", (boolean)false, (int)2, null)) break block4;
                            }
                            string = prefix;
                            Intrinsics.checkNotNull((Object)string);
                            int n = 1;
                            String string2 = string.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            prefix = string2;
                        }
                        string = prefix;
                        Intrinsics.checkNotNull((Object)string);
                        return string;
                    }
                    return "";
                }
            };
            EditorTextField editorTextField = profilesCompletionProvider2.createEditor(project);
            Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"createEditor(...)");
            this.profilesEditor = editorTextField;
        }
        this.mainPanel = (JComponent)BuilderKt.panel(arg_0 -> QsMavenRunConfigurationSettingsEditor._init_$lambda$0(this, arg_0));
    }

    protected void resetEditorFrom(@NotNull MavenRunConfiguration s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.argumentsEditor.setText(s.getRunnerParameters().getCmdOptions());
        MavenRunnerParameters mavenRunnerParameters = s.getRunnerParameters();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"getRunnerParameters(...)");
        MavenRunnerParameters runnerParameters = mavenRunnerParameters;
        ParametersList parametersList = new ParametersList();
        for (Map.Entry entry : runnerParameters.getProfilesMap().entrySet()) {
            Object profileName = (String)entry.getKey();
            Object v = entry.getValue();
            Intrinsics.checkNotNull(v);
            if (!((Boolean)v).booleanValue()) {
                profileName = "-" + (String)profileName;
            }
            parametersList.add((String)profileName);
        }
        this.profilesEditor.setText(parametersList.getParametersString());
        JBCheckBox jBCheckBox = this.resolveToWorkspaceCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resolveToWorkspaceCheckBox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(runnerParameters.isResolveToWorkspace());
        MavenRunConfiguration $this$asSafely$iv = s;
        boolean $i$f$asSafely = false;
        MavenRunConfiguration mavenRunConfiguration = $this$asSafely$iv;
        if (!(mavenRunConfiguration instanceof QsMavenRunConfiguration)) {
            mavenRunConfiguration = null;
        }
        QsMavenRunConfiguration qsMavenRunConfiguration = (QsMavenRunConfiguration)mavenRunConfiguration;
        this.emulateTerminalCheckBox.setSelected(qsMavenRunConfiguration != null ? qsMavenRunConfiguration.getEmulateTerminal() : false);
    }

    protected void applyEditorTo(@NotNull MavenRunConfiguration s) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            MavenRunnerParameters mavenRunnerParameters = s.getRunnerParameters();
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"getRunnerParameters(...)");
            MavenRunnerParameters runnerParameters = mavenRunnerParameters;
            runnerParameters.setCmdOptions(this.argumentsEditor.getText());
            LinkedHashMap profilesMap = new LinkedHashMap();
            List list = ParametersListUtil.parse((String)this.profilesEditor.getText());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
            List profiles = list;
            Iterator iterator = profiles.iterator();
            while (iterator.hasNext()) {
                String profile;
                String key = profile = (String)iterator.next();
                boolean isEnabled = true;
                Intrinsics.checkNotNull((Object)profile);
                if (StringsKt.startsWith$default((String)profile, (String)"-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)profile, (String)"!", (boolean)false, (int)2, null)) {
                    String string = profile.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    key = string;
                    if (((CharSequence)profile).length() == 0) continue;
                    isEnabled = false;
                }
                ((Map)profilesMap).put(key, isEnabled);
            }
            runnerParameters.setProfilesMap((Map)profilesMap);
            JBCheckBox jBCheckBox = this.resolveToWorkspaceCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resolveToWorkspaceCheckBox");
                jBCheckBox = null;
            }
            runnerParameters.setResolveToWorkspace(jBCheckBox.isSelected());
            if (s.getRunnerSettings() == null) {
                s.setRunnerSettings(new MavenRunnerSettings());
            }
            MavenRunConfiguration $this$asSafely$iv = s;
            boolean $i$f$asSafely = false;
            MavenRunConfiguration mavenRunConfiguration = $this$asSafely$iv;
            if (!(mavenRunConfiguration instanceof QsMavenRunConfiguration)) {
                mavenRunConfiguration = null;
            }
            QsMavenRunConfiguration qsMavenRunConfiguration = (QsMavenRunConfiguration)mavenRunConfiguration;
            if (qsMavenRunConfiguration == null) break block5;
            qsMavenRunConfiguration.setEmulateTerminal(this.emulateTerminalCheckBox.isSelected());
        }
    }

    @NotNull
    protected JComponent createEditor() {
        return this.mainPanel;
    }

    private static final Unit lambda$0$2$0(JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(MavenConfigurableBundle.message((String)"maven.settings.runner.resolve.workspace.artifacts.tooltip", (Object[])new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(QsMavenRunConfigurationSettingsEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.argumentsEditor).align((Align)AlignX.FILL.INSTANCE), (String)"\"-Dquarkus.args=Quarkus args\"", (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(QsMavenRunConfigurationSettingsEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.profilesEditor).align((Align)AlignX.FILL.INSTANCE), (String)MavenConfigurableBundle.message((String)"maven.settings.runner.profiles.notes", (Object[])new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(QsMavenRunConfigurationSettingsEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = MavenConfigurableBundle.message((String)"maven.settings.runner.resolve.workspace.artifacts", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.resolveToWorkspaceCheckBox = (JBCheckBox)$this$row.checkBox(string).applyToComponent(QsMavenRunConfigurationSettingsEditor::lambda$0$2$0).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$3(QsMavenRunConfigurationSettingsEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.emulateTerminalCheckBox);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(QsMavenRunConfigurationSettingsEditor this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> QsMavenRunConfigurationSettingsEditor.lambda$0$0(this$0, arg_0));
        $this$panel.row(MavenConfigurableBundle.message((String)"maven.settings.runner.profiles", (Object[])new Object[0]) + ":", arg_0 -> QsMavenRunConfigurationSettingsEditor.lambda$0$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> QsMavenRunConfigurationSettingsEditor.lambda$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> QsMavenRunConfigurationSettingsEditor.lambda$0$3(this$0, arg_0), (int)1, null).visibleIf((ObservableProperty)this$0.isEmulationAvailable);
        return Unit.INSTANCE;
    }
}

