/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.TextMateByteRange;
import org.jetbrains.plugins.textmate.regex.TextMateCharRange;
import org.jetbrains.plugins.textmate.regex.TextMateRangeKt;
import org.jetbrains.plugins.textmate.regex.TextMateString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0014\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0015\u001a\u00020\u000bH\u0096\u0080\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/textmate/regex/MatchData;", "", "matched", "", "byteOffsets", "", "<init>", "(Z[I)V", "getMatched", "()Z", "count", "", "byteRange", "Lorg/jetbrains/plugins/textmate/regex/TextMateByteRange;", "group", "charRange", "Lorg/jetbrains/plugins/textmate/regex/TextMateCharRange;", "textMateString", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "equals", "other", "hashCode", "toString", "", "component1", "component2", "copy", "Companion", "intellij.textmate.core"})
public final class MatchData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean matched;
    @NotNull
    private final int[] byteOffsets;
    @NotNull
    private static final MatchData NOT_MATCHED = new MatchData(false, new int[0]);

    public MatchData(boolean matched, @NotNull int[] byteOffsets) {
        Intrinsics.checkNotNullParameter((Object)byteOffsets, (String)"byteOffsets");
        this.matched = matched;
        this.byteOffsets = byteOffsets;
    }

    public final boolean getMatched() {
        return this.matched;
    }

    public final int count() {
        return this.byteOffsets.length / 2;
    }

    @NotNull
    public final TextMateByteRange byteRange(int group) {
        int endIndex = group * 2 + 1;
        return new TextMateByteRange(TextMateRangeKt.byteOffset(this.byteOffsets[endIndex - 1]), TextMateRangeKt.byteOffset(this.byteOffsets[endIndex]), null);
    }

    public static /* synthetic */ TextMateByteRange byteRange$default(MatchData matchData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return matchData.byteRange(n);
    }

    @NotNull
    public final TextMateCharRange charRange(@NotNull TextMateString textMateString, int group) {
        Intrinsics.checkNotNullParameter((Object)textMateString, (String)"textMateString");
        return textMateString.charRangeByByteRange(this.byteRange(group));
    }

    public static /* synthetic */ TextMateCharRange charRange$default(MatchData matchData, TextMateString textMateString, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return matchData.charRange(textMateString, n);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        MatchData matchData = (MatchData)other;
        if (this.matched != matchData.matched) {
            return false;
        }
        return Arrays.equals(this.byteOffsets, matchData.byteOffsets);
    }

    public int hashCode() {
        return 31 * (this.matched ? 1 : 0) + Arrays.hashCode(this.byteOffsets);
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.byteOffsets);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "{ matched=" + this.matched + ", offsets=" + string + " }";
    }

    public final boolean component1() {
        return this.matched;
    }

    private final int[] component2() {
        return this.byteOffsets;
    }

    @NotNull
    public final MatchData copy(boolean matched, @NotNull int[] byteOffsets) {
        Intrinsics.checkNotNullParameter((Object)byteOffsets, (String)"byteOffsets");
        return new MatchData(matched, byteOffsets);
    }

    public static /* synthetic */ MatchData copy$default(MatchData matchData, boolean bl, int[] nArray, int n, Object object) {
        if ((n & 1) != 0) {
            bl = matchData.matched;
        }
        if ((n & 2) != 0) {
            nArray = matchData.byteOffsets;
        }
        return matchData.copy(bl, nArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/textmate/regex/MatchData$Companion;", "", "<init>", "()V", "NOT_MATCHED", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "getNOT_MATCHED", "()Lorg/jetbrains/plugins/textmate/regex/MatchData;", "intellij.textmate.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MatchData getNOT_MATCHED() {
            return NOT_MATCHED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

