/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.common.CommonElementLocationFeaturesKt;
import com.intellij.completion.ml.common.LocationFeaturesUtil;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J,\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/common/CommonElementLocationFeatures;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "<init>", "()V", "getName", "", "calculateFeatures", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "intellij.completionMlRanking"})
public final class CommonElementLocationFeatures
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "common";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Map result;
        block4: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
            result = new LinkedHashMap();
            PsiElement completionElement = element.getPsiElement();
            PsiElement psiElement = completionElement;
            if (!(psiElement != null && (psiElement = psiElement.getLanguage()) != null ? psiElement.isKindOf("ruby") : false)) {
                CompletionParameters completionParameters = location.getCompletionParameters();
                Intrinsics.checkNotNullExpressionValue((Object)completionParameters, (String)"getCompletionParameters(...)");
                Integer linesDiff = LocationFeaturesUtil.INSTANCE.linesDiff(completionParameters, completionElement);
                if (linesDiff != null) {
                    result.put("lines_diff", MLFeatureValue.Companion.float(linesDiff.intValue()));
                }
            }
            PsiElement psiElement2 = completionElement;
            if (psiElement2 != null) {
                PsiElement it = psiElement2;
                boolean bl = false;
                result.put("item_class", MLFeatureValue.Companion.className$default((MLFeatureValue.Companion)MLFeatureValue.Companion, it.getClass(), (boolean)false, (int)2, null));
            }
            CompletionContributor completionContributor = (CompletionContributor)element.getUserData(BaseCompletionService.LOOKUP_ELEMENT_CONTRIBUTOR);
            if (completionContributor == null) break block4;
            CompletionContributor it = completionContributor;
            boolean bl = false;
            Class<?> actualCompletionContributor = (Class<?>)element.getUserData(CommonElementLocationFeaturesKt.getLOOKUP_ORIGINAL_ELEMENT_CONTRIBUTOR_TYPE());
            Class<?> clazz = actualCompletionContributor;
            if (clazz == null) {
                clazz = it.getClass();
            }
            result.put("contributor", MLFeatureValue.Companion.className$default((MLFeatureValue.Companion)MLFeatureValue.Companion, clazz, (boolean)false, (int)2, null));
        }
        return result;
    }
}

