/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.frontend.permissions;

import com.intellij.cwm.frontend.CodeWithMeFrontendBundle;
import com.intellij.cwm.frontend.permissions.IconWithModificator;
import com.intellij.cwm.frontend.permissions.ThinClientActionTooltip;
import com.intellij.cwm.plugin.common.permissions.AccessLevel;
import com.intellij.cwm.plugin.common.permissions.UnknownAccessLevel;
import com.intellij.cwm.plugin.common.permissions.UtilKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.remoting.PermissionsKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.frontend.split.FrontendProcessInfo;
import com.intellij.ui.LayeredIcon;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsRequestLevel;
import com.jetbrains.rdclient.actions.cwm.FrontendPresentationDecorator;
import com.jetbrains.thinclient.services.ThinClientPermissionHost;
import com.jetbrains.thinclient.services.ThinClientPermissionInteractionManager;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002J\"\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\rH\u0002J*\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/cwm/frontend/permissions/CWMPermissionDecorator;", "Lcom/jetbrains/rdclient/actions/cwm/FrontendPresentationDecorator;", "<init>", "()V", "decorate", "", "backendActionId", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isPopupPlace", "", "shouldSkip", "isDecorated", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "isInPopup", "hostOnly", "isTextDecorated", "isIconDecorated", "decorateHostOnly", "decorateNotPermitted", "place", "restorePresentation", "getDisabledIcon", "Ljavax/swing/Icon;", "Companion", "intellij.cwm.frontend"})
@SourceDebugExtension(value={"SMAP\nCWMPermissionDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CWMPermissionDecorator.kt\ncom/intellij/cwm/frontend/permissions/CWMPermissionDecorator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
public final class CWMPermissionDecorator
implements FrontendPresentationDecorator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<String> decoratedTextKey;
    @NotNull
    private static final Key<Icon> originalIconKey;
    @NotNull
    private static final Key<Icon> originalDisabledIconKey;
    @NotNull
    private static final Key<HelpTooltip> originalTooltipKey;

    public void decorate(@NotNull String backendActionId, @Nullable AnAction action, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)backendActionId, (String)"backendActionId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Registry.Companion.is("ide.permissions.api.enabled")) {
            return;
        }
        if (!FrontendProcessInfo.INSTANCE.isGuest() || this.shouldSkip(backendActionId)) {
            return;
        }
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        String string = event.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        String place = string;
        AccessRequirements accessRequirements = ThinClientPermissionHost.Companion.getInstance().getAccessRequirements(backendActionId, action);
        if (accessRequirements == null) {
            return;
        }
        AccessRequirements requirements = accessRequirements;
        if (ThinClientPermissionHost.Companion.getInstance().areSatisfied(requirements)) {
            this.restorePresentation(presentation2);
            return;
        }
        boolean isInPopup = this.isPopupPlace(event);
        if (Intrinsics.areEqual((Object)requirements, (Object)AccessRequirements.Owner.INSTANCE)) {
            presentation2.setEnabled(false);
            if (!this.isDecorated(presentation2, isInPopup, true)) {
                this.decorateHostOnly(presentation2, action, isInPopup);
            }
        } else {
            if (!ActionPlaces.isShortcutPlace((String)place)) {
                presentation2.setEnabled(isInPopup);
            }
            if (!this.isDecorated(presentation2, isInPopup, false)) {
                this.decorateNotPermitted(presentation2, action, isInPopup, place);
            }
        }
    }

    public void decorate(@Nullable AnAction action, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Registry.Companion.is("ide.permissions.api.enabled")) {
            return;
        }
        if (!FrontendProcessInfo.INSTANCE.isGuest()) {
            return;
        }
        List permissions = (List)event.getPresentation().getClientProperty(ActionUtil.UNSATISFIED_PERMISSIONS);
        if (permissions == null) {
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            this.restorePresentation(presentation);
            return;
        }
        boolean isInPopup = this.isPopupPlace(event);
        AccessLevel accessLevel = UtilKt.getAccessLevel((List)permissions);
        if (accessLevel instanceof UnknownAccessLevel) {
            if (!Intrinsics.areEqual((Object)((UnknownAccessLevel)accessLevel).getPermission().getId(), (Object)PermissionsKt.getOwner().getId())) {
                return;
            }
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            if (!this.isDecorated(presentation, isInPopup, true)) {
                Presentation presentation2 = event.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
                this.decorateHostOnly(presentation2, action, isInPopup);
            }
        } else {
            event.getPresentation().setEnabled(isInPopup || Intrinsics.areEqual((Object)event.getUiKind(), (Object)ActionUiKind.NONE));
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            if (!this.isDecorated(presentation, isInPopup, false)) {
                Presentation presentation3 = event.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"getPresentation(...)");
                String string = event.getPlace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
                this.decorateNotPermitted(presentation3, action, isInPopup, string);
            }
        }
    }

    private final boolean isPopupPlace(AnActionEvent event) {
        return event.getUiKind() instanceof ActionUiKind.Popup || Intrinsics.areEqual((Object)event.getPlace(), (Object)"ICON_NAVIGATION");
    }

    private final boolean shouldSkip(String backendActionId) {
        return Intrinsics.areEqual((Object)backendActionId, (Object)"VcsGroups");
    }

    private final boolean isDecorated(Presentation presentation, boolean isInPopup, boolean hostOnly) {
        return this.isTextDecorated(presentation) || CWMPermissionDecorator.Companion.isTooltipDecorated(presentation) && (hostOnly || this.isIconDecorated(presentation, isInPopup));
    }

    private final boolean isTextDecorated(Presentation presentation) {
        String string = presentation.getText();
        if (string == null) {
            return true;
        }
        String text = string;
        String string2 = (String)presentation.getClientProperty(decoratedTextKey);
        if (string2 == null) {
            return false;
        }
        String decoratedText = string2;
        return Intrinsics.areEqual((Object)text, (Object)decoratedText);
    }

    private final boolean isIconDecorated(Presentation presentation, boolean isInPopup) {
        return isInPopup ? CWMPermissionDecorator.Companion.isDecorated(presentation.getIcon()) : CWMPermissionDecorator.Companion.isDecorated(presentation.getDisabledIcon());
    }

    /*
     * WARNING - void declaration
     */
    private final void decorateHostOnly(Presentation presentation, AnAction action, boolean isInPopup) {
        if (isInPopup) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)presentation.getText(), (String)"getText(...)");
            presentation.setText(CodeWithMeFrontendBundle.INSTANCE.message("presentation.host.only.text", objectArray));
            presentation.putClientProperty(decoratedTextKey, (Object)presentation.getText());
        } else {
            String string;
            presentation.putClientProperty(originalTooltipKey, presentation.getClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP));
            String string2 = presentation.getText();
            AnAction anAction = action;
            if (anAction != null) {
                void it;
                AnAction anAction2 = anAction;
                String string3 = string2;
                boolean bl = false;
                string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)it);
                string2 = string3;
            } else {
                string = null;
            }
            String string4 = string;
            String string5 = string2;
            HelpTooltip tooltip = new ThinClientActionTooltip(string5, string4).setDescription(CodeWithMeFrontendBundle.INSTANCE.message("presentation.host.only.tooltip.text", new Object[0]));
            presentation.putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, (Object)tooltip);
        }
    }

    private final void decorateNotPermitted(Presentation presentation, AnAction action, boolean isInPopup, String place) {
        this.restorePresentation(presentation);
        Icon originalDisabledIcon = this.getDisabledIcon(presentation);
        Icon icon = originalDisabledIcon == null ? AllIcons.CodeWithMe.CwmPermissions : Companion.decorateIcon(originalDisabledIcon, place);
        Intrinsics.checkNotNull((Object)icon);
        Icon newIcon = icon;
        if (isInPopup) {
            presentation.putClientProperty(originalIconKey, (Object)presentation.getIcon());
            presentation.setIcon(newIcon);
        } else {
            presentation.putClientProperty(originalDisabledIconKey, (Object)presentation.getDisabledIcon());
            presentation.setDisabledIcon(newIcon);
        }
        presentation.putClientProperty(originalTooltipKey, presentation.getClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP));
        Companion.setRequestFullAccessTooltip(presentation, action, place);
    }

    private final void restorePresentation(Presentation presentation) {
        if (presentation.getClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP) instanceof ThinClientActionTooltip) {
            presentation.putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, presentation.getClientProperty(originalTooltipKey));
        }
        if (CWMPermissionDecorator.Companion.isDecorated(presentation.getDisabledIcon())) {
            presentation.setDisabledIcon((Icon)presentation.getClientProperty(originalDisabledIconKey));
        }
        if (CWMPermissionDecorator.Companion.isDecorated(presentation.getIcon())) {
            presentation.setIcon((Icon)presentation.getClientProperty(originalIconKey));
        }
    }

    private final Icon getDisabledIcon(Presentation presentation) {
        Icon icon;
        if (presentation.getDisabledIcon() != null) {
            icon = presentation.getDisabledIcon();
        } else {
            boolean bl;
            Icon icon2 = presentation.getIcon();
            if (icon2 != null) {
                Icon it = icon2;
                boolean bl2 = false;
                bl = IconLoader.isGoodSize((Icon)it);
            } else {
                bl = false;
            }
            if (bl) {
                Icon icon3 = presentation.getIcon();
                Intrinsics.checkNotNull((Object)icon3);
                icon = ActionButtonLook.SYSTEM_LOOK.getDisabledIcon(icon3);
            } else {
                icon = null;
            }
        }
        return icon;
    }

    static {
        Key key = Key.create((String)"internal.ThinClientPermissionHost.decoratedText");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        decoratedTextKey = key;
        Key key2 = Key.create((String)"internal.ThinClientPermissionHost.originalIcon");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        originalIconKey = key2;
        Key key3 = Key.create((String)"internal.ThinClientPermissionHost.originalDisabledIconKey");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        originalDisabledIconKey = key3;
        Key key4 = Key.create((String)"internal.ThinClientPermissionHost.originalTooltip");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"create(...)");
        originalTooltipKey = key4;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u001a\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u001a\u001a\u00020\u0019*\u0004\u0018\u00010\u000bH\u0002R+\u0010\u0004\u001a\u001f\u0012\u0016\u0012\u0014 \b*\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/cwm/frontend/permissions/CWMPermissionDecorator$Companion;", "", "<init>", "()V", "decoratedTextKey", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "originalIconKey", "Ljavax/swing/Icon;", "originalDisabledIconKey", "originalTooltipKey", "Lcom/intellij/ide/HelpTooltip;", "setRequestFullAccessTooltip", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "place", "decorateIcon", "icon", "isTooltipDecorated", "", "isDecorated", "intellij.cwm.frontend"})
    @SourceDebugExtension(value={"SMAP\nCWMPermissionDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CWMPermissionDecorator.kt\ncom/intellij/cwm/frontend/permissions/CWMPermissionDecorator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,269:1\n1#2:270\n13225#3,2:271\n*S KotlinDebug\n*F\n+ 1 CWMPermissionDecorator.kt\ncom/intellij/cwm/frontend/permissions/CWMPermissionDecorator$Companion\n*L\n68#1:271,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void setRequestFullAccessTooltip(@NotNull Presentation presentation, @Nullable AnAction action, @NotNull String place) {
            String string;
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            if (this.isTooltipDecorated(presentation)) {
                return;
            }
            Presentation presentation2 = presentation;
            Key key = ActionButton.CUSTOM_HELP_TOOLTIP;
            String string2 = presentation.getText();
            AnAction anAction = action;
            if (anAction != null) {
                void it;
                AnAction anAction2 = anAction;
                String string3 = string2;
                Key key2 = key;
                Presentation presentation3 = presentation2;
                boolean bl = false;
                String string4 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)it);
                presentation2 = presentation3;
                key = key2;
                string2 = string3;
                string = string4;
            } else {
                string = null;
            }
            String string5 = string;
            String string6 = string2;
            presentation2.putClientProperty(key, (Object)new ThinClientActionTooltip(string6, string5).setDescription(CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.full.access.description", new Object[0])).setLink(CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.full.access.tooltip", new Object[0]), () -> Companion.setRequestFullAccessTooltip$lambda$1(place)));
        }

        @NotNull
        public final Icon decorateIcon(@NotNull Icon icon, @Nullable String place) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return this.isDecorated(icon) ? icon : (Icon)((Object)new IconWithModificator(icon, place, null, 4, null));
        }

        public static /* synthetic */ Icon decorateIcon$default(Companion companion, Icon icon, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.decorateIcon(icon, string);
        }

        private final boolean isTooltipDecorated(Presentation presentation) {
            HelpTooltip it = (HelpTooltip)presentation.getClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP);
            boolean bl = false;
            return it instanceof ThinClientActionTooltip && Intrinsics.areEqual((Object)((ThinClientActionTooltip)it).getTitle(), (Object)presentation.getText());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isDecorated(Icon $this$isDecorated) {
            if (Intrinsics.areEqual((Object)$this$isDecorated, (Object)AllIcons.CodeWithMe.CwmPermissions)) return true;
            if ($this$isDecorated instanceof IconWithModificator) return true;
            if (!($this$isDecorated instanceof LayeredIcon)) return false;
            Icon[] $this$any$iv = ((LayeredIcon)$this$isDecorated).getAllLayers();
            boolean $i$f$any = false;
            int n = 0;
            int n2 = $this$any$iv.length;
            while (n < n2) {
                Icon element$iv;
                Icon it = element$iv = $this$any$iv[n];
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)AllIcons.CodeWithMe.CwmIconModificator)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private static final void setRequestFullAccessTooltip$lambda$1(String $place) {
            ThinClientPermissionInteractionManager.Companion.askForPermissions(PermissionsRequestLevel.FULL_ACCESS, $place);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

