/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.PerforceToolbarWidgetHelper;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J'\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0014\u0010\u0013\u001a\u00060\u0014R\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0014\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceWorkspaceComboBoxAction;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "shouldShowDisabledActions", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDescription", "", "Lcom/intellij/openapi/util/NlsSafe;", "workspace", "isNoConnections", "isOnline", "createComboBoxButton", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "updateCustomComponent", "component", "Ljavax/swing/JComponent;", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "button", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "Companion", "PerforceWorkspaceComboBox", "intellij.vcs.perforce"})
public final class PerforceWorkspaceComboBoxAction
extends ComboBoxAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> multipleWorkspacesKey;
    @NotNull
    private static final Key<Boolean> isConnectedKey;

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        CharSequence charSequence;
        String workspace;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (project == null || !ToolbarSettings.Companion.getInstance().isAvailable() || !PerforceManager.getInstance(project).isActive()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        PerforceConnectionManagerI perforceConnectionManagerI = PerforceConnectionManager.getInstance(project);
        Intrinsics.checkNotNull((Object)perforceConnectionManagerI, (String)"null cannot be cast to non-null type org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager");
        PerforceConnectionManager perforceConnectionManager = (PerforceConnectionManager)perforceConnectionManagerI;
        if (!perforceConnectionManager.isInitialized()) {
            perforceConnectionManager.scheduleInitialization();
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PerforceSettings perforceSettings = PerforceSettings.getSettings(e.getProject());
        Collection<P4Connection> allConnections = perforceSettings.getAllConnections();
        Intrinsics.checkNotNull((Object)perforceSettings);
        P4Connection connection = PerforceToolbarWidgetHelper.Companion.getConnection(e, perforceSettings);
        Object object = connection;
        String string = object != null && (object = object.getConnectionKey()) != null ? ((ConnectionKey)object).getClient() : (workspace = null);
        boolean isNoConnections = allConnections.isEmpty() || allConnections.size() == 1 && ((charSequence = (CharSequence)workspace) == null || charSequence.length() == 0);
        Presentation $this$update_u24lambda_u240 = presentation2;
        boolean bl = false;
        $this$update_u24lambda_u240.setEnabledAndVisible(true);
        $this$update_u24lambda_u240.setIcon(PerforceToolbarWidgetHelper.Companion.getIcon(perforceSettings, isNoConnections, false));
        $this$update_u24lambda_u240.setDescription(this.getDescription(workspace, isNoConnections, perforceSettings.ENABLED));
        String text = PerforceToolbarWidgetHelper.Companion.getText(workspace, isNoConnections, perforceSettings.ENABLED);
        $this$update_u24lambda_u240.setText(text, false);
        Collection<P4Connection> collection = perforceSettings.getAllConnections();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllConnections(...)");
        $this$update_u24lambda_u240.putClientProperty(multipleWorkspacesKey, (Object)(collection.size() > 1 ? 1 : 0));
        P4Connection p4Connection = connection;
        $this$update_u24lambda_u240.putClientProperty(isConnectedKey, (Object)(p4Connection != null ? p4Connection.isConnected() : perforceSettings.ENABLED));
    }

    private final String getDescription(String workspace, boolean isNoConnections, boolean isOnline) {
        if (!isOnline && !isNoConnections) {
            String string = ColorUtil.toHex((Color)UIUtil.getInactiveTextColor());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
            String color = string;
            HtmlBuilder builder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.html().addText(PerforceBundle.message("connection.cannot.connect", new Object[0])).child((HtmlChunk)HtmlChunk.br()).child((HtmlChunk)HtmlChunk.font((String)color).addText(PerforceBundle.message("connection.cannot.connect.click.to.go.online", new Object[0]))));
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        return PerforceToolbarWidgetHelper.Companion.getDescription(workspace, isNoConnections, isOnline);
    }

    @NotNull
    protected ComboBoxAction.ComboBoxButton createComboBoxButton(@NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        return new PerforceWorkspaceComboBox(presentation);
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        PerforceWorkspaceComboBox perforceWorkspaceComboBox = component instanceof PerforceWorkspaceComboBox ? (PerforceWorkspaceComboBox)((Object)component) : null;
        if (perforceWorkspaceComboBox == null) {
            return;
        }
        PerforceWorkspaceComboBox workspaceComboBox = perforceWorkspaceComboBox;
        Boolean bl = (Boolean)presentation.getClientProperty(multipleWorkspacesKey);
        if (bl == null) {
            return;
        }
        boolean isMultipleWorkspaces = bl;
        Boolean bl2 = (Boolean)presentation.getClientProperty(isConnectedKey);
        if (bl2 == null) {
            return;
        }
        boolean isOnline = bl2;
        workspaceComboBox.setMultipleWorkspaces(isMultipleWorkspaces);
        workspaceComboBox.setOnline(isOnline);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        PerforceSettings perforceSettings = PerforceSettings.getSettings(project);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (P4Connection connection : perforceSettings.getAllConnections()) {
            String string = connection.getConnectionKey().getClient();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClient(...)");
            String string2 = connection.getWorkingDir();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getWorkingDir(...)");
            PerforceToolbarWidgetHelper.WorkspaceAction action = new PerforceToolbarWidgetHelper.WorkspaceAction(string, string2);
            actionGroup.add((AnAction)action);
        }
        return actionGroup;
    }

    static {
        Key key = Key.create((String)"P4_MULTIPLE_WORKSPACES");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        multipleWorkspacesKey = key;
        Key key2 = Key.create((String)"P4_IS_CONNECTED");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        isConnectedKey = key2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceWorkspaceComboBoxAction$Companion;", "", "<init>", "()V", "multipleWorkspacesKey", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isConnectedKey", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceWorkspaceComboBoxAction$PerforceWorkspaceComboBox;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "<init>", "(Lorg/jetbrains/idea/perforce/actions/PerforceWorkspaceComboBoxAction;Lcom/intellij/openapi/actionSystem/Presentation;)V", "isMultipleWorkspaces", "", "()Z", "setMultipleWorkspaces", "(Z)V", "isOnline", "setOnline", "isArrowVisible", "fireActionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "intellij.vcs.perforce"})
    private final class PerforceWorkspaceComboBox
    extends ComboBoxAction.ComboBoxButton {
        private boolean isMultipleWorkspaces;
        private boolean isOnline;

        public PerforceWorkspaceComboBox(Presentation presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            super((ComboBoxAction)PerforceWorkspaceComboBoxAction.this, presentation);
        }

        public final boolean isMultipleWorkspaces() {
            return this.isMultipleWorkspaces;
        }

        public final void setMultipleWorkspaces(boolean bl) {
            this.isMultipleWorkspaces = bl;
        }

        public final boolean isOnline() {
            return this.isOnline;
        }

        public final void setOnline(boolean bl) {
            this.isOnline = bl;
        }

        public boolean isArrowVisible() {
            return this.isOnline && this.isMultipleWorkspaces;
        }

        protected void fireActionPerformed(@Nullable ActionEvent event) {
            if (!this.isOnline) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                DataContext context = dataContext;
                PerforceSettings.getSettings((Project)context.getData(CommonDataKeys.PROJECT)).enable();
                return;
            }
            if (this.isMultipleWorkspaces) {
                super.fireActionPerformed(event);
            }
        }
    }
}

