/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4ClientParser;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParametersProvider;
import org.jetbrains.idea.perforce.perforce.connections.P4EnvHelper;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/PerforceWorkspaceConfigurator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configure", "", "Lorg/jetbrains/idea/perforce/perforce/connections/PerforceWorkspaceConfigurator$P4Config;", "projectRoots", "Lcom/intellij/openapi/vfs/VirtualFile;", "forceCreateConfig", "", "findOrGenerateP4Config", "Ljava/io/File;", "workspaceRoot", "client", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ClientParser$PerforceClient;", "getP4ConfigFileName", "", "Lorg/jetbrains/annotations/Nullable;", "P4Config", "Companion", "intellij.vcs.perforce"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPerforceWorkspaceConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerforceWorkspaceConfigurator.kt\norg/jetbrains/idea/perforce/perforce/connections/PerforceWorkspaceConfigurator\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n30#2,2:89\n1391#3:91\n1480#3,5:92\n1#4:97\n13#5:98\n*S KotlinDebug\n*F\n+ 1 PerforceWorkspaceConfigurator.kt\norg/jetbrains/idea/perforce/perforce/connections/PerforceWorkspaceConfigurator\n*L\n25#1:89,2\n27#1:91\n27#1:92,5\n77#1:98\n*E\n"})
public final class PerforceWorkspaceConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String P4CONFIG_NAME = "p4config.txt";
    @NotNull
    public static final String P4IGNORE_NAME = ".p4ignore.txt";
    @NotNull
    public static final String GITIGNORE_NAME = ".gitignore";

    public PerforceWorkspaceConfigurator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public final Collection<P4Config> configure(@NotNull Collection<? extends VirtualFile> projectRoots, boolean forceCreateConfig) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(projectRoots, (String)"projectRoots");
        if (projectRoots.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<P4ClientParser> serviceClass$iv = P4ClientParser.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        P4ClientParser p4ClientParser = (P4ClientParser)object;
        Iterable $this$flatMap$iv = P4ConnectionParametersProvider.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection entry = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            P4ConnectionParametersProvider provider = (P4ConnectionParametersProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = provider.getConnectionParameters(this.project);
            CollectionsKt.addAll((Collection)entry, (Iterable)list$iv$iv);
        }
        Set parametersSet = CollectionsKt.toSet((Iterable)((List)entry));
        if (parametersSet.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Map<VirtualFile, P4ClientParser.PerforceClient> clients = p4ClientParser.getPerforceClients(this.project, parametersSet, projectRoots);
        List configs = new ArrayList();
        for (Map.Entry entry2 : clients.entrySet()) {
            File file;
            VirtualFile projectRoot = (VirtualFile)entry2.getKey();
            P4ClientParser.PerforceClient client = (P4ClientParser.PerforceClient)entry2.getValue();
            String p0 = client.getWorkspaceRootPath();
            boolean bl = false;
            File workspaceRoot = new File(p0);
            if (this.findOrGenerateP4Config(workspaceRoot, client, forceCreateConfig) == null) continue;
            File config = file;
            boolean bl2 = false;
            configs.add(new P4Config(config, projectRoot));
        }
        return configs;
    }

    private final File findOrGenerateP4Config(File workspaceRoot, P4ClientParser.PerforceClient client, boolean forceCreateConfig) {
        List list;
        if (!workspaceRoot.exists()) {
            LOG.info("Workspace root doesn't exist: " + workspaceRoot);
            return null;
        }
        File configFile = FilesKt.resolve((File)workspaceRoot, (String)this.getP4ConfigFileName());
        if (configFile.exists() || !forceCreateConfig) {
            return configFile;
        }
        P4ConnectionParameters parameters = client.getParameters();
        List $this$findOrGenerateP4Config_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        $this$findOrGenerateP4Config_u24lambda_u240.add("P4PORT=" + parameters.getServer());
        $this$findOrGenerateP4Config_u24lambda_u240.add("P4USER=" + parameters.getUser());
        $this$findOrGenerateP4Config_u24lambda_u240.add("P4CLIENT=" + client.getClientName());
        $this$findOrGenerateP4Config_u24lambda_u240.add("P4IGNORE=.p4ignore.txt;.gitignore");
        String configContent = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        try {
            FileUtil.writeToFile((File)configFile, (String)configContent);
            if (PerforceSettings.getSettings((Project)this.project).useP4CONFIG) {
                PerforceConnectionManager.getInstance(this.project).updateConnections();
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to generate p4config for " + workspaceRoot, (Throwable)e);
        }
        return configFile;
    }

    private final String getP4ConfigFileName() {
        String string = P4EnvHelper.getConfigHelper(this.project).getP4Config();
        if (string == null) {
            string = P4CONFIG_NAME;
        }
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerforceWorkspaceConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/PerforceWorkspaceConfigurator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "P4CONFIG_NAME", "", "P4IGNORE_NAME", "GITIGNORE_NAME", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/PerforceWorkspaceConfigurator$P4Config;", "", "configFile", "Ljava/io/File;", "contentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/io/File;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getConfigFile", "()Ljava/io/File;", "getContentRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.perforce"})
    public static final class P4Config {
        @NotNull
        private final File configFile;
        @NotNull
        private final VirtualFile contentRoot;

        public P4Config(@NotNull File configFile, @NotNull VirtualFile contentRoot) {
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
            this.configFile = configFile;
            this.contentRoot = contentRoot;
        }

        @NotNull
        public final File getConfigFile() {
            return this.configFile;
        }

        @NotNull
        public final VirtualFile getContentRoot() {
            return this.contentRoot;
        }

        @NotNull
        public final File component1() {
            return this.configFile;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.contentRoot;
        }

        @NotNull
        public final P4Config copy(@NotNull File configFile, @NotNull VirtualFile contentRoot) {
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
            return new P4Config(configFile, contentRoot);
        }

        public static /* synthetic */ P4Config copy$default(P4Config p4Config, File file, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                file = p4Config.configFile;
            }
            if ((n & 2) != 0) {
                virtualFile = p4Config.contentRoot;
            }
            return p4Config.copy(file, virtualFile);
        }

        @NotNull
        public String toString() {
            return "P4Config(configFile=" + this.configFile + ", contentRoot=" + this.contentRoot + ")";
        }

        public int hashCode() {
            int result = this.configFile.hashCode();
            result = result * 31 + this.contentRoot.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof P4Config)) {
                return false;
            }
            P4Config p4Config = (P4Config)other;
            if (!Intrinsics.areEqual((Object)this.configFile, (Object)p4Config.configFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contentRoot, (Object)p4Config.contentRoot);
        }
    }
}

