/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u000f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\t0\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/TestPerforceConnectionManager;", "Lorg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "singleton", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "singletonConnection", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "mc", "Lorg/jetbrains/idea/perforce/perforce/connections/PerforceMultipleConnections;", "setSingletonConnection", "", "connection", "setMultipleConnectionObject", "getMultipleConnectionObject", "getAllConnections", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getConnectionForFile", "file", "Ljava/io/File;", "Lorg/jetbrains/idea/perforce/perforce/P4File;", "isSingletonConnectionUsed", "updateConnections", "isUnderProjectConnections", "isInitialized", "intellij.vcs.perforce"})
public final class TestPerforceConnectionManager
implements PerforceConnectionManagerI {
    @NotNull
    private final Project project;
    private final boolean singleton;
    @Nullable
    private P4Connection singletonConnection;
    @Nullable
    private PerforceMultipleConnections mc;

    public TestPerforceConnectionManager(@NotNull Project project, boolean singleton) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.singleton = singleton;
    }

    public final void setSingletonConnection(@Nullable P4Connection connection) {
        this.singletonConnection = connection;
    }

    public final void setMultipleConnectionObject(@Nullable PerforceMultipleConnections mc) {
        this.mc = mc;
    }

    @Override
    @Nullable
    public PerforceMultipleConnections getMultipleConnectionObject() {
        return this.mc;
    }

    @Override
    @NotNull
    public Map<VirtualFile, P4Connection> getAllConnections() {
        if (this.singleton) {
            LinkedHashMap result = new LinkedHashMap();
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.Companion.getInstance(this.project);
            PerforceVcs perforceVcs = PerforceVcs.getInstance(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)perforceVcs), (String)"getInstance(...)");
            for (VirtualFile root : projectLevelVcsManager.getRootsUnderVcs((AbstractVcs)perforceVcs)) {
                Map map = result;
                P4Connection p4Connection = this.singletonConnection;
                Intrinsics.checkNotNull((Object)p4Connection);
                map.put(root, p4Connection);
            }
            return result;
        }
        PerforceMultipleConnections perforceMultipleConnections = this.mc;
        Intrinsics.checkNotNull((Object)perforceMultipleConnections);
        Map<VirtualFile, P4Connection> map = perforceMultipleConnections.getAllConnections();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getAllConnections(...)");
        return map;
    }

    @Override
    @Nullable
    public P4Connection getConnectionForFile(@NotNull File file) {
        P4Connection p4Connection;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.singleton) {
            p4Connection = this.singletonConnection;
        } else {
            VirtualFile virtualFile = PerforceConnectionManager.findNearestLiveParentFor(file);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile vf = virtualFile;
            PerforceMultipleConnections perforceMultipleConnections = this.mc;
            Intrinsics.checkNotNull((Object)perforceMultipleConnections);
            p4Connection = perforceMultipleConnections.getConnection(vf);
        }
        return p4Connection;
    }

    @Override
    @Nullable
    public P4Connection getConnectionForFile(@NotNull P4File file) {
        P4Connection p4Connection;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.singleton) {
            p4Connection = this.singletonConnection;
        } else {
            File file2 = file.getLocalFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getLocalFile(...)");
            p4Connection = this.getConnectionForFile(file2);
        }
        return p4Connection;
    }

    @Override
    @Nullable
    public P4Connection getConnectionForFile(@NotNull VirtualFile file) {
        P4Connection p4Connection;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.singleton) {
            p4Connection = this.singletonConnection;
        } else {
            PerforceMultipleConnections perforceMultipleConnections = this.mc;
            Intrinsics.checkNotNull((Object)perforceMultipleConnections);
            p4Connection = perforceMultipleConnections.getConnection(file);
        }
        return p4Connection;
    }

    @Override
    public boolean isSingletonConnectionUsed() {
        return this.singleton;
    }

    @Override
    public void updateConnections() {
    }

    @Override
    public boolean isUnderProjectConnections(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }
}

