/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.login.AttemptsStateMachine;
import org.jetbrains.idea.perforce.perforce.login.AuthNotifier;
import org.jetbrains.idea.perforce.perforce.login.DisabledLoginNotifier;
import org.jetbrains.idea.perforce.perforce.login.LoginPerformerImpl;
import org.jetbrains.idea.perforce.perforce.login.LoginState;
import org.jetbrains.idea.perforce.perforce.login.LoginStateListener;
import org.jetbrains.idea.perforce.perforce.login.LoginSupport;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginTicketsListener;

@Service(value={Service.Level.PROJECT})
public final class PerforceLoginManager
implements LoginSupport {
    private static final Logger LOG = Logger.getInstance(PerforceLoginManager.class);
    private final AuthNotifier myAuthNotifier;
    private final DisabledLoginNotifier myDisabledLoginNotifier;
    private final Object myMapLock = new Object();
    private final Map<P4Connection, AttemptsStateMachine> myState = new HashMap<P4Connection, AttemptsStateMachine>();
    private final PerforceSettings mySettings;
    private final Project myProject;
    private final PerforceConnectionManagerI myConnectionManager;
    private final LoginStateListener myLoginStateListener;
    private final List<Runnable> mySuccessfulLoginListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public PerforceLoginManager(final Project project) {
        this.myProject = project;
        this.myConnectionManager = (PerforceConnectionManagerI)project.getService(PerforceConnectionManagerI.class);
        this.mySettings = PerforceSettings.getSettings(project);
        this.myAuthNotifier = new AuthNotifier(this.myProject, this, this.mySettings);
        this.myDisabledLoginNotifier = new DisabledLoginNotifier(project, this);
        this.myLoginStateListener = new LoginStateListener(){

            @Override
            protected void notifyListeners(Set<P4Connection> connections) {
                for (P4Connection connection : connections) {
                    PerforceLoginManager.this.myAuthNotifier.removeLazyNotification(connection);
                    PerforceLoginManager.this.myDisabledLoginNotifier.removeLazyNotification(connection);
                }
                VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
                for (Runnable listener2 : PerforceLoginManager.this.mySuccessfulLoginListeners) {
                    listener2.run();
                }
            }
        };
    }

    public static PerforceLoginManager getInstance(Project project) {
        return (PerforceLoginManager)project.getService(PerforceLoginManager.class);
    }

    public void addSuccessfulLoginListener(Runnable runnable) {
        this.mySuccessfulLoginListeners.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.myMapLock;
        synchronized (object) {
            this.myAuthNotifier.clear();
            this.myState.clear();
        }
    }

    public void refreshLoginState() {
        if (!this.loginPingAllowed()) {
            return;
        }
        this.myLoginStateListener.startBatch();
        for (P4Connection connection : this.mySettings.getAllConnections()) {
            this.getOrCreate(connection).ensure(true);
        }
        this.myLoginStateListener.fireBatchFinished();
    }

    private boolean loginPingAllowed() {
        return this.mySettings.ENABLED && this.mySettings.USE_LOGIN;
    }

    @Override
    public boolean silentLogin(P4Connection connection) throws VcsException {
        LOG.debug("silent login called");
        if (!this.loginPingAllowed()) {
            LOG.debug("ping is NOT allowed");
            return false;
        }
        AttemptsStateMachine machine = this.getOrCreate(connection);
        LoginState state = machine.ensure(true);
        if (state.isSuccess()) {
            this.myAuthNotifier.removeLazyNotification(connection);
            return true;
        }
        if (state.getError() != null) {
            throw new VcsException(state.getError());
        }
        return false;
    }

    public boolean check(P4Connection connection, boolean forceCheck) throws VcsConnectionProblem {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        if (!this.loginPingAllowed()) {
            return false;
        }
        AttemptsStateMachine machine = this.getOrCreate(connection);
        LoginState state = machine.ensure(forceCheck);
        if (state.isSuccess()) {
            this.myAuthNotifier.removeLazyNotification(connection);
            return true;
        }
        if (state.getError() != null) {
            throw new VcsConnectionProblem(state.getError());
        }
        throw new PerforceAuthenticationException(PerforceBundle.message("perforce.authentication.problem", new Object[0]), connection, this.myProject);
    }

    public boolean checkAndRepair(P4Connection connection) {
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.loginPingAllowed()) {
            return true;
        }
        AttemptsStateMachine machine = this.getOrCreate(connection);
        LoginState state = (LoginState)this.runUnderProgress(PerforceBundle.message("login.checking.auth.state", new Object[0]), () -> machine.ensure(true));
        if (state == null) {
            return false;
        }
        if (state.isSuccess()) {
            this.myAuthNotifier.removeLazyNotification(connection);
            this.myConnectionManager.updateConnections();
            return true;
        }
        if (this.reportConnectionError(state)) {
            return false;
        }
        return (Boolean)this.runUnderProgress(PerforceBundle.message("login.getting.credentials", new Object[0]), () -> {
            String password = this.mySettings.getPasswd();
            if (StringUtil.isNotEmpty((String)password)) {
                LoginState newLoginState = this.loginUnderProgress(machine, password);
                if (newLoginState == null) {
                    return false;
                }
                if (this.checkLoginState(newLoginState, connection)) {
                    return true;
                }
            }
            return this.askUserForPassword(connection, machine);
        });
    }

    public boolean checkPasswordExpirationAndRepair(P4Connection connection) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.loginPingAllowed()) {
            return true;
        }
        AttemptsStateMachine machine = this.getOrCreate(connection);
        LoginState state = (LoginState)this.runUnderProgress(PerforceBundle.message("login.checking.auth.state", new Object[0]), () -> machine.ensure(true));
        if (state.getError() != null && state.getError().contains("Your password has expired")) {
            if (!this.mySettings.requestForPasswordUpdate(machine)) {
                return false;
            }
            LoginState newLoginState = (LoginState)this.runUnderProgress(PerforceBundle.message("login.checking.auth.state", new Object[0]), () -> machine.ensure(true));
            if (newLoginState == null) {
                return false;
            }
            if (this.checkLoginState(newLoginState, connection)) {
                return true;
            }
            if (this.reportConnectionError(newLoginState)) {
                this.myAuthNotifier.showPasswordWasOk(false);
                return false;
            }
        }
        return this.checkAndRepair(connection);
    }

    private boolean askUserForPassword(P4Connection connection, AttemptsStateMachine machine) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        while (true) {
            String newPassword;
            if ((newPassword = this.mySettings.requestForPassword(this.myConnectionManager.isSingletonConnectionUsed() ? null : connection)) == null) {
                return false;
            }
            if (StringUtil.isEmpty((String)newPassword)) {
                Messages.showInfoMessage((Project)this.myProject, (String)PerforceBundle.message("login.empty.password.restricted", new Object[0]), (String)PerforceBundle.message("login.auth.problem", new Object[0]));
                continue;
            }
            LoginState newLoginState = this.loginUnderProgress(machine, newPassword);
            if (newLoginState == null) {
                return false;
            }
            if (this.checkLoginState(newLoginState, connection)) {
                return true;
            }
            if (this.reportConnectionError(newLoginState)) break;
        }
        this.myAuthNotifier.showPasswordWasOk(false);
        return false;
    }

    private boolean checkLoginState(LoginState newLoginState, P4Connection connection) {
        if (newLoginState.isSuccess()) {
            this.myAuthNotifier.showPasswordWasOk(true);
            this.myAuthNotifier.removeLazyNotification(connection);
            this.myConnectionManager.updateConnections();
            return true;
        }
        return false;
    }

    @Nullable
    private LoginState loginUnderProgress(AttemptsStateMachine machine, String newPassword) {
        return (LoginState)this.runUnderProgress(PerforceBundle.message("login", new Object[0]), () -> machine.login(newPassword));
    }

    private boolean reportConnectionError(LoginState state) {
        if (state.isPasswordInvalid()) {
            return false;
        }
        String error = state.getError();
        if (error != null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showWarningDialog((Project)this.myProject, (String)error, (String)PerforceBundle.message("connection.cannot.connect", new Object[0]));
            }
            return true;
        }
        return false;
    }

    public void ensureNotifyAboutDisabledLogin(P4Connection connection) {
        this.myDisabledLoginNotifier.ensureNotify(connection);
    }

    private <T> T runUnderProgress(@NlsContexts.ProgressTitle String progressTitle, Computable<T> computable) {
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
            try {
                return computable.compute();
            }
            catch (ProcessCanceledException e) {
                return null;
            }
        }, progressTitle, true, this.myProject);
    }

    public boolean checkAndRepairAll() {
        Collection connections = (Collection)this.runUnderProgress(PerforceBundle.message("login.determining.credentials", new Object[0]), () -> this.mySettings.getConnectionsByKeys().values());
        if (connections == null) {
            return false;
        }
        for (P4Connection connection : connections) {
            if (this.checkAndRepair(connection)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void notLogged(P4Connection connection) {
        AttemptsStateMachine machine = this.getOrCreate(connection);
        machine.failed(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttemptsStateMachine getOrCreate(P4Connection connection) {
        Object object = this.myMapLock;
        synchronized (object) {
            AttemptsStateMachine machine = this.myState.get(connection);
            if (machine != null) {
                return machine;
            }
            AttemptsStateMachine newMachine = new AttemptsStateMachine(new LoginPerformerImpl(this.myProject, connection, this.myConnectionManager), this.myLoginStateListener);
            this.myState.put(connection, newMachine);
            return newMachine;
        }
    }

    public void startListening(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PerforceLoginManager.$$$reportNull$$$0(0);
        }
        if (PerforceLoginTicketsListener.shouldRegister()) {
            PerforceLoginTicketsListener myPerforceLoginTicketsListener = new PerforceLoginTicketsListener(this.myProject, this, parentDisposable);
            myPerforceLoginTicketsListener.pingListening();
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myPerforceLoginTicketsListener, parentDisposable);
        }
    }

    public AuthNotifier getNotifier() {
        return this.myAuthNotifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/idea/perforce/perforce/login/PerforceLoginManager", "startListening"));
    }
}

