/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.search.MethodSuperSearcher;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.aop.model.xml.AopConfig;
import com.intellij.spring.aop.model.xml.AspectjAutoproxy;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.tx.AnnotationDriven;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAdvisedElementsSearcher
extends AopAdvisedElementsSearcher {
    private final Module myModule;
    private final NotNullLazyValue<Boolean> myCglibProxyType;
    private final Supplier<? extends CommonSpringModel> myModelFactory;

    public SpringAdvisedElementsSearcher(@NotNull Project project, @Nullable Module module, @NotNull Supplier<? extends CommonSpringModel> modelFactory) {
        if (project == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(0);
        }
        if (modelFactory == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(1);
        }
        this.myCglibProxyType = NotNullLazyValue.atomicLazy(() -> {
            Set<LocalXmlModel> localXmlModels = this.getLocalXmlModels();
            for (LocalXmlModel localXmlModel : localXmlModels) {
                DomFileElement root = localXmlModel.getRoot();
                if (root == null || !SpringAdvisedElementsSearcher.isCglib((DomFileElement<Beans>)root)) continue;
                return true;
            }
            return false;
        });
        this.myModule = module;
        this.myModelFactory = modelFactory;
    }

    @NotNull
    private Set<LocalXmlModel> getLocalXmlModels() {
        Set set = this.myModule != null ? SpringAdvisedElementsSearcher.getLocalXmlModelCandidates(this.myModule) : SpringModelVisitorUtils.getLocalXmlModels((CommonSpringModel)this.getSpringModel());
        if (set == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isAdvisableInModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(3);
        }
        return SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass) && SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass).resolve().isMapped();
    }

    private static boolean isCglib(DomFileElement<Beans> root) {
        return (Boolean)CachedValuesManager.getManager((Project)root.getManager().getProject()).getCachedValue(root, () -> CachedValueProvider.Result.create((Object)SpringAdvisedElementsSearcher.calcIsCglib(root), (Object[])new Object[]{root}));
    }

    private static boolean calcIsCglib(DomFileElement<Beans> domFileElement) {
        boolean hasAopNamespace = SpringDomUtils.hasNamespace(domFileElement, (String)"Spring AOP namespace key");
        boolean hasTxNamespace = SpringDomUtils.hasNamespace(domFileElement, (String)"Spring TX namespace key");
        if (!hasAopNamespace && !hasTxNamespace) {
            return false;
        }
        DomElement rootElement = domFileElement.getRootElement();
        if (hasAopNamespace && SpringDomUtils.hasElement(domFileElement, AopConfig.class)) {
            for (AopConfig config : DomUtil.getDefinedChildrenOfType((DomElement)rootElement, AopConfig.class, (boolean)true, (boolean)false)) {
                if (!Boolean.TRUE.equals(config.getProxyTargetClass().getValue())) continue;
                return true;
            }
        }
        if (!SpringDomUtils.hasElement(domFileElement, AnnotationDriven.class) && !SpringDomUtils.hasElement(domFileElement, AspectjAutoproxy.class)) {
            return false;
        }
        CommonProcessors.FindProcessor<CommonSpringBean> processor = new CommonProcessors.FindProcessor<CommonSpringBean>(){

            protected boolean accept(CommonSpringBean bean) {
                return bean instanceof AnnotationDriven && Boolean.TRUE.equals(((AnnotationDriven)bean).getProxyTargetClass().getValue()) || bean instanceof AspectjAutoproxy && Boolean.TRUE.equals(((AspectjAutoproxy)bean).getProxyTargetClass().getValue());
            }
        };
        SpringBeanUtils.getInstance().processChildBeans(rootElement, false, (Processor)processor);
        return processor.isFound();
    }

    public boolean isInherentlyAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(4);
        }
        return SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass);
    }

    @NotNull
    private static Set<LocalXmlModel> getLocalXmlModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(5);
        }
        Collection candidates = DomService.getInstance().getDomFileCandidates(Beans.class, module.getModuleWithDependenciesScope());
        Set<LocalXmlModel> set = candidates.stream().map(file -> PsiManager.getInstance((Project)module.getProject()).findFile(file)).filter(Objects::nonNull).filter(XmlFile.class::isInstance).map(file -> SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel((XmlFile)file, module, Collections.emptySet())).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(6);
        }
        return set;
    }

    public static boolean isSpringAopAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(7);
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("final")) {
            return false;
        }
        if (SpringAdvisedElementsSearcher.isSpringAopClass(psiClass)) {
            return false;
        }
        return SpringAdvisedElementsSearcher.isAspectjAdvisable((PsiClass)psiClass);
    }

    public LinkedHashSet<PsiClass> collectAdvisedClasses() {
        MyBeanVisitor visitor = new MyBeanVisitor();
        Collection beans = (Collection)ReadAction.compute(() -> this.getSpringModel().getAllCommonBeans());
        for (SpringBeanPointer pointer : beans) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (!pointer.isValid()) {
                    return;
                }
                if (pointer instanceof DomSpringBeanPointer) {
                    SpringModelVisitor.visitBean((SpringModelVisitor)visitor, (CommonSpringBean)((DomSpringBeanPointer)pointer).getSpringBean());
                } else {
                    visitor.processBeanClass(pointer.getEffectiveBeanTypes());
                }
            });
        }
        return visitor.result;
    }

    private static boolean isSpringAopClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(8);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            boolean result = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, psiClass1 -> {
                @NonNls String qname = psiClass1.getQualifiedName();
                return !"org.springframework.aop.Advisor".equals(qname) && !"org.aopalliance.aop.Advice".equals(qname) && !"org.springframework.aop.framework.AopInfrastructureBean".equals(qname);
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static boolean hasInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(9);
        }
        return !JamCommonUtil.processSuperClassList((PsiClass)psiClass, new HashSet(), psiClass1 -> psiClass1.getInterfaces().length == 0);
    }

    public boolean canBeAdvised(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(10);
        }
        if (!super.canBeAdvised(method)) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("final")) {
            return false;
        }
        return !method.hasModifierProperty("private");
    }

    public boolean acceptsBoundMethodHeavy(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(11);
        }
        if (this.isJdkProxyType() && ((psiClass = method.getContainingClass()) == null || SpringAdvisedElementsSearcher.hasInterfaces(psiClass) && !SpringAdvisedElementsSearcher.isFromInterface(method, psiClass))) {
            return false;
        }
        return super.acceptsBoundMethodHeavy(method);
    }

    public boolean isJdkProxyType() {
        return (Boolean)this.myCglibProxyType.getValue() == false;
    }

    private static boolean isFromInterface(@NotNull PsiMethod method, PsiClass psiClass) {
        if (method == null) {
            SpringAdvisedElementsSearcher.$$$reportNull$$$0(12);
        }
        return !new MethodSuperSearcher().execute((Object)new SuperMethodsSearch.SearchParameters(method, psiClass, true, false), signature -> {
            PsiClass aClass = signature.getMethod().getContainingClass();
            return aClass == null || !aClass.isInterface();
        });
    }

    public CommonSpringModel getSpringModel() {
        return this.myModelFactory.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/SpringAdvisedElementsSearcher";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/SpringAdvisedElementsSearcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalXmlModels";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalXmlModelCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAdvisableInModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInherentlyAdvisable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocalXmlModelCandidates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSpringAopAdvisable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSpringAopClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasInterfaces";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canBeAdvised";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acceptsBoundMethodHeavy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isFromInterface";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }

    private static class MyBeanVisitor
    extends SpringModelVisitor {
        private final LinkedHashSet<PsiClass> result = new LinkedHashSet();

        private MyBeanVisitor() {
        }

        protected boolean visitBean(CommonSpringBean bean) {
            ProgressManager.checkCanceled();
            this.processBeanClass(BeanService.getInstance().getEffectiveBeanTypes(bean));
            super.visitBean(bean);
            return true;
        }

        final void processBeanClass(Collection<PsiType> effectiveTypes) {
            for (PsiType psiType : effectiveTypes) {
                PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
                if (psiClass == null || !SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass)) continue;
                this.result.add(psiClass);
                this.addAdvisableSupers(psiClass);
            }
        }

        private void addAdvisableSupers(PsiClass beanClass) {
            InheritanceUtil.processSupers((PsiClass)beanClass, (boolean)false, psiClass -> {
                if (SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass)) {
                    this.result.add((PsiClass)psiClass);
                }
                return true;
            });
        }
    }
}

