/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.config;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.javascript.karma.config.KarmaConfigFileReference;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaConfigFileInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!node.isQuotedLiteral()) {
                    return;
                }
                for (PsiReference ref : node.getReferences()) {
                    if (!(ref instanceof KarmaConfigFileReference)) continue;
                    KarmaConfigFileInspection.handleReference((KarmaConfigFileReference)ref, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/karma/config/KarmaConfigFileInspection$1", "visitJSLiteralExpression"));
            }
        };
    }

    private static void handleReference(@NotNull KarmaConfigFileReference ref, @NotNull ProblemsHolder holder) {
        if (ref == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(3);
        }
        if (ref.isLast()) {
            PsiFileSystemItem fileItem = KarmaConfigFileInspection.resolve(ref);
            if (fileItem == null) {
                return;
            }
            KarmaConfigFileReference.FileType fileType = ref.getExpectedFileType();
            if (fileType == KarmaConfigFileReference.FileType.DIRECTORY && !fileItem.isDirectory()) {
                holder.registerProblemForReference((PsiReference)ref, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, KarmaBundle.message("inspection.KarmaConfigFile.directory_expected.message", new Object[0]), new LocalQuickFix[0]);
            }
            if (fileType == KarmaConfigFileReference.FileType.FILE && fileItem.isDirectory()) {
                holder.registerProblemForReference((PsiReference)ref, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, KarmaBundle.message("inspection.KarmaConfigFile.file_or_pattern_expected.message", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    private static PsiFileSystemItem resolve(@NotNull KarmaConfigFileReference ref) {
        ResolveResult[] results;
        if (ref == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(4);
        }
        for (ResolveResult result : results = ref.multiResolve(false)) {
            PsiElement element;
            if (!result.isValidResult() || !((element = result.getElement()) instanceof PsiFileSystemItem)) continue;
            return (PsiFileSystemItem)element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/karma/config/KarmaConfigFileInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

