/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.javascript.karma.execution.KarmaDetectorKt;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddTest;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.javascript.testing.JsTestFileByTestNamesIndexKt;
import com.intellij.javascript.testing.detection.CachingJsTestFileIndexDataCollector;
import com.intellij.javascript.testing.detection.JsTestFileIndexData;
import com.intellij.javascript.testing.detection.JsTestFileIndexDataKt;
import com.intellij.javascript.testing.detection.JsTestFrameworkApiDesign;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectors;
import com.intellij.javascript.testing.detection.JsTestFrameworkPackageDescriptor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016JY\u0010!\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u0002H\"0$2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H\"0$2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H\"0$H\u0002\u00a2\u0006\u0002\u0010*J\u001a\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u001b0\u001b2\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/javascript/karma/execution/KarmaDetector;", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkDetector;", "<init>", "()V", "frameworkName", "", "getFrameworkName", "()Ljava/lang/String;", "frameworkApiDesign", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkApiDesign;", "getFrameworkApiDesign", "()Lcom/intellij/javascript/testing/detection/JsTestFrameworkApiDesign;", "packageDescriptor", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkPackageDescriptor;", "getPackageDescriptor", "()Lcom/intellij/javascript/testing/detection/JsTestFrameworkPackageDescriptor;", "indexDataCollector", "Lcom/intellij/javascript/testing/detection/CachingJsTestFileIndexDataCollector;", "findFileBasedIndexData", "Lcom/intellij/javascript/testing/detection/JsTestFileIndexData;", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "checkIsProbablyTestFile", "", "findTestsStructure", "Lcom/intellij/javascript/testFramework/AbstractTestFileStructure;", "findTestFilesInIndexesBySelector", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "testSelector", "Lcom/intellij/javascript/testFramework/JsTestSelector;", "processAnyKarmaStructure", "T", "handleJasmineStructure", "Lkotlin/Function1;", "Lcom/intellij/javascript/testFramework/jasmine/JasmineFileStructure;", "handleMochaTddStructure", "Lcom/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure;", "handleQUnitStructure", "Lcom/intellij/javascript/testFramework/qunit/QUnitFileStructure;", "(Lcom/intellij/lang/javascript/psi/JSFile;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "findAllFileTestPatterns", "Lcom/intellij/javascript/testFramework/util/JSTestNamePattern;", "Companion", "intellij.karma"})
public final class KarmaDetector
implements JsTestFrameworkDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String frameworkName;
    @NotNull
    private final JsTestFrameworkApiDesign frameworkApiDesign = JsTestFrameworkApiDesign.GLOBAL_VARIABLES;
    @NotNull
    private final JsTestFrameworkPackageDescriptor packageDescriptor = new JsTestFrameworkPackageDescriptor((JsTestFrameworkDetector)this, "karma");
    @NotNull
    private final CachingJsTestFileIndexDataCollector indexDataCollector = new CachingJsTestFileIndexDataCollector((JsTestFrameworkDetector)this, arg_0 -> KarmaDetector.indexDataCollector$lambda$0(this, arg_0));

    public KarmaDetector() {
        this.frameworkName = "Karma";
    }

    @NotNull
    public String getFrameworkName() {
        return this.frameworkName;
    }

    @NotNull
    public JsTestFrameworkApiDesign getFrameworkApiDesign() {
        return this.frameworkApiDesign;
    }

    @NotNull
    public JsTestFrameworkPackageDescriptor getPackageDescriptor() {
        return this.packageDescriptor;
    }

    @NotNull
    public JsTestFileIndexData findFileBasedIndexData(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return this.indexDataCollector.getIndexData(jsFile);
    }

    public boolean checkIsProbablyTestFile(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return this.indexDataCollector.getIndexData(jsFile).getHasData();
    }

    @Nullable
    public AbstractTestFileStructure findTestsStructure(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return (AbstractTestFileStructure)this.processAnyKarmaStructure(jsFile, KarmaDetector::findTestsStructure$lambda$0, KarmaDetector::findTestsStructure$lambda$1, KarmaDetector::findTestsStructure$lambda$2);
    }

    @NotNull
    public List<VirtualFile> findTestFilesInIndexesBySelector(@NotNull Project project, @NotNull JsTestSelector testSelector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testSelector, (String)"testSelector");
        return JsTestFileByTestNamesIndexKt.findTestFilesByTestSelector((Project)project, (JsTestSelector)testSelector, (JsTestFrameworkDetector)this);
    }

    private final <T> T processAnyKarmaStructure(JSFile jsFile, Function1<? super JasmineFileStructure, ? extends T> handleJasmineStructure, Function1<? super MochaTddFileStructure, ? extends T> handleMochaTddStructure, Function1<? super QUnitFileStructure, ? extends T> handleQUnitStructure) {
        AbstractTestFileStructure abstractTestFileStructure = QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure, (String)"fetchCachedTestFileStructure(...)");
        QUnitFileStructure qUnitFileStructure = (QUnitFileStructure)abstractTestFileStructure;
        if (!qUnitFileStructure.isEmpty()) {
            return (T)handleQUnitStructure.invoke((Object)qUnitFileStructure);
        }
        AbstractTestFileStructure abstractTestFileStructure2 = MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure2, (String)"fetchCachedTestFileStructure(...)");
        MochaTddFileStructure mochaTddStructure = (MochaTddFileStructure)abstractTestFileStructure2;
        if (!mochaTddStructure.isEmpty()) {
            return (T)handleMochaTddStructure.invoke((Object)mochaTddStructure);
        }
        AbstractTestFileStructure abstractTestFileStructure3 = JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure3, (String)"fetchCachedTestFileStructure(...)");
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)abstractTestFileStructure3;
        if (!jasmineStructure.isEmpty()) {
            return (T)handleJasmineStructure.invoke((Object)jasmineStructure);
        }
        return null;
    }

    @NotNull
    public final List<List<JSTestNamePattern>> findAllFileTestPatterns(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        List allTestsPatterns = KarmaDetectorKt.access$collectJasmineTests(jsFile);
        if (!allTestsPatterns.isEmpty()) {
            return allTestsPatterns;
        }
        List mochaAllTestsPatterns = new ArrayList();
        AbstractTestFileStructure abstractTestFileStructure = MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure, (String)"fetchCachedTestFileStructure(...)");
        MochaTddFileStructure mochaTdd = (MochaTddFileStructure)abstractTestFileStructure;
        mochaTdd.forEachTest(arg_0 -> KarmaDetector.findAllFileTestPatterns$lambda$0(mochaAllTestsPatterns, arg_0));
        if (!mochaAllTestsPatterns.isEmpty()) {
            return mochaAllTestsPatterns;
        }
        List qUnitAllTestsPatterns = new ArrayList();
        AbstractTestFileStructure abstractTestFileStructure2 = QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure2, (String)"fetchCachedTestFileStructure(...)");
        QUnitFileStructure qunit = (QUnitFileStructure)abstractTestFileStructure2;
        qunit.forEachTest(arg_0 -> KarmaDetector.findAllFileTestPatterns$lambda$1(qUnitAllTestsPatterns, arg_0));
        if (!qUnitAllTestsPatterns.isEmpty()) {
            return qUnitAllTestsPatterns;
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean indexDataCollector$lambda$0$0(Set $names, JasmineFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = it.collectElementPaths("\u0000");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"collectElementPaths(...)");
        return $names.addAll(set);
    }

    private static final boolean indexDataCollector$lambda$0$1(Set $names, MochaTddFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = it.collectElementPaths("\u0000");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"collectElementPaths(...)");
        return $names.addAll(set);
    }

    private static final boolean indexDataCollector$lambda$0$2(Set $names, QUnitFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = it.collectElementPaths("\u0000");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"collectElementPaths(...)");
        return $names.addAll(set);
    }

    private static final JsTestFileIndexData indexDataCollector$lambda$0(KarmaDetector this$0, JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        Set names = new LinkedHashSet();
        this$0.processAnyKarmaStructure(jsFile, arg_0 -> KarmaDetector.indexDataCollector$lambda$0$0(names, arg_0), arg_0 -> KarmaDetector.indexDataCollector$lambda$0$1(names, arg_0), arg_0 -> KarmaDetector.indexDataCollector$lambda$0$2(names, arg_0));
        return !((Collection)names).isEmpty() ? new JsTestFileIndexData(names, true, null, 4, null) : JsTestFileIndexDataKt.emptyJsTestFileIndexData();
    }

    private static final AbstractTestFileStructure findTestsStructure$lambda$0(JasmineFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (AbstractTestFileStructure)it;
    }

    private static final AbstractTestFileStructure findTestsStructure$lambda$1(MochaTddFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (AbstractTestFileStructure)it;
    }

    private static final AbstractTestFileStructure findTestsStructure$lambda$2(QUnitFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (AbstractTestFileStructure)it;
    }

    private static final void findAllFileTestPatterns$lambda$0(List $mochaAllTestsPatterns, MochaTddTest test) {
        List list = test.getTestTreePathPatterns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTestTreePathPatterns(...)");
        $mochaAllTestsPatterns.add(list);
    }

    private static final void findAllFileTestPatterns$lambda$1(List $qUnitAllTestsPatterns, QUnitTestMethodStructure test) {
        Object[] objectArray = new JSTestNamePattern[]{JSTestNamePattern.literalPattern((String)test.getModuleStructure().getName()), JSTestNamePattern.literalPattern((String)test.getName())};
        $qUnitAllTestsPatterns.add(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/karma/execution/KarmaDetector$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/javascript/karma/execution/KarmaDetector;", "getInstance", "()Lcom/intellij/javascript/karma/execution/KarmaDetector;", "intellij.karma"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KarmaDetector getInstance() {
            return (KarmaDetector)JsTestFrameworkDetectors.Companion.getDetectorOrFail(KarmaDetector.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

