/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategyKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \f2\u00020\u0001:\u0003\n\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "", "<init>", "()V", "getIndent", "Lcom/intellij/formatting/Indent;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "ConstIndentStrategy", "PositionStrategy", "Companion", "intellij.kotlin.formatter.minimal"})
public abstract class NodeIndentStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract Indent getIndent(@NotNull ASTNode var1, @NotNull CodeStyleSettings var2);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$Companion;", "", "<init>", "()V", "constIndent", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "indent", "Lcom/intellij/formatting/Indent;", "strategy", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "debugInfo", "", "intellij.kotlin.formatter.minimal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeIndentStrategy constIndent(@NotNull Indent indent) {
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            return new ConstIndentStrategy(indent);
        }

        @NotNull
        public final PositionStrategy strategy(@NonNls @Nullable String debugInfo) {
            return new PositionStrategy(debugInfo);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$ConstIndentStrategy;", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "indent", "Lcom/intellij/formatting/Indent;", "<init>", "(Lcom/intellij/formatting/Indent;)V", "getIndent", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "intellij.kotlin.formatter.minimal"})
    public static final class ConstIndentStrategy
    extends NodeIndentStrategy {
        @NotNull
        private final Indent indent;

        public ConstIndentStrategy(@NotNull Indent indent) {
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            this.indent = indent;
        }

        @Override
        @NotNull
        public Indent getIndent(@NotNull ASTNode node, @NotNull CodeStyleSettings settings) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return this.indent;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0015\u001a\u00020\u0003H\u0096\u0080\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\tJ\u001a\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J'\u0010\n\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\f2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u001c\"\u00020\f\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\n\u001a\u00020\u00002\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0007J'\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\f2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u001c\"\u00020\f\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010 \u001a\u00020\u0000J'\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\f2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u001c\"\u00020\f\u00a2\u0006\u0002\u0010\u001dJ'\u0010$\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\f2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u001c\"\u00020\f\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010%\u001a\u00020\u0000J\u001a\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0007J\u001a\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\bH\u0016J3\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0,2\u0006\u0010-\u001a\u00020\f2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u001cH\u0002\u00a2\u0006\u0002\u0010.R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "debugInfo", "", "<init>", "(Ljava/lang/String;)V", "indentCallback", "Lkotlin/Function1;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "Lcom/intellij/formatting/Indent;", "within", "Ljava/util/ArrayList;", "Lcom/intellij/psi/tree/IElementType;", "Lkotlin/collections/ArrayList;", "withinCallback", "Lcom/intellij/lang/ASTNode;", "", "notIn", "forElement", "notForElement", "forElementCallback", "toString", "set", "indent", "parents", "Lcom/intellij/psi/tree/TokenSet;", "parentType", "orParentTypes", "", "(Lcom/intellij/psi/tree/IElementType;[Lcom/intellij/psi/tree/IElementType;)Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "callback", "notWithin", "withinAny", "forType", "elementType", "otherTypes", "notForType", "forAny", "getIndent", "node", "settings", "fillTypes", "", "resultCollection", "", "singleType", "(Ljava/util/List;Lcom/intellij/psi/tree/IElementType;[Lcom/intellij/psi/tree/IElementType;)V", "intellij.kotlin.formatter.minimal"})
    public static final class PositionStrategy
    extends NodeIndentStrategy {
        @Nullable
        private final String debugInfo;
        @NotNull
        private Function1<? super CodeStyleSettings, ? extends Indent> indentCallback;
        @NotNull
        private final ArrayList<IElementType> within;
        @Nullable
        private Function1<? super ASTNode, Boolean> withinCallback;
        @NotNull
        private final ArrayList<IElementType> notIn;
        @NotNull
        private final ArrayList<IElementType> forElement;
        @NotNull
        private final ArrayList<IElementType> notForElement;
        @Nullable
        private Function1<? super ASTNode, Boolean> forElementCallback;

        public PositionStrategy(@Nullable String debugInfo) {
            this.debugInfo = debugInfo;
            this.indentCallback = PositionStrategy::indentCallback$lambda$0;
            this.within = new ArrayList();
            this.notIn = new ArrayList();
            this.forElement = new ArrayList();
            this.notForElement = new ArrayList();
        }

        @NotNull
        public String toString() {
            String string = this.debugInfo;
            if (string == null) {
                string = "No debug info";
            }
            return "PositionStrategy " + string;
        }

        @NotNull
        public final PositionStrategy set(@NotNull Indent indent) {
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            this.indentCallback = arg_0 -> PositionStrategy.set$lambda$0(indent, arg_0);
            return this;
        }

        @NotNull
        public final PositionStrategy set(@NotNull Function1<? super CodeStyleSettings, ? extends Indent> indentCallback) {
            Intrinsics.checkNotNullParameter(indentCallback, (String)"indentCallback");
            this.indentCallback = indentCallback;
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull TokenSet parents) {
            Intrinsics.checkNotNullParameter((Object)parents, (String)"parents");
            Object[] objectArray = parents.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getTypes(...)");
            Object[] types = objectArray;
            if (types.length == 0) {
                throw new IllegalArgumentException("Empty token set is unexpected");
            }
            List list = this.within;
            IElementType iElementType = types[0];
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"get(...)");
            this.fillTypes(list, iElementType, (IElementType[])ArraysKt.copyOfRange((Object[])types, (int)1, (int)types.length));
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull IElementType parentType, IElementType ... orParentTypes) {
            Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
            Intrinsics.checkNotNullParameter((Object)orParentTypes, (String)"orParentTypes");
            this.fillTypes((List<IElementType>)this.within, parentType, orParentTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull Function1<? super ASTNode, Boolean> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.withinCallback = callback;
            return this;
        }

        @NotNull
        public final PositionStrategy notWithin(@NotNull IElementType parentType, IElementType ... orParentTypes) {
            Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
            Intrinsics.checkNotNullParameter((Object)orParentTypes, (String)"orParentTypes");
            this.fillTypes((List<IElementType>)this.notIn, parentType, orParentTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy withinAny() {
            this.within.clear();
            this.notIn.clear();
            return this;
        }

        @NotNull
        public final PositionStrategy forType(@NotNull IElementType elementType, IElementType ... otherTypes) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)otherTypes, (String)"otherTypes");
            this.fillTypes((List<IElementType>)this.forElement, elementType, otherTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy notForType(@NotNull IElementType elementType, IElementType ... otherTypes) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)otherTypes, (String)"otherTypes");
            this.fillTypes((List<IElementType>)this.notForElement, elementType, otherTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy forAny() {
            this.forElement.clear();
            this.notForElement.clear();
            return this;
        }

        @NotNull
        public final PositionStrategy forElement(@NotNull Function1<? super ASTNode, Boolean> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.forElementCallback = callback;
            return this;
        }

        @Override
        @Nullable
        public Indent getIndent(@NotNull ASTNode node, @NotNull CodeStyleSettings settings) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            if (!NodeIndentStrategyKt.access$isValidIndent(this.forElement, this.notForElement, node, this.forElementCallback)) {
                return null;
            }
            ASTNode parent = node.getTreeParent();
            if (parent != null ? !NodeIndentStrategyKt.access$isValidIndent(this.within, this.notIn, parent, this.withinCallback) : !((Collection)this.within).isEmpty()) {
                return null;
            }
            return (Indent)this.indentCallback.invoke((Object)settings);
        }

        private final void fillTypes(List<IElementType> resultCollection, IElementType singleType, IElementType[] otherTypes) {
            resultCollection.clear();
            resultCollection.add(singleType);
            CollectionsKt.addAll((Collection)resultCollection, (Object[])otherTypes);
        }

        private static final Indent indentCallback$lambda$0(CodeStyleSettings it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Indent indent = Indent.getNoneIndent();
            Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getNoneIndent(...)");
            return indent;
        }

        private static final Indent set$lambda$0(Indent $indent, CodeStyleSettings it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $indent;
        }
    }
}

