/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter.trailingComma;

import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContextKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u0006H\u0002R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaHelper;", "", "<init>", "()V", "findInvalidCommas", "", "Lcom/intellij/psi/PsiElement;", "commaOwner", "Lorg/jetbrains/kotlin/psi/KtElement;", "trailingCommaExistsOrCanExist", "", "psiElement", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "trailingCommaExists", "trailingCommaOrLastElement", "lineBreakIsMissing", "elementBeforeFirstElement", "elementAfterLastElement", "takeIfIsNotError", "RIGHT_BARRIERS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "LEFT_BARRIERS", "lastSignificantChild", "getLastSignificantChild", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "intellij.kotlin.formatter.minimal"})
@SourceDebugExtension(value={"SMAP\nTrailingCommaHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailingCommaHelper.kt\norg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaHelper\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n140#2:101\n1#3:102\n*S KotlinDebug\n*F\n+ 1 TrailingCommaHelper.kt\norg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaHelper\n*L\n75#1:101\n*E\n"})
public final class TrailingCommaHelper {
    @NotNull
    public static final TrailingCommaHelper INSTANCE = new TrailingCommaHelper();
    @NotNull
    private static final TokenSet RIGHT_BARRIERS;
    @NotNull
    private static final TokenSet LEFT_BARRIERS;

    private TrailingCommaHelper() {
    }

    @NotNull
    public final List<PsiElement> findInvalidCommas(@NotNull KtElement commaOwner) {
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        PsiElement psiElement = commaOwner.getFirstChild();
        List list = psiElement != null && (sequence3 = PsiUtilsKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)1, null)) != null && (sequence2 = SequencesKt.filter((Sequence)sequence3, TrailingCommaHelper::findInvalidCommas$lambda$0)) != null && (sequence = SequencesKt.filter((Sequence)sequence2, TrailingCommaHelper::findInvalidCommas$lambda$1)) != null ? SequencesKt.toList((Sequence)sequence) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean trailingCommaExistsOrCanExist(@NotNull PsiElement psiElement, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return TrailingCommaContextKt.commaExistsOrMayExist(TrailingCommaContext.Companion.create(psiElement), CodeStyleUtilsKt.getKotlinCustomSettings(settings));
    }

    public final boolean trailingCommaExists(@NotNull KtElement commaOwner) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        KtElement ktElement = commaOwner;
        if (ktElement instanceof KtFunctionLiteral) {
            KtParameterList ktParameterList = ((KtFunctionLiteral)commaOwner).getValueParameterList();
            bl = (ktParameterList != null ? ktParameterList.getTrailingComma() : null) != null;
        } else if (ktElement instanceof KtWhenEntry) {
            bl = ((KtWhenEntry)commaOwner).getTrailingComma() != null;
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            bl = ((KtDestructuringDeclaration)commaOwner).getTrailingComma() != null;
        } else {
            PsiElement psiElement = this.trailingCommaOrLastElement(commaOwner);
            bl = psiElement != null ? FormatterUtilKt.isComma(psiElement) : false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final PsiElement trailingCommaOrLastElement(@NotNull KtElement commaOwner) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        PsiElement psiElement = this.getLastSignificantChild((PsiElement)commaOwner);
        if (psiElement == null) {
            return null;
        }
        PsiElement lastChild = psiElement;
        IElementType iElementType2 = PsiUtilCore.getElementType((PsiElement)lastChild);
        if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.COMMA)) {
            return lastChild;
        }
        boolean withSelf = !RIGHT_BARRIERS.contains(iElementType2);
        iElementType2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments((PsiElement)lastChild, (boolean)withSelf);
        if (iElementType2 == null) return null;
        IElementType it = iElementType = iElementType2;
        boolean bl = false;
        if (LEFT_BARRIERS.contains(PsiUtilCore.getElementType((PsiElement)it))) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        IElementType iElementType3 = iElementType;
        IElementType iElementType4 = iElementType3;
        if (iElementType4 == null) return null;
        PsiElement psiElement2 = this.takeIfIsNotError((PsiElement)iElementType4);
        return psiElement2;
    }

    public final boolean lineBreakIsMissing(@NotNull KtElement commaOwner) {
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        if (!this.trailingCommaExists(commaOwner)) {
            return false;
        }
        PsiElement first = this.elementBeforeFirstElement(commaOwner);
        PsiElement psiElement = first;
        boolean bl = psiElement != null && (psiElement = PsiUtilsKt.nextLeaf((PsiElement)psiElement, (boolean)true)) != null ? !FormatterUtilKt.isLineBreak(psiElement) : false;
        if (bl) {
            return true;
        }
        PsiElement last = this.elementAfterLastElement(commaOwner);
        PsiElement psiElement2 = last;
        return psiElement2 != null && (psiElement2 = PsiUtilsKt.prevLeaf((PsiElement)psiElement2, (boolean)true)) != null ? !FormatterUtilKt.isLineBreak(psiElement2) : false;
    }

    @Nullable
    public final PsiElement elementBeforeFirstElement(@NotNull KtElement commaOwner) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        KtElement ktElement = commaOwner;
        if (ktElement instanceof KtParameterList) {
            PsiElement parent = ((KtParameterList)commaOwner).getParent();
            object = parent instanceof KtFunctionLiteral ? ((KtFunctionLiteral)parent).getLBrace() : ((KtParameterList)commaOwner).getLeftParenthesis();
        } else if (ktElement instanceof KtWhenEntry) {
            PsiElement $this$cast$iv = ((KtWhenEntry)commaOwner).getParent();
            boolean $i$f$cast = false;
            PsiElement psiElement = $this$cast$iv;
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
            }
            object = ((KtWhenExpression)psiElement).getOpenBrace();
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            object = ((KtDestructuringDeclaration)commaOwner).getLPar();
        } else {
            PsiElement psiElement = commaOwner.getFirstChild();
            object = psiElement != null ? this.takeIfIsNotError(psiElement) : null;
        }
        return object;
    }

    @Nullable
    public final PsiElement elementAfterLastElement(@NotNull KtElement commaOwner) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        KtElement ktElement = commaOwner;
        if (ktElement instanceof KtParameterList) {
            PsiElement parent = ((KtParameterList)commaOwner).getParent();
            object = parent instanceof KtFunctionLiteral ? ((KtFunctionLiteral)parent).getArrow() : ((KtParameterList)commaOwner).getRightParenthesis();
        } else if (ktElement instanceof KtWhenEntry) {
            object = ((KtWhenEntry)commaOwner).getArrow();
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            object = ((KtDestructuringDeclaration)commaOwner).getRPar();
        } else {
            PsiElement psiElement = commaOwner.getLastChild();
            object = psiElement != null ? this.takeIfIsNotError(psiElement) : null;
        }
        return object;
    }

    private final PsiElement takeIfIsNotError(PsiElement $this$takeIfIsNotError) {
        PsiElement psiElement;
        PsiElement it = psiElement = $this$takeIfIsNotError;
        boolean bl = false;
        return !PsiTreeUtil.hasErrorElements((PsiElement)it) ? psiElement : null;
    }

    private final PsiElement getLastSignificantChild(PsiElement $this$lastSignificantChild) {
        PsiElement psiElement = $this$lastSignificantChild;
        return psiElement instanceof KtWhenEntry ? ((KtWhenEntry)$this$lastSignificantChild).getArrow() : (psiElement instanceof KtDestructuringDeclaration ? ((KtDestructuringDeclaration)$this$lastSignificantChild).getRPar() : $this$lastSignificantChild.getLastChild());
    }

    private static final boolean findInvalidCommas$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FormatterUtilKt.isComma(it);
    }

    private static final boolean findInvalidCommas$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = PsiUtilsKt.prevLeaf((PsiElement)it, (boolean)true);
        return (psiElement != null ? FormatterUtilKt.isLineBreak(psiElement) : false) || !Intrinsics.areEqual((Object)FormatterUtilKt.leafIgnoringWhitespace$default(it, false, false, 2, null), (Object)FormatterUtilKt.leafIgnoringWhitespaceAndComments$default(it, false, false, 2, null));
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.RBRACKET, KtTokens.RPAR, KtTokens.RBRACE, KtTokens.GT, KtTokens.ARROW};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        RIGHT_BARRIERS = tokenSet;
        iElementTypeArray = new IElementType[]{KtTokens.LBRACKET, KtTokens.LPAR, KtTokens.LBRACE, KtTokens.LT};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        LEFT_BARRIERS = tokenSet2;
    }
}

