/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.AbstractFtlExpression;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlRangeExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public class FtlIndexExpression
extends AbstractFtlExpression
implements FtlReferenceQualifier {
    public FtlIndexExpression(ASTNode node) {
        super(node);
    }

    @Nullable
    public FtlQualifiedReference getQualifiedReference() {
        FtlExpression expression = this.getExpression(1);
        if (expression == null) {
            return null;
        }
        for (PsiReference reference : expression.getReferences()) {
            if (!(reference instanceof FtlQualifiedReference)) continue;
            return (FtlQualifiedReference)reference;
        }
        return null;
    }

    @Override
    public FtlType getType() {
        FtlQualifiedReference reference;
        FtlType qualifierType = this.getExpressionType(0);
        if (qualifierType == null) {
            return null;
        }
        FtlExpression expression = this.getExpression(1);
        if (expression instanceof FtlRangeExpression) {
            return qualifierType;
        }
        FtlType indexType = this.getExpressionType(1);
        if (indexType == null) {
            return null;
        }
        PsiType indexPsiType = FtlPsiUtil.extractPsiType(indexType);
        if (indexPsiType != null) {
            if (PsiTypes.intType().isAssignableFrom(indexPsiType)) {
                return FtlListDirective.getComponentType(qualifierType);
            }
            PsiType qualifierPsiType = FtlPsiUtil.extractPsiType(qualifierType);
            if (qualifierPsiType != null) {
                PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)qualifierPsiType, (String)"java.util.Map", (int)0, (boolean)false);
                if (keyType != null && keyType.isAssignableFrom(indexPsiType)) {
                    return FtlPsiType.wrap(PsiUtil.substituteTypeParameter((PsiType)qualifierPsiType, (String)"java.util.Map", (int)1, (boolean)false));
                }
                return null;
            }
        }
        return (reference = this.getQualifiedReference()) == null ? null : reference.getType();
    }

    @Override
    @Nullable
    public Object getConstantValue() {
        return null;
    }

    @Override
    public FtlCallableType[] getCallableCandidates() {
        FtlQualifiedReference reference = this.getQualifiedReference();
        return reference == null ? null : reference.getCallableCandidates();
    }

    public FtlReferenceQualifier getReferenceQualifier() {
        return (FtlReferenceQualifier)this.findChildByClass(FtlReferenceQualifier.class);
    }
}

