/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class FtlLanguage
extends Language
implements TemplateLanguage {
    public static final FtlLanguage INSTANCE = new FtlLanguage();
    public static final Language ANGLE_INSTANCE = new AngleDialect();
    public static final Language SQUARE_INSTANCE = new SquareDialect();
    public static final Language INJECTABLE_INSTANCE = new InjectableFtlDialect();

    private FtlLanguage() {
        super("FTL");
    }

    @NotNull
    @NonNls
    public String getDisplayName() {
        return "FreeMarker";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    private static class AngleDialect
    extends FtlDialect
    implements DependentLanguage {
        AngleDialect() {
            super("FTL>", "<FreeMarker>");
        }
    }

    private static class SquareDialect
    extends FtlDialect
    implements DependentLanguage {
        SquareDialect() {
            super("FTL]", "[FreeMarker]");
        }
    }

    private static class InjectableFtlDialect
    extends FtlDialect
    implements InjectableLanguage {
        InjectableFtlDialect() {
            super("InjectedFreeMarker", "Injectable FreeMarker");
        }
    }

    static class FtlDialect
    extends Language
    implements TemplateLanguage {
        private final String myName;

        FtlDialect(@NonNls String id, @NonNls @NotNull String name) {
            if (name == null) {
                FtlDialect.$$$reportNull$$$0(0);
            }
            super((Language)INSTANCE, id, new String[0]);
            this.myName = name;
        }

        @NotNull
        @NonNls
        public String getDisplayName() {
            String string = this.myName;
            if (string == null) {
                FtlDialect.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/freemarker/psi/FtlLanguage$FtlDialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/freemarker/psi/FtlLanguage$FtlDialect";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

