/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.claude.listeners.server;

import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.claude.listeners.server.DiffFileRequest;
import com.intellij.code.provenance.core.claude.listeners.server.DiffHttpRequestProjectHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\"\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestHandler;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "getServiceName", "", "isMethodSupported", "", "method", "Lio/netty/handler/codec/http/HttpMethod;", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "Companion", "intellij.code.provenance.core.claude"})
@SourceDebugExtension(value={"SMAP\nDiffHttpRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffHttpRequestHandler.kt\ncom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n1276#2,2:56\n13#3:58\n*S KotlinDebug\n*F\n+ 1 DiffHttpRequestHandler.kt\ncom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestHandler\n*L\n37#1:56,2\n18#1:58\n*E\n"})
public final class DiffHttpRequestHandler
extends RestService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    protected String getServiceName() {
        return "provenance/call";
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return Intrinsics.areEqual((Object)method, (Object)HttpMethod.POST);
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return null;
        }
        LOG.info("Received request to " + urlDecoder.path());
        try {
            boolean handled;
            block6: {
                boolean bl;
                Sequence projects;
                DiffFileRequest diffRequest = (DiffFileRequest)this.getGson().fromJson(RestService.Companion.createJsonReader(request), (Type)((Object)DiffFileRequest.class));
                LOG.info("Decoded request for file: " + diffRequest.getFilePath());
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                Sequence $this$any$iv = projects = SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])projectArray), DiffHttpRequestHandler::execute$lambda$0);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Project project = (Project)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)project);
                    DiffHttpRequestProjectHandler diffHttpRequestProjectHandler = DiffHttpRequestProjectHandler.Companion.getInstance(project);
                    Intrinsics.checkNotNull((Object)diffRequest);
                    if (!diffHttpRequestProjectHandler.handle(diffRequest)) continue;
                    bl = true;
                    break block6;
                }
                bl = handled = false;
            }
            if (!handled) {
                LOG.warn("No project found to handle request / file doesn't exist");
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            } else {
                LOG.info("Request handled successfully");
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            }
        }
        catch (Exception e) {
            LOG.error("Error processing diff request", (Throwable)e);
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_REQUEST");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
        }
        return null;
    }

    private static final boolean execute$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDisposed();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DiffHttpRequestHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.code.provenance.core.claude"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

