/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.orm.provider;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEntityAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.orm.ep.AbstractOrmSearcher;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.jpa.AbstractJpaOrmProvider;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.jpa.model.AbstractJpaOrmEntity;
import com.intellij.jpa.jpb.model.orm.jpa.model.CustomJpaOrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.orm.model.JpaOrmEntity;
import com.intellij.jpa.orm.model.JpaOrmUnit;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J \u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\nH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\nH\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/jpa/orm/provider/JpaOrmSearcher;", "Lcom/intellij/jpa/jpb/model/orm/ep/AbstractOrmSearcher;", "Lcom/intellij/jpa/jpb/model/orm/jpa/AbstractJpaOrmProvider;", "<init>", "()V", "isEntity", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "findEntityForClass", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "findOrCreateEmbeddedEntity", "findEntityByTableName", "project", "Lcom/intellij/openapi/project/Project;", "tableName", "", "findEntityForFqn", "fqn", "Lcom/intellij/jpa/jpb/model/core/util/Fqn;", "module", "Lcom/intellij/openapi/module/Module;", "hasAnyEntity", "findEntityClasses", "Lkotlin/sequences/Sequence;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findAllEntities", "", "findEmbeddedEntityOwner", "", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute;", "ormEntity", "findOrmUnitForPsiClass", "Lcom/intellij/jpa/jpb/model/orm/model/OrmUnit;", "findAssociatedDataSourceId", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nJpaOrmSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaOrmSearcher.kt\ncom/intellij/jpa/orm/provider/JpaOrmSearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n1586#3:107\n1661#3,3:108\n*S KotlinDebug\n*F\n+ 1 JpaOrmSearcher.kt\ncom/intellij/jpa/orm/provider/JpaOrmSearcher\n*L\n71#1:107\n71#1:108,3\n*E\n"})
public class JpaOrmSearcher
extends AbstractOrmSearcher
implements AbstractJpaOrmProvider {
    public boolean isEntity(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return EntityUtil.getInstance((Project)psiClass.getProject()).isEntity_(psiClass);
    }

    @Nullable
    public OrmEntity findEntityForClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)persistenceClassRoleArray, (String)"getPersistenceRoles(...)");
        PersistenceClassRole role = (PersistenceClassRole)ArraysKt.firstOrNull((Object[])persistenceClassRoleArray);
        if (role == null && this.isEntity(psiClass)) {
            EntityPsi entityPsi = EntityPsi.getInstance((PsiClass)psiClass);
            Intrinsics.checkNotNullExpressionValue((Object)entityPsi, (String)"getInstance(...)");
            return (OrmEntity)new CustomJpaOrmEntity((Entity)entityPsi);
        }
        PersistenceClassRole persistenceClassRole = role;
        if (persistenceClassRole == null || (persistenceClassRole = persistenceClassRole.getPersistentObject()) == null) {
            return null;
        }
        PersistenceClassRole persistenceObject = persistenceClassRole;
        return (OrmEntity)new JpaOrmEntity((PersistentObject)persistenceObject);
    }

    @Nullable
    public OrmEntity findOrCreateEmbeddedEntity(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        OrmEntity ormEntity = this.findEntityForClass(psiClass);
        if (ormEntity == null) {
            EntityPsi entityPsi = EntityPsi.getInstance((PsiClass)psiClass);
            Intrinsics.checkNotNullExpressionValue((Object)entityPsi, (String)"getInstance(...)");
            ormEntity = (OrmEntity)new CustomJpaOrmEntity((Entity)entityPsi);
        }
        return ormEntity;
    }

    @Nullable
    public OrmEntity findEntityByTableName(@NotNull Project project, @NotNull String tableName) {
        OrmEntity ormEntity;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        PsiClass psiClass = EntitySearch.getInstance((Project)project).findByTableName(tableName, EntitySearch.SearchScope.PROJECT_PRODUCTION);
        if (psiClass != null) {
            PsiClass it = psiClass;
            boolean bl = false;
            ormEntity = this.findEntityForClass(it);
        } else {
            ormEntity = null;
        }
        return ormEntity;
    }

    @Nullable
    public OrmEntity findEntityForFqn(@NotNull Fqn fqn, @NotNull Project project, @Nullable Module module) {
        Module module2;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                module2 = module;
                if (module2 == null) break block4;
                Module it = module2;
                boolean bl = false;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)it);
                module2 = globalSearchScope;
                if (globalSearchScope != null) break block5;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            module2 = globalSearchScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        }
        Module scope = module2;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn.getExternalFullName(), (GlobalSearchScope)scope);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        return this.findEntityForClass(psiClass2);
    }

    public boolean hasAnyEntity(@NotNull Project project, @Nullable Module module) {
        Module module2;
        PsiClass entityClass;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                String entityFqn = JpaEntityAnnotation.Entity.getFqn(project, null);
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(entityFqn, GlobalSearchScope.allScope((Project)project));
                if (psiClass == null) {
                    return false;
                }
                entityClass = psiClass;
                module2 = module;
                if (module2 == null) break block4;
                Module it = module2;
                boolean bl = false;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)it);
                module2 = globalSearchScope;
                if (globalSearchScope != null) break block5;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            module2 = globalSearchScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        }
        Module scope = module2;
        Query query = AnnotatedElementsSearch.searchPsiClasses((PsiClass)entityClass, (SearchScope)((SearchScope)scope));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"searchPsiClasses(...)");
        return CollectionsKt.any((Iterable)((Iterable)query));
    }

    @Nullable
    public Sequence<PsiClass> findEntityClasses(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return CollectionsKt.asSequence((Iterable)EntitySearch.getInstance((Project)project).getEntitiesQuery(scope, null).asIterable());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<OrmEntity> findAllEntities(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection collection = EntitySearch.getInstance((Project)project).getProjectEntities();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProjectEntities(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiClass psiClass = (PsiClass)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            EntityPsi entityPsi = EntityPsi.getInstance((PsiClass)it);
            Intrinsics.checkNotNullExpressionValue((Object)entityPsi, (String)"getInstance(...)");
            collection2.add(new CustomJpaOrmEntity((Entity)entityPsi));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Map<OrmEntity, OrmEntityAttribute> findEmbeddedEntityOwner(@NotNull OrmEntity ormEntity) {
        SmartPsiElementPointer smartPsiElementPointer;
        Map result;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
                AbstractJpaOrmEntity abstractJpaOrmEntity = ormEntity instanceof AbstractJpaOrmEntity ? (AbstractJpaOrmEntity)ormEntity : null;
                if (abstractJpaOrmEntity == null) {
                    return MapsKt.emptyMap();
                }
                AbstractJpaOrmEntity jpaEntity = abstractJpaOrmEntity;
                if (!jpaEntity.isEmbeddable()) {
                    return MapsKt.emptyMap();
                }
                result = new LinkedHashMap();
                smartPsiElementPointer = ormEntity.getClassPsiPointer();
                if (smartPsiElementPointer == null || (smartPsiElementPointer = (PsiClass)smartPsiElementPointer.getElement()) == null) break block9;
                SmartPsiElementPointer it = smartPsiElementPointer;
                boolean bl = false;
                Fqn fqn = Fqn.Companion.ofClass((PsiClass)it);
                smartPsiElementPointer = fqn;
                if (fqn != null) break block10;
            }
            return MapsKt.emptyMap();
        }
        SmartPsiElementPointer entityFqn = smartPsiElementPointer;
        SmartPsiElementPointer smartPsiElementPointer2 = ormEntity.getClassPsiPointer();
        if (smartPsiElementPointer2 == null || (smartPsiElementPointer2 = smartPsiElementPointer2.getProject()) == null) {
            return MapsKt.emptyMap();
        }
        SmartPsiElementPointer project = smartPsiElementPointer2;
        for (OrmUnit unit : OrmUnitsProvider.Companion.getForFramework((OrmFramework)JpaOrmFramework.INSTANCE).getUnits((Project)project)) {
            for (OrmEntity entity : unit.getEntities()) {
                for (OrmEntityAttribute attribute : entity.getAttributes()) {
                    if (!attribute.isEmbedded() || !Intrinsics.areEqual((Object)attribute.getTypeFqn(), (Object)entityFqn)) continue;
                    result.put(entity, attribute);
                }
            }
        }
        return result;
    }

    @Nullable
    public OrmUnit findOrmUnitForPsiClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)persistenceClassRoleArray, (String)"getPersistenceRoles(...)");
        PersistenceClassRole persistenceClassRole = (PersistenceClassRole)ArraysKt.firstOrNull((Object[])persistenceClassRoleArray);
        if (persistenceClassRole != null) {
            PersistenceClassRole it = persistenceClassRole;
            boolean bl = false;
            PersistenceFacet persistenceFacet = it.getFacet();
            Intrinsics.checkNotNullExpressionValue((Object)persistenceFacet, (String)"getFacet(...)");
            PersistencePackage persistencePackage = it.getPersistenceUnit();
            Intrinsics.checkNotNullExpressionValue((Object)persistencePackage, (String)"getPersistenceUnit(...)");
            return (OrmUnit)new JpaOrmUnit(persistenceFacet, persistencePackage);
        }
        return super.findOrmUnitForPsiClass(psiClass);
    }

    @Nullable
    public String findAssociatedDataSourceId(@NotNull OrmEntity ormEntity) {
        Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
        SmartPsiElementPointer smartPsiElementPointer = ormEntity.getClassPsiPointer();
        if (smartPsiElementPointer == null || (smartPsiElementPointer = (PsiClass)smartPsiElementPointer.getElement()) == null) {
            return null;
        }
        SmartPsiElementPointer psiClass = smartPsiElementPointer;
        PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)persistenceClassRoleArray, (String)"getPersistenceRoles(...)");
        PersistenceClassRole persistenceClassRole = (PersistenceClassRole)ArraysKt.firstOrNull((Object[])persistenceClassRoleArray);
        if (persistenceClassRole == null) {
            return null;
        }
        PersistenceClassRole role = persistenceClassRole;
        return role.getFacet().getDataSourceId(role.getPersistenceUnit());
    }
}

