/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.util;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.orm.ep.OrmMappingProvider;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a0\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\r"}, d2={"getDbTable", "Lcom/intellij/database/psi/DbTable;", "ormEntity", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "columnTableName", "", "getDbColumn", "Lcom/intellij/database/psi/DbColumn;", "columnName", "ormAttribute", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute;", "from", "sourceEmbeddedName", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nOrmDbElementsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmDbElementsUtil.kt\ncom/intellij/jpa/util/OrmDbElementsUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n296#2,2:48\n296#2,2:50\n*S KotlinDebug\n*F\n+ 1 OrmDbElementsUtil.kt\ncom/intellij/jpa/util/OrmDbElementsUtilKt\n*L\n29#1:48,2\n36#1:50,2\n*E\n"})
public final class OrmDbElementsUtilKt {
    @Nullable
    public static final DbTable getDbTable(@NotNull OrmEntity ormEntity, @Nullable String columnTableName) {
        Object v7;
        block9: {
            DbDataSource dbDataSource;
            Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
            SmartPsiElementPointer smartPsiElementPointer = ormEntity.getClassPsiPointer();
            if (smartPsiElementPointer == null || (smartPsiElementPointer = (PsiClass)smartPsiElementPointer.getElement()) == null) {
                return null;
            }
            SmartPsiElementPointer psiClass = smartPsiElementPointer;
            OrmMappingProvider ormMappingProvider = OrmMappingProvider.Companion.findForFramework(ormEntity.getOrmFramework());
            if (ormMappingProvider == null) {
                return null;
            }
            OrmMappingProvider ormMappingProvider2 = ormMappingProvider;
            String schemaName = ormMappingProvider2.getSchemaName(ormEntity);
            String string = columnTableName;
            if (string == null && (string = ormMappingProvider2.getTableName(ormEntity)) == null) {
                return null;
            }
            String tableName = string;
            AbstractRdbmsStore abstractRdbmsStore = OrmUtil.INSTANCE.getAssociatedDataStore(ormEntity);
            String defaultDataSourceId = abstractRdbmsStore != null ? abstractRdbmsStore.getId() : null;
            DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)psiClass.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
            DbPsiFacade dbPsiFacade2 = dbPsiFacade;
            if (defaultDataSourceId != null) {
                dbDataSource = dbPsiFacade2.findDataSource(defaultDataSourceId);
                if (dbDataSource == null) {
                    return null;
                }
            } else if (dbPsiFacade2.getDataSources().size() == 1) {
                dbDataSource = (DbDataSource)dbPsiFacade2.getDataSources().get(0);
            } else {
                return null;
            }
            DbDataSource dataSource = dbDataSource;
            Collection<DbTable> collection = ORMReferencesUtil.getTableVariants(CollectionsKt.listOf((Object)dataSource), schemaName);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getTableVariants(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DbTable it = (DbTable)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getName(), (String)tableName, (boolean)true)) continue;
                v7 = element$iv;
                break block9;
            }
            v7 = null;
        }
        return v7;
    }

    public static /* synthetic */ DbTable getDbTable$default(OrmEntity ormEntity, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return OrmDbElementsUtilKt.getDbTable(ormEntity, string);
    }

    @Nullable
    public static final DbColumn getDbColumn(@NotNull OrmEntity ormEntity, @NotNull String columnName, @Nullable String columnTableName) {
        Object v2;
        DbTable dbTable;
        block3: {
            Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            DbTable dbTable2 = OrmDbElementsUtilKt.getDbTable(ormEntity, columnTableName);
            if (dbTable2 == null) {
                return null;
            }
            dbTable = dbTable2;
            JBIterable jBIterable = DasUtil.getColumns((DasObject)((DasObject)dbTable.getDasObject()));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getColumns(...)");
            Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DasColumn it = (DasColumn)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getName(), (String)columnName, (boolean)true)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        DasColumn dasColumn = v2;
        if (dasColumn == null) {
            return null;
        }
        DasColumn dasColumn2 = dasColumn;
        DbElement dbElement = DbImplUtilCore.findElement((DbDataSource)dbTable.getDataSource(), (DasObject)((DasObject)dasColumn2));
        return dbElement instanceof DbColumn ? (DbColumn)dbElement : null;
    }

    public static /* synthetic */ DbColumn getDbColumn$default(OrmEntity ormEntity, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return OrmDbElementsUtilKt.getDbColumn(ormEntity, string, string2);
    }

    @Nullable
    public static final DbColumn getDbColumn(@NotNull OrmEntity ormEntity, @NotNull OrmEntityAttribute ormAttribute, @Nullable OrmEntity from, @Nullable String sourceEmbeddedName) {
        Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
        Intrinsics.checkNotNullParameter((Object)ormAttribute, (String)"ormAttribute");
        OrmMappingProvider ormMappingProvider = OrmMappingProvider.Companion.findForFramework(ormEntity.getOrmFramework());
        if (ormMappingProvider == null) {
            return null;
        }
        OrmMappingProvider ormMappingProvider2 = ormMappingProvider;
        Pair pair = ormMappingProvider2.getNavigationTableAndColumnNames(ormAttribute, ormEntity, from, sourceEmbeddedName);
        if (pair == null) {
            return null;
        }
        Pair names = pair;
        return OrmDbElementsUtilKt.getDbColumn(ormEntity, (String)names.getSecond(), (String)names.getFirst());
    }

    public static /* synthetic */ DbColumn getDbColumn$default(OrmEntity ormEntity, OrmEntityAttribute ormEntityAttribute, OrmEntity ormEntity2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            ormEntity2 = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return OrmDbElementsUtilKt.getDbColumn(ormEntity, ormEntityAttribute, ormEntity2, string);
    }
}

