/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Java11Shim;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentCollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentIdentityMap() {
        return new ConcurrentHashMap(HashingStrategy.identity());
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull ConcurrentMap<@NotNull T, @NotNull V> createConcurrentMap(@NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(0);
        }
        return new ConcurrentHashMap(hashStrategy);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull ConcurrentMap<@NotNull T, @NotNull V> createConcurrentMap() {
        return new java.util.concurrent.ConcurrentHashMap();
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull ConcurrentMap<@NotNull T, @NotNull V> createConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(1);
        }
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentSet(@NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(2);
        }
        Set<? super T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(hashStrategy));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentIdentitySet() {
        Set<T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(HashingStrategy.identity()));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentIdentitySet(int initialCapacity) {
        Set<T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(initialCapacity, 0.75f, 16, HashingStrategy.identity()));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentSet() {
        ConcurrentHashMap.KeySetView keySetView = java.util.concurrent.ConcurrentHashMap.newKeySet();
        if (keySetView == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(6);
        }
        return keySetView;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentSet(int initialCapacity, @NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(7);
        }
        Set<? super T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(initialCapacity, 0.75f, 16, hashStrategy));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentSet(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(9);
        }
        Set<? super T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentLongObjectMap<@NotNull V> createConcurrentLongObjectMap() {
        ConcurrentLongObjectMap concurrentLongObjectMap = Java11Shim.Companion.createConcurrentLongObjectMap();
        if (concurrentLongObjectMap == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(11);
        }
        return concurrentLongObjectMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectMap concurrentIntObjectMap = Java11Shim.Companion.createConcurrentIntObjectMap();
        if (concurrentIntObjectMap == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(12);
        }
        return concurrentIntObjectMap;
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        ConcurrentIntObjectMap concurrentIntObjectMap = Java11Shim.Companion.createConcurrentIntObjectMap(initialCapacity, loadFactor, concurrencyLevel);
        if (concurrentIntObjectMap == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(13);
        }
        return concurrentIntObjectMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectSoftValueMap() {
        ConcurrentIntObjectMap concurrentIntObjectMap = Java11Shim.Companion.createConcurrentIntObjectSoftValueMap();
        if (concurrentIntObjectMap == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(14);
        }
        return concurrentIntObjectMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectWeakValueMap() {
        ConcurrentIntObjectMap concurrentIntObjectMap = Java11Shim.Companion.createConcurrentIntObjectWeakValueMap();
        if (concurrentIntObjectMap == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(15);
        }
        return concurrentIntObjectMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashStrategy";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/concurrency/ConcurrentCollectionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/concurrency/ConcurrentCollectionFactory";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIdentitySet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentLongObjectMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectSoftValueMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectWeakValueMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentMap";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

