/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileSetLimiter;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000bJ)\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000f\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/OpenTelemetryUtils;", "", "<init>", "()V", "RDCT_TRACING_DIAGNOSTIC_FLAG", "", "RDCT_CONN_METRICS_DIAGNOSTIC_FLAG", "RDCT_LUX_METRICS_DIAGNOSTIC_FLAG", "toCsvStream", "Lkotlin/sequences/Sequence;", "metricData", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "concatToCsvLine", "name", "values", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "csvHeadersLines", "", "resolveMetricsReportingPath", "Ljava/nio/file/Path;", "rawPath", "metricsCsvReportingPath", "metricsJsonReportingPath", "setupFileLimiterForMetrics", "Lcom/intellij/openapi/util/io/FileSetLimiter;", "metricsReportingBasePath", "intellij.platform.diagnostic.telemetry"})
@ApiStatus.Internal
public final class OpenTelemetryUtils {
    @NotNull
    public static final OpenTelemetryUtils INSTANCE = new OpenTelemetryUtils();
    @NotNull
    public static final String RDCT_TRACING_DIAGNOSTIC_FLAG = "rdct.diagnostic.otlp";
    @NotNull
    public static final String RDCT_CONN_METRICS_DIAGNOSTIC_FLAG = "rdct.connection.metrics.enabled";
    @NotNull
    public static final String RDCT_LUX_METRICS_DIAGNOSTIC_FLAG = "lux.metrics.enabled";

    private OpenTelemetryUtils() {
    }

    @NotNull
    public final Sequence<String> toCsvStream(@NotNull MetricData metricData) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)metricData, (String)"metricData");
        MetricDataType metricDataType = metricData.getType();
        switch (metricDataType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[metricDataType.ordinal()]) {
            case 1: {
                Collection collection = metricData.getLongSumData().getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
                sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> OpenTelemetryUtils.toCsvStream$lambda$0(metricData, arg_0));
                break;
            }
            case 2: {
                Collection collection = metricData.getDoubleSumData().getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
                sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> OpenTelemetryUtils.toCsvStream$lambda$1(metricData, arg_0));
                break;
            }
            case 3: {
                Collection collection = metricData.getLongGaugeData().getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
                sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> OpenTelemetryUtils.toCsvStream$lambda$2(metricData, arg_0));
                break;
            }
            case 4: {
                Collection collection = metricData.getDoubleGaugeData().getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
                sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> OpenTelemetryUtils.toCsvStream$lambda$3(metricData, arg_0));
                break;
            }
            default: {
                String string = metricData.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String[] stringArray = new String[]{"-1", "-1", "<metrics type " + metricData.getType() + " is not supported yet>"};
                sequence = SequencesKt.sequenceOf((Object)this.concatToCsvLine(string, stringArray));
            }
        }
        return sequence;
    }

    private final String concatToCsvLine(String name, String ... values) {
        return name + ',' + ArraysKt.joinToString$default((Object[])values, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final List<String> csvHeadersLines() {
        Object[] objectArray = new String[]{"# OpenTelemetry Metrics report: .csv, 4 fields: ", "# <metric name>, <period start, nanoseconds>, <period end, nanoseconds>, <metric value>", "# See CsvMetricsExporter for details.", "# ", "# NAME, PERIOD_START_NANOS, PERIOD_END_NANOS, VALUE"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final Path resolveMetricsReportingPath(String rawPath) {
        if (StringsKt.isBlank((CharSequence)rawPath)) {
            return null;
        }
        return PathManager.getLogDir().resolve(rawPath).toAbsolutePath();
    }

    @Nullable
    public final Path metricsCsvReportingPath() {
        String string = System.getProperty("idea.diagnostic.opentelemetry.metrics.file", "telemetry/open-telemetry-metrics.csv");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return this.resolveMetricsReportingPath(string);
    }

    @Nullable
    public final Path metricsJsonReportingPath() {
        String string = System.getProperty("idea.diagnostic.opentelemetry.meters.file.json", "open-telemetry-meters.json");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return this.resolveMetricsReportingPath(string);
    }

    @NotNull
    public final FileSetLimiter setupFileLimiterForMetrics(@NotNull Path metricsReportingBasePath) {
        Intrinsics.checkNotNullParameter((Object)metricsReportingBasePath, (String)"metricsReportingBasePath");
        String suffixDateFormat = System.getProperty("idea.diagnostic.opentelemetry.metrics.suffix-date-format", "yyyy-MM-dd-HH-mm-ss");
        FileSetLimiter fileSetLimiter = FileSetLimiter.inDirectory((Path)metricsReportingBasePath.getParent()).withBaseNameAndDateFormatSuffix(((Object)metricsReportingBasePath.getFileName()).toString(), suffixDateFormat);
        Intrinsics.checkNotNullExpressionValue((Object)fileSetLimiter, (String)"withBaseNameAndDateFormatSuffix(...)");
        return fileSetLimiter;
    }

    private static final String toCsvStream$lambda$0(MetricData $metricData, LongPointData p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String string = $metricData.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{String.valueOf(p.getStartEpochNanos()), String.valueOf(p.getEpochNanos()), String.valueOf(p.getValue())};
        return INSTANCE.concatToCsvLine(string, stringArray);
    }

    private static final String toCsvStream$lambda$1(MetricData $metricData, DoublePointData p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String string = $metricData.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{String.valueOf(p.getStartEpochNanos()), String.valueOf(p.getEpochNanos()), String.valueOf(p.getValue())};
        return INSTANCE.concatToCsvLine(string, stringArray);
    }

    private static final String toCsvStream$lambda$2(MetricData $metricData, LongPointData p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String string = $metricData.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{String.valueOf(p.getStartEpochNanos()), String.valueOf(p.getEpochNanos()), String.valueOf(p.getValue())};
        return INSTANCE.concatToCsvLine(string, stringArray);
    }

    private static final String toCsvStream$lambda$3(MetricData $metricData, DoublePointData p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String string = $metricData.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{String.valueOf(p.getStartEpochNanos()), String.valueOf(p.getEpochNanos()), String.valueOf(p.getValue())};
        return INSTANCE.concatToCsvLine(string, stringArray);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetricDataType.values().length];
            try {
                nArray[MetricDataType.LONG_SUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_SUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.LONG_GAUGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_GAUGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

