/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.EntitiesBarrel;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.GeneratedCodeCompatibilityChecker;
import com.intellij.platform.workspace.storage.impl.ImmutableEntitiesBarrel;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityFamily;
import com.intellij.platform.workspace.storage.impl.MutableEntityFamily;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B!\b\u0002\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\n\u0010\r\u001a\u00060\u0012j\u0002`\u0013J\u0018\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\n\u0010\r\u001a\u00060\u0012j\u0002`\u0013J&\u0010\u0015\u001a\u00020\f\"\b\b\u0000\u0010\u0016*\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00112\u0006\u0010\u000f\u001a\u00020\u000eJ\u0012\u0010\u0018\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000f\u001a\u00020\u000eJ,\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0011\"\b\b\u0000\u0010\u0016*\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00112\u0006\u0010\u000f\u001a\u00020\u000eJ0\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0011\"\b\b\u0000\u0010\u0016*\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00112\n\u0010\u001b\u001a\u00060\u0012j\u0002`\u0013J&\u0010\u001c\u001a\u00020\f\"\b\b\u0000\u0010\u0016*\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00112\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\u000eH\u0002J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b#R*\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00040\u0003X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel;", "Lcom/intellij/platform/workspace/storage/impl/EntitiesBarrel;", "entityFamilies", "", "Lcom/intellij/platform/workspace/storage/impl/EntityFamily;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "<init>", "(Ljava/util/List;)V", "getEntityFamilies$intellij_platform_workspace_storage", "()Ljava/util/List;", "setEntityFamilies$intellij_platform_workspace_storage", "remove", "", "id", "", "clazz", "getEntityDataForModification", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "getEntityDataForModificationOrNull", "add", "T", "newEntity", "book", "cloneAndAdd", "cloneAndAddAt", "entityId", "replaceById", "toImmutable", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntitiesBarrel;", "getMutableEntityFamily", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityFamily;", "unmodifiableEntityId", "fillEmptyFamilies", "fillEmptyFamilies$intellij_platform_workspace_storage", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nEntitiesBarrel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntitiesBarrel.kt\ncom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n23#2:149\n1586#3:150\n1661#3,3:151\n*S KotlinDebug\n*F\n+ 1 EntitiesBarrel.kt\ncom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel\n*L\n64#1:149\n71#1:150\n71#1:151,3\n*E\n"})
public final class MutableEntitiesBarrel
extends EntitiesBarrel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<EntityFamily<? extends WorkspaceEntity>> entityFamilies;

    private MutableEntitiesBarrel(List<EntityFamily<? extends WorkspaceEntity>> entityFamilies) {
        super(null);
        this.entityFamilies = entityFamilies;
    }

    @Override
    @NotNull
    public List<EntityFamily<? extends WorkspaceEntity>> getEntityFamilies$intellij_platform_workspace_storage() {
        return this.entityFamilies;
    }

    public void setEntityFamilies$intellij_platform_workspace_storage(@NotNull List<EntityFamily<? extends WorkspaceEntity>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.entityFamilies = list;
    }

    public final void remove(int id, int clazz) {
        MutableEntityFamily<?> entityFamily = this.getMutableEntityFamily(clazz);
        entityFamily.remove(id);
    }

    @NotNull
    public final WorkspaceEntityData<?> getEntityDataForModification(long id) {
        return this.getMutableEntityFamily(EntityIdKt.getClazz(id)).getEntityDataForModification(EntityIdKt.getArrayId(id));
    }

    @Nullable
    public final WorkspaceEntityData<?> getEntityDataForModificationOrNull(long id) {
        return this.getMutableEntityFamily(EntityIdKt.getClazz(id)).getEntityDataForModificationOrNull(EntityIdKt.getArrayId(id));
    }

    public final <T extends WorkspaceEntity> void add(@NotNull WorkspaceEntityData<T> newEntity, int clazz) {
        Intrinsics.checkNotNullParameter(newEntity, (String)"newEntity");
        MutableEntityFamily<?> mutableEntityFamily = this.getMutableEntityFamily(clazz);
        Intrinsics.checkNotNull(mutableEntityFamily, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.MutableEntityFamily<T of com.intellij.platform.workspace.storage.impl.MutableEntitiesBarrel.add>");
        mutableEntityFamily.add(newEntity);
    }

    public final long book(int clazz) {
        int arrayId = this.getMutableEntityFamily(clazz).book();
        return EntityIdKt.createEntityId(arrayId, clazz);
    }

    @NotNull
    public final <T extends WorkspaceEntity> WorkspaceEntityData<T> cloneAndAdd(@NotNull WorkspaceEntityData<T> newEntity, int clazz) {
        Intrinsics.checkNotNullParameter(newEntity, (String)"newEntity");
        Object cloned = newEntity.clone();
        MutableEntityFamily<?> mutableEntityFamily = this.getMutableEntityFamily(clazz);
        Intrinsics.checkNotNull(mutableEntityFamily, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.MutableEntityFamily<T of com.intellij.platform.workspace.storage.impl.MutableEntitiesBarrel.cloneAndAdd>");
        mutableEntityFamily.add((WorkspaceEntityData<?>)cloned);
        return cloned;
    }

    @NotNull
    public final <T extends WorkspaceEntity> WorkspaceEntityData<T> cloneAndAddAt(@NotNull WorkspaceEntityData<T> newEntity, long entityId) {
        Intrinsics.checkNotNullParameter(newEntity, (String)"newEntity");
        Object cloned = newEntity.clone();
        ((WorkspaceEntityData)cloned).setId(EntityIdKt.getArrayId(entityId));
        MutableEntityFamily<?> mutableEntityFamily = this.getMutableEntityFamily(EntityIdKt.getClazz(entityId));
        Intrinsics.checkNotNull(mutableEntityFamily, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.MutableEntityFamily<T of com.intellij.platform.workspace.storage.impl.MutableEntitiesBarrel.cloneAndAddAt>");
        mutableEntityFamily.insertAtId((WorkspaceEntityData<?>)cloned);
        return cloned;
    }

    public final <T extends WorkspaceEntity> void replaceById(@NotNull WorkspaceEntityData<T> newEntity, int clazz) {
        Intrinsics.checkNotNullParameter(newEntity, (String)"newEntity");
        MutableEntityFamily<?> mutableEntityFamily = this.getMutableEntityFamily(clazz);
        Intrinsics.checkNotNull(mutableEntityFamily, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.MutableEntityFamily<T of com.intellij.platform.workspace.storage.impl.MutableEntitiesBarrel.replaceById>");
        MutableEntityFamily<?> family = mutableEntityFamily;
        if (!family.exists(newEntity.getId())) {
            MutableEntitiesBarrel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(MutableEntitiesBarrel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Nothing to replace. Class: " + clazz + ", new entity: " + newEntity);
            return;
        }
        family.replaceById(newEntity);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImmutableEntitiesBarrel toImmutable() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void family;
            EntityFamily entityFamily = (EntityFamily)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_10 = family;
            collection.add(var11_10 instanceof MutableEntityFamily ? (!((MutableEntityFamily)family).isEmpty$intellij_platform_workspace_storage() ? ((MutableEntityFamily)family).toImmutable() : null) : (var11_10 instanceof ImmutableEntityFamily ? (ImmutableEntityFamily)family : null));
        }
        List friezedEntities = (List)destination$iv$iv;
        return new ImmutableEntitiesBarrel(friezedEntities);
    }

    private final MutableEntityFamily<?> getMutableEntityFamily(int unmodifiableEntityId) {
        MutableEntityFamily mutableEntityFamily;
        EntityFamily entityFamily;
        EntityFamily entityFamily2;
        this.fillEmptyFamilies$intellij_platform_workspace_storage(unmodifiableEntityId);
        EntityFamily entityFamily3 = this.getEntityFamilies$intellij_platform_workspace_storage().get(unmodifiableEntityId);
        if (entityFamily3 == null) {
            MutableEntitiesBarrel $this$getMutableEntityFamily_u24lambda_u240 = this;
            boolean bl = false;
            GeneratedCodeCompatibilityChecker.INSTANCE.checkCode(ClassToIntConverterKt.findWorkspaceEntity(unmodifiableEntityId));
            MutableEntityFamily emptyEntityFamily = MutableEntityFamily.Companion.createEmptyMutable();
            $this$getMutableEntityFamily_u24lambda_u240.getEntityFamilies$intellij_platform_workspace_storage().set(unmodifiableEntityId, emptyEntityFamily);
            entityFamily3 = emptyEntityFamily;
        }
        if ((entityFamily2 = (entityFamily = entityFamily3)) instanceof MutableEntityFamily) {
            mutableEntityFamily = (MutableEntityFamily)entityFamily;
        } else if (entityFamily2 instanceof ImmutableEntityFamily) {
            MutableEntityFamily newMutable = ((ImmutableEntityFamily)entityFamily).toMutable();
            this.getEntityFamilies$intellij_platform_workspace_storage().set(unmodifiableEntityId, newMutable);
            mutableEntityFamily = newMutable;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mutableEntityFamily;
    }

    public final void fillEmptyFamilies$intellij_platform_workspace_storage(int unmodifiableEntityId) {
        while (this.getEntityFamilies$intellij_platform_workspace_storage().size() <= unmodifiableEntityId) {
            this.getEntityFamilies$intellij_platform_workspace_storage().add(null);
        }
    }

    public /* synthetic */ MutableEntitiesBarrel(List entityFamilies, DefaultConstructorMarker $constructor_marker) {
        this(entityFamilies);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel$Companion;", "", "<init>", "()V", "from", "Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel;", "original", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntitiesBarrel;", "create", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableEntitiesBarrel from(@NotNull ImmutableEntitiesBarrel original) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            return new MutableEntitiesBarrel(new ArrayList(original.getEntityFamilies$intellij_platform_workspace_storage()), null);
        }

        @NotNull
        public final MutableEntitiesBarrel create() {
            return new MutableEntitiesBarrel(new ArrayList(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

