/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.storage.ConnectionId;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableExternalEntityMapping;
import com.intellij.platform.workspace.storage.ReferenceChange;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.ApplyChangesFromOperation;
import com.intellij.platform.workspace.storage.impl.ChangeEntry;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.ImmutableEntitiesBarrel;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.ImmutableStorageIndexes;
import com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.MutableEntitiesBarrel;
import com.intellij.platform.workspace.storage.impl.MutableRefsTable;
import com.intellij.platform.workspace.storage.impl.MutableStorageIndexes;
import com.intellij.platform.workspace.storage.impl.ParentEntityId;
import com.intellij.platform.workspace.storage.impl.RefsTable;
import com.intellij.platform.workspace.storage.impl.RefsTableKt;
import com.intellij.platform.workspace.storage.impl.ReplaceBySourceAsTree;
import com.intellij.platform.workspace.storage.impl.SoftLinkable;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLog;
import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.cache.ChangeOnWorkspaceBuilderChangeLog;
import com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheImpl;
import com.intellij.platform.workspace.storage.impl.exceptions.SymbolicIdAlreadyExistsException;
import com.intellij.platform.workspace.storage.impl.external.ImmutableExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex;
import com.intellij.platform.workspace.storage.instrumentation.Modification;
import com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.url.MutableVirtualFileUrlIndex;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.CollectionFactory;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010#\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0098\u00012\u00020\u00012\u00020\u0002:\u0002\u0098\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ&\u0010<\u001a\b\u0012\u0004\u0012\u0002H>0=\"\b\b\u0000\u0010>*\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H>0AH\u0016J>\u0010B\u001a\b\u0012\u0004\u0012\u0002HC0=\"\b\b\u0000\u0010>*\u00020D\"\b\b\u0001\u0010C*\u00020?2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002H>0F2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002HC0AH\u0016J \u0010G\u001a\u00020\u0014\"\b\b\u0000\u0010>*\u00020D2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002H>0FH\u0016J'\u0010H\u001a\u0004\u0018\u0001H>\"\b\b\u0000\u0010>*\u00020D2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002H>0FH\u0016\u00a2\u0006\u0002\u0010IJ\"\u0010J\u001a\b\u0012\u0004\u0012\u00020?0=2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u001403H\u0016J0\u0010M\u001a\u0002HN\"\u000e\b\u0000\u0010O*\b\u0012\u0004\u0012\u0002HN0P\"\b\b\u0001\u0010N*\u00020?2\u0006\u0010Q\u001a\u0002HOH\u0096\u0004\u00a2\u0006\u0002\u0010RJC\u0010S\u001a\u00020\u001a\"\b\b\u0000\u0010N*\u00020?\"\u000e\b\u0001\u0010>*\b\u0012\u0004\u0012\u0002HN0T\"\u0014\b\u0002\u0010U*\u000e\u0012\u0004\u0012\u0002HN\u0012\u0004\u0012\u0002H>0V2\u0006\u0010Q\u001a\u0002HU\u00a2\u0006\u0002\u0010WJ.\u0010X\u001a\u00020\u001a\"\b\b\u0000\u0010N*\u00020?2\f\u0010Y\u001a\b\u0012\u0004\u0012\u0002HN0T2\f\u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u00010FH\u0002JX\u0010[\u001a\u0002HN\"\u0010\b\u0000\u0010O*\n\u0012\u0006\b\u0001\u0012\u0002HN0P\"\b\b\u0001\u0010N*\u00020?2\f\u0010\\\u001a\b\u0012\u0004\u0012\u0002HO0A2\u0006\u0010]\u001a\u0002HN2\u0017\u0010^\u001a\u0013\u0012\u0004\u0012\u0002HO\u0012\u0004\u0012\u00020\u001a03\u00a2\u0006\u0002\b_H\u0016\u00a2\u0006\u0002\u0010`J\u0010\u0010a\u001a\u00020\u00142\u0006\u0010]\u001a\u00020?H\u0016J$\u0010b\u001a\u00020\u001a2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u0014032\u0006\u0010c\u001a\u00020dH\u0016J\u0012\u0010e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030g0fH\u0016J\"\u0010h\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030A\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030k0j0iH\u0016J\b\u0010l\u001a\u00020\u0014H\u0016J(\u0010m\u001a\u00020\u00142\u0006\u0010n\u001a\u00020\u00022\n\u0010o\u001a\u00060\u001dj\u0002`p2\n\u0010q\u001a\u00060\u001dj\u0002`pH\u0002J\b\u0010r\u001a\u00020sH\u0016J6\u0010t\u001a\u00020\u001a2\u0006\u0010u\u001a\u00020v2\u000e\u0010w\u001a\n\u0012\u0006\b\u0001\u0012\u00020?0P2\u0014\u0010x\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020?0P0jH\u0016J2\u0010y\u001a\u00020\u001a2\u0006\u0010u\u001a\u00020v2\u0010\u0010w\u001a\f\u0012\u0006\b\u0001\u0012\u00020?\u0018\u00010P2\u000e\u0010z\u001a\n\u0012\u0006\b\u0001\u0012\u00020?0PH\u0016J\"\u0010{\u001a\b\u0012\u0002\b\u0003\u0018\u00010P2\u0006\u0010u\u001a\u00020v2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030PH\u0016J&\u0010|\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030P0=2\u0006\u0010u\u001a\u00020v2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030PH\u0016J\"\u0010}\u001a\b\u0012\u0002\b\u0003\u0018\u00010P2\u0006\u0010u\u001a\u00020v2\n\u0010z\u001a\u0006\u0012\u0002\b\u00030PH\u0016J\b\u0010~\u001a\u00020\u0014H\u0016J\u0012\u0010\u007f\u001a\u00020\u001a2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0016J&\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u0002HN0\u0083\u0001\"\u0004\b\u0000\u0010N2\u000e\u0010\u0084\u0001\u001a\t\u0012\u0004\u0012\u0002HN0\u0085\u0001H\u0016J\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001J\u0012\u0010\u0088\u0001\u001a\u00020\u001a2\u0007\u0010\u0080\u0001\u001a\u00020\u0002H\u0002J7\u0010\u0089\u0001\u001a\u00020\u00142\u000b\u0010\u008a\u0001\u001a\u00060\u001dj\u0002`p2\u0019\b\u0002\u0010\u008b\u0001\u001a\u0012\u0012\b\u0012\u00060\u001dj\u0002`p\u0012\u0004\u0012\u00020\u001403H\u0000\u00a2\u0006\u0003\b\u008c\u0001J-\u0010\u008d\u0001\u001a\u00020\u001a2\n\u0010E\u001a\u00060\u001dj\u0002`p2\u0007\u0010\u008e\u0001\u001a\u00020\u00142\u0007\u0010\u008f\u0001\u001a\u00020\u0014H\u0000\u00a2\u0006\u0003\b\u0090\u0001J\t\u0010\u0091\u0001\u001a\u00020\u001aH\u0002J\t\u0010\u0092\u0001\u001a\u00020\u001aH\u0002JB\u0010\u0093\u0001\u001a\u00020\u001a2\n\u0010E\u001a\u00060\u001dj\u0002`p2\u0012\u0010\u0094\u0001\u001a\r\u0012\b\u0012\u00060\u001dj\u0002`p0\u0095\u00012\u0017\u0010\u008b\u0001\u001a\u0012\u0012\b\u0012\u00060\u001dj\u0002`p\u0012\u0004\u0012\u00020\u001403H\u0002J\u000f\u0010\u0096\u0001\u001a\u00020\u001aH\u0000\u00a2\u0006\u0003\b\u0097\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u00020\u00148\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R*\u00102\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001a\u0018\u000103@\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R*\u00108\u001a\u0010\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001a\u0018\u000103@\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00105\"\u0004\b;\u00107\u00a8\u0006\u0099\u0001"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "Lcom/intellij/platform/workspace/storage/instrumentation/MutableEntityStorageInstrumentation;", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "originalSnapshot", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityStorageImpl;", "<init>", "(Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityStorageImpl;)V", "entitiesByType", "Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel;", "getEntitiesByType$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel;", "refs", "Lcom/intellij/platform/workspace/storage/impl/MutableRefsTable;", "getRefs$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/MutableRefsTable;", "indexes", "Lcom/intellij/platform/workspace/storage/impl/MutableStorageIndexes;", "getIndexes$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/MutableStorageIndexes;", "trackStackTrace", "", "changeLog", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceBuilderChangeLog;", "getChangeLog$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/WorkspaceBuilderChangeLog;", "incModificationCount", "", "incModificationCount$intellij_platform_workspace_storage", "modificationCount", "", "getModificationCount", "()J", "writingFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stackTrace", "", "threadId", "Ljava/lang/Long;", "threadName", "keepLastRbsEngine", "getKeepLastRbsEngine$intellij_platform_workspace_storage", "()Z", "setKeepLastRbsEngine$intellij_platform_workspace_storage", "(Z)V", "engine", "Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;", "getEngine$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;", "setEngine$intellij_platform_workspace_storage", "(Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;)V", "upgradeEngine", "Lkotlin/Function1;", "getUpgradeEngine$intellij_platform_workspace_storage", "()Lkotlin/jvm/functions/Function1;", "setUpgradeEngine$intellij_platform_workspace_storage", "(Lkotlin/jvm/functions/Function1;)V", "upgradeApplyChangesFromEngine", "Lcom/intellij/platform/workspace/storage/impl/ApplyChangesFromOperation;", "getUpgradeApplyChangesFromEngine$intellij_platform_workspace_storage", "setUpgradeApplyChangesFromEngine$intellij_platform_workspace_storage", "entities", "Lkotlin/sequences/Sequence;", "E", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "Ljava/lang/Class;", "referrers", "R", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "id", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "hasReferrers", "resolve", "(Lcom/intellij/platform/workspace/storage/SymbolicEntityId;)Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "entitiesBySource", "sourceFilter", "Lcom/intellij/platform/workspace/storage/EntitySource;", "addEntity", "T", "M", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "entity", "(Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;)Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "putEntity", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "D", "Lcom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase;", "(Lcom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase;)V", "assertUniqueSymbolicId", "pEntityData", "symbolicId", "modifyEntity", "clazz", "e", "change", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lcom/intellij/platform/workspace/storage/WorkspaceEntity;Lkotlin/jvm/functions/Function1;)Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "removeEntity", "replaceBySource", "replaceWith", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "collectSymbolicEntityIdsChanges", "", "Lcom/intellij/platform/workspace/storage/ReferenceChange;", "collectChanges", "", "", "Lcom/intellij/platform/workspace/storage/EntityChange;", "hasSameEntities", "same", "originalImpl", "addedEntityId", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "removedEntityId", "toSnapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "replaceChildren", "connectionId", "Lcom/intellij/platform/workspace/storage/ConnectionId;", "parent", "newChildren", "addChild", "child", "getOneChildBuilder", "getManyChildrenBuilders", "getParentBuilder", "hasChanges", "applyChangesFrom", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "getMutableExternalMapping", "Lcom/intellij/platform/workspace/storage/MutableExternalEntityMapping;", "identifier", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "getMutableVirtualFileUrlIndex", "Lcom/intellij/platform/workspace/storage/url/MutableVirtualFileUrlIndex;", "applyChangesFromProtection", "removeEntityByEntityId", "idx", "entityFilter", "removeEntityByEntityId$intellij_platform_workspace_storage", "removeSingleEntity", "updateChangelogForChildren", "updateChangelogForParents", "removeSingleEntity$intellij_platform_workspace_storage", "startWriting", "finishWriting", "accumulateEntitiesToRemove", "accumulator", "", "trackChangedSoftLinks", "trackChangedSoftLinks$intellij_platform_workspace_storage", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nImmutableEntityStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmutableEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Entities.kt\ncom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 8 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 9 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1206:1\n44#2,2:1207\n46#2:1212\n44#2,2:1213\n46#2:1218\n44#2,2:1219\n46#2:1224\n44#2,2:1225\n46#2:1230\n44#2,2:1231\n46#2:1239\n44#2,2:1240\n46#2:1245\n44#2,2:1246\n46#2:1251\n44#2,2:1252\n46#2:1266\n44#2,2:1267\n46#2:1277\n44#2,2:1278\n46#2:1283\n44#2,2:1284\n46#2:1289\n44#2,2:1290\n46#2:1311\n44#2,2:1315\n46#2:1326\n44#2,2:1343\n46#2:1348\n44#2,2:1349\n46#2:1354\n44#2,2:1355\n46#2:1360\n29#3,3:1209\n29#3,3:1215\n29#3,3:1221\n29#3,3:1227\n29#3,2:1233\n31#3:1238\n29#3,3:1242\n29#3,3:1248\n29#3,2:1254\n31#3:1265\n29#3,2:1269\n31#3:1276\n29#3,3:1280\n29#3,3:1286\n29#3,2:1292\n31#3:1310\n29#3,2:1317\n31#3:1325\n29#3,3:1345\n29#3,3:1351\n29#3,3:1357\n777#4:1235\n873#4,2:1236\n1915#4:1296\n296#4,2:1300\n1916#4:1305\n1915#4:1306\n1916#4:1309\n1786#4,3:1312\n1266#4,4:1321\n1586#4:1327\n1661#4,3:1328\n1915#4,2:1331\n1915#4,2:1333\n1915#4,2:1335\n1586#4:1337\n1661#4,3:1338\n1915#4,2:1341\n1915#4,2:1365\n1915#4:1367\n1916#4:1372\n427#5,8:1256\n1#6:1264\n60#7,5:1271\n67#7,4:1361\n67#7,4:1368\n67#7,4:1374\n13#7:1379\n221#8,2:1294\n193#8,3:1297\n193#8,3:1302\n221#8,2:1307\n221#8:1373\n222#8:1378\n466#9:1319\n415#9:1320\n*S KotlinDebug\n*F\n+ 1 ImmutableEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl\n*L\n183#1:1207,2\n183#1:1212\n191#1:1213,2\n191#1:1218\n202#1:1219,2\n202#1:1224\n207#1:1225,2\n207#1:1230\n215#1:1231,2\n215#1:1239\n229#1:1240,2\n229#1:1245\n246#1:1246,2\n246#1:1251\n301#1:1252,2\n301#1:1266\n374#1:1267,2\n374#1:1277\n395#1:1278,2\n395#1:1283\n425#1:1284,2\n425#1:1289\n478#1:1290,2\n478#1:1311\n560#1:1315,2\n560#1:1326\n738#1:1343,2\n738#1:1348\n754#1:1349,2\n754#1:1354\n768#1:1355,2\n768#1:1360\n183#1:1209,3\n191#1:1215,3\n202#1:1221,3\n207#1:1227,3\n215#1:1233,2\n215#1:1238\n229#1:1242,3\n246#1:1248,3\n301#1:1254,2\n301#1:1265\n374#1:1269,2\n374#1:1276\n395#1:1280,3\n425#1:1286,3\n478#1:1292,2\n478#1:1310\n560#1:1317,2\n560#1:1325\n738#1:1345,3\n754#1:1351,3\n768#1:1357,3\n218#1:1235\n218#1:1236,2\n494#1:1296\n502#1:1300,2\n494#1:1305\n517#1:1306\n517#1:1309\n548#1:1312,3\n566#1:1321,4\n600#1:1327\n600#1:1328,3\n603#1:1331,2\n606#1:1333,2\n609#1:1335,2\n617#1:1337\n617#1:1338,3\n618#1:1341,2\n807#1:1365,2\n833#1:1367\n833#1:1372\n319#1:1256,8\n379#1:1271,5\n781#1:1361,4\n835#1:1368,4\n845#1:1374,4\n920#1:1379\n484#1:1294,2\n498#1:1297,3\n507#1:1302,3\n522#1:1307,2\n843#1:1373\n843#1:1378\n566#1:1319\n566#1:1320\n*E\n"})
public final class MutableEntityStorageImpl
extends AbstractEntityStorage
implements MutableEntityStorageInstrumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableEntityStorageImpl originalSnapshot;
    @NotNull
    private final MutableEntitiesBarrel entitiesByType;
    @NotNull
    private final MutableRefsTable refs;
    @NotNull
    private final MutableStorageIndexes indexes;
    private volatile boolean trackStackTrace;
    @NotNull
    private final WorkspaceBuilderChangeLog changeLog;
    @NotNull
    private final AtomicBoolean writingFlag;
    @Nullable
    private volatile String stackTrace;
    @Nullable
    private volatile Long threadId;
    @Nullable
    private volatile String threadName;
    @TestOnly
    private boolean keepLastRbsEngine;
    @Nullable
    private ReplaceBySourceAsTree engine;
    @Nullable
    private Function1<? super ReplaceBySourceAsTree, Unit> upgradeEngine;
    @Nullable
    private Function1<? super ApplyChangesFromOperation, Unit> upgradeApplyChangesFromEngine;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final AtomicLong instancesCounter;
    @NotNull
    private static final AtomicLong getEntitiesTimeMs;
    @NotNull
    private static final AtomicLong getReferrersTimeMs;
    @NotNull
    private static final AtomicLong hasReferrersTimeMs;
    @NotNull
    private static final AtomicLong resolveTimeMs;
    @NotNull
    private static final AtomicLong getEntitiesBySourceTimeMs;
    @NotNull
    private static final AtomicLong addEntityTimeMs;
    @NotNull
    private static final AtomicLong putEntityTimeMs;
    @NotNull
    private static final AtomicLong modifyEntityTimeMs;
    @NotNull
    private static final AtomicLong removeEntityTimeMs;
    @NotNull
    private static final AtomicLong replaceBySourceTimeMs;
    @NotNull
    private static final AtomicLong collectChangesTimeMs;
    @NotNull
    private static final AtomicLong hasSameEntitiesTimeMs;
    @NotNull
    private static final AtomicLong toSnapshotTimeMs;
    @NotNull
    private static final AtomicLong applyChangesFromTimeMs;
    @NotNull
    private static final AtomicLong getMutableExternalMappingTimeMs;
    @NotNull
    private static final AtomicLong getMutableVFUrlIndexTimeMs;

    public MutableEntityStorageImpl(@NotNull ImmutableEntityStorageImpl originalSnapshot) {
        Intrinsics.checkNotNullParameter((Object)originalSnapshot, (String)"originalSnapshot");
        super(null);
        this.originalSnapshot = originalSnapshot;
        this.entitiesByType = MutableEntitiesBarrel.Companion.from(this.originalSnapshot.getEntitiesByType$intellij_platform_workspace_storage());
        this.refs = MutableRefsTable.Companion.from(this.originalSnapshot.getRefs$intellij_platform_workspace_storage());
        this.indexes = this.originalSnapshot.getIndexes$intellij_platform_workspace_storage().toMutable();
        instancesCounter.incrementAndGet();
        this.changeLog = new WorkspaceBuilderChangeLog();
        this.writingFlag = new AtomicBoolean();
    }

    @Override
    @NotNull
    public MutableEntitiesBarrel getEntitiesByType$intellij_platform_workspace_storage() {
        return this.entitiesByType;
    }

    @Override
    @NotNull
    public MutableRefsTable getRefs$intellij_platform_workspace_storage() {
        return this.refs;
    }

    @Override
    @NotNull
    public MutableStorageIndexes getIndexes$intellij_platform_workspace_storage() {
        return this.indexes;
    }

    @NotNull
    public final WorkspaceBuilderChangeLog getChangeLog$intellij_platform_workspace_storage() {
        return this.changeLog;
    }

    public final void incModificationCount$intellij_platform_workspace_storage() {
        WorkspaceBuilderChangeLog workspaceBuilderChangeLog = this.changeLog;
        long l = workspaceBuilderChangeLog.getModificationCount();
        workspaceBuilderChangeLog.setModificationCount(l + 1L);
    }

    @Override
    public long getModificationCount() {
        return this.changeLog.getModificationCount();
    }

    public final boolean getKeepLastRbsEngine$intellij_platform_workspace_storage() {
        return this.keepLastRbsEngine;
    }

    public final void setKeepLastRbsEngine$intellij_platform_workspace_storage(boolean bl) {
        this.keepLastRbsEngine = bl;
    }

    @Nullable
    public final ReplaceBySourceAsTree getEngine$intellij_platform_workspace_storage() {
        return this.engine;
    }

    public final void setEngine$intellij_platform_workspace_storage(@Nullable ReplaceBySourceAsTree replaceBySourceAsTree) {
        this.engine = replaceBySourceAsTree;
    }

    @Nullable
    public final Function1<ReplaceBySourceAsTree, Unit> getUpgradeEngine$intellij_platform_workspace_storage() {
        return this.upgradeEngine;
    }

    @TestOnly
    public final void setUpgradeEngine$intellij_platform_workspace_storage(@Nullable Function1<? super ReplaceBySourceAsTree, Unit> function1) {
        this.upgradeEngine = function1;
    }

    @Nullable
    public final Function1<ApplyChangesFromOperation, Unit> getUpgradeApplyChangesFromEngine$intellij_platform_workspace_storage() {
        return this.upgradeApplyChangesFromEngine;
    }

    @TestOnly
    public final void setUpgradeApplyChangesFromEngine$intellij_platform_workspace_storage(@Nullable Function1<? super ApplyChangesFromOperation, Unit> function1) {
        this.upgradeApplyChangesFromEngine = function1;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        AtomicLong arg0$iv = getEntitiesTimeMs;
        boolean bl = false;
        Sequence value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspace_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        Sequence sequence2 = sequence = entityFamily != null && (entityFamily = entityFamily.all()) != null ? SequencesKt.map(entityFamily, arg_0 -> MutableEntityStorageImpl.entities$lambda$0$0(this, arg_0)) : null;
        Object object = sequence instanceof Sequence ? sequence : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        value$iv = object;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithSymbolicId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull SymbolicEntityId<? extends E> id, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        AtomicLong arg0$iv = getReferrersTimeMs;
        boolean bl = false;
        Sequence value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        int classId = ClassToIntConverterKt.toClassId(entityClass);
        value$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspace_storage().getSoftLinks$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(id)), arg_0 -> MutableEntityStorageImpl.referrers$lambda$0$0(classId, arg_0)), arg_0 -> MutableEntityStorageImpl.referrers$lambda$0$1(this, arg_0));
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    public <E extends WorkspaceEntityWithSymbolicId> boolean hasReferrers(@NotNull SymbolicEntityId<? extends E> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        AtomicLong arg0$iv = hasReferrersTimeMs;
        boolean bl = false;
        Object value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        boolean bl2 = false;
        boolean bl3 = false;
        return !((Collection)this.getIndexes$intellij_platform_workspace_storage().getSoftLinks$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(id)).isEmpty();
    }

    @Override
    @Nullable
    public <E extends WorkspaceEntityWithSymbolicId> E resolve(@NotNull SymbolicEntityId<? extends E> id) {
        WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId;
        Intrinsics.checkNotNullParameter(id, (String)"id");
        AtomicLong arg0$iv = resolveTimeMs;
        boolean bl = false;
        WorkspaceEntityWithSymbolicId value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        Long l = this.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(id);
        if (l == null) {
            workspaceEntityWithSymbolicId = null;
        } else {
            long entityIds = l;
            WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspace_storage(entityIds);
            WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData2 = workspaceEntityData instanceof WorkspaceEntityData ? workspaceEntityData : null;
            if (workspaceEntityData2 == null) {
                workspaceEntityWithSymbolicId = null;
            } else {
                WorkspaceEntityData<? extends WorkspaceEntity> entityData = workspaceEntityData2;
                workspaceEntityWithSymbolicId = (WorkspaceEntityWithSymbolicId)entityData.createEntity(this);
            }
        }
        value$iv = workspaceEntityWithSymbolicId;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (E)value$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<WorkspaceEntity> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        AtomicLong arg0$iv = getEntitiesBySourceTimeMs;
        boolean bl = false;
        Sequence value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        EntityStorageInternalIndex index = this.getIndexes$intellij_platform_workspace_storage().getEntitySourceIndex$intellij_platform_workspace_storage();
        Iterable iterable = index.entries$intellij_platform_workspace_storage();
        boolean $i$f$filter = false;
        void var14_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)sourceFilter.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        value$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv)), arg_0 -> MutableEntityStorageImpl.entitiesBySource$lambda$0$0((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)index, this, arg_0));
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <M extends WorkspaceEntity.Builder<T>, T extends WorkspaceEntity> T addEntity(@NotNull M entity) {
        WorkspaceEntity workspaceEntity;
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        AtomicLong arg0$iv = addEntityTimeMs;
        boolean bl = false;
        WorkspaceEntity value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.startWriting();
            ModifiableWorkspaceEntityBase entityToAdd = (ModifiableWorkspaceEntityBase)entity;
            entityToAdd.applyToBuilder(this);
            entityToAdd.getChangedProperty().clear();
            WorkspaceEntity workspaceEntity2 = this.entityDataByIdOrDie$intellij_platform_workspace_storage(entityToAdd.getId()).createEntity(this);
            Intrinsics.checkNotNull((Object)workspaceEntity2, (String)"null cannot be cast to non-null type T of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.addEntity");
            workspaceEntity = workspaceEntity2;
        }
        finally {
            this.finishWriting();
        }
        value$iv = workspaceEntity;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (T)value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends WorkspaceEntity, E extends WorkspaceEntityData<T>, D extends ModifiableWorkspaceEntityBase<T, E>> void putEntity(@NotNull D entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        AtomicLong arg0$iv = putEntityTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.startWriting();
            WorkspaceEntityData newEntityData = ModifiableWorkspaceEntityBase.getEntityData$default(entity, false, 1, null);
            Object immutableEntity = newEntityData.createEntity(this);
            WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = immutableEntity instanceof WorkspaceEntityWithSymbolicId ? (WorkspaceEntityWithSymbolicId)immutableEntity : null;
            SymbolicEntityId<WorkspaceEntityWithSymbolicId> symbolicId = workspaceEntityWithSymbolicId != null ? workspaceEntityWithSymbolicId.getSymbolicId() : null;
            this.assertUniqueSymbolicId(newEntityData, symbolicId);
            this.getEntitiesByType$intellij_platform_workspace_storage().add(newEntityData, ClassToIntConverterKt.toClassId(entity.getEntityClass()));
            this.changeLog.addAddEvent$intellij_platform_workspace_storage(newEntityData.createEntityId(), newEntityData);
            if (newEntityData instanceof SoftLinkable) {
                ((SoftLinkable)((Object)newEntityData)).index(this.getIndexes$intellij_platform_workspace_storage().getSoftLinks$intellij_platform_workspace_storage());
                this.trackChangedSoftLinks$intellij_platform_workspace_storage();
            }
            this.getIndexes$intellij_platform_workspace_storage().entityAdded$intellij_platform_workspace_storage(newEntityData, symbolicId);
        }
        finally {
            this.finishWriting();
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final <T extends WorkspaceEntity> void assertUniqueSymbolicId(WorkspaceEntityData<T> pEntityData, SymbolicEntityId<?> symbolicId) {
        if (symbolicId == null) {
            return;
        }
        Long ids = this.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(symbolicId);
        if (ids != null) {
            WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(ids);
            WorkspaceEntity existingEntity = existingEntityData.createEntity(this);
            this.removeEntity(existingEntity);
            LOG.error(StringsKt.trimIndent((String)("\n              addEntity: symbolic id already exists. Replacing entity with the new one.\n              Symbolic id: " + symbolicId + "\n              \n              Existing entity data: " + existingEntityData + "\n              New entity data: " + pEntityData + "\n              \n              Broken consistency: " + this.getBrokenConsistency$intellij_platform_workspace_storage() + "\n            ")), (Throwable)new SymbolicIdAlreadyExistsException(symbolicId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <M extends WorkspaceEntity.Builder<? extends T>, T extends WorkspaceEntity> T modifyEntity(@NotNull Class<M> clazz, @NotNull T e, @NotNull Function1<? super M, Unit> change) {
        Object obj;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter(change, (String)"change");
        AtomicLong arg0$iv = modifyEntityTimeMs;
        boolean bl = false;
        T value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.startWriting();
            if (e instanceof ModifiableWorkspaceEntityBase && ((ModifiableWorkspaceEntityBase)((Object)e)).getDiff() != this) {
                throw new IllegalStateException("Trying to modify entity from a different builder".toString());
            }
            long entityId = ((WorkspaceEntityBase)e).getId();
            WorkspaceEntityData<?> workspaceEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this, entityId);
            Intrinsics.checkNotNull(workspaceEntityData, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<T of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.modifyEntity>");
            WorkspaceEntityData<?> originalEntityData = workspaceEntityData;
            WorkspaceEntityData<?> workspaceEntityData2 = this.getEntitiesByType$intellij_platform_workspace_storage().getEntityDataForModification(entityId);
            Intrinsics.checkNotNull(workspaceEntityData2, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<T of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.modifyEntity>");
            WorkspaceEntityData<?> copiedData = workspaceEntityData2;
            WorkspaceEntity.Builder<?> builder = e instanceof WorkspaceEntity.Builder ? (WorkspaceEntity.Builder<?>)((Object)e) : copiedData.wrapAsModifiable(this);
            Intrinsics.checkNotNull(builder, (String)"null cannot be cast to non-null type M of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.modifyEntity");
            WorkspaceEntity.Builder<?> modifiableEntity = builder;
            Intrinsics.checkNotNull(modifiableEntity, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase<*, *>");
            ModifiableWorkspaceEntityBase cfr_ignored_0 = (ModifiableWorkspaceEntityBase)modifiableEntity;
            ((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty().clear();
            SymbolicEntityId<WorkspaceEntityWithSymbolicId> beforeSymbolicId = e instanceof WorkspaceEntityWithSymbolicId ? ((WorkspaceEntityWithSymbolicId)e).getSymbolicId() : null;
            ModifiableWorkspaceEntityBase this_$iv = (ModifiableWorkspaceEntityBase)modifiableEntity;
            boolean $i$f$allowModifications$intellij_platform_workspace_storage = false;
            this_$iv.getModifiable().set(true);
            try {
                boolean bl4 = false;
                change.invoke(modifiableEntity);
                ((ModifiableWorkspaceEntityBase)modifiableEntity).afterModification();
            }
            finally {
                this_$iv.getModifiable().remove();
            }
            if (beforeSymbolicId != null) {
                SymbolicEntityId<WorkspaceEntityWithSymbolicId> newSymbolicId;
                Object immutableEntity = ModifiableWorkspaceEntityBase.getEntityData$default((ModifiableWorkspaceEntityBase)modifiableEntity, false, 1, null).createEntity(this);
                SymbolicEntityId<WorkspaceEntityWithSymbolicId> symbolicEntityId = newSymbolicId = immutableEntity instanceof WorkspaceEntityWithSymbolicId ? ((WorkspaceEntityWithSymbolicId)immutableEntity).getSymbolicId() : null;
                if (newSymbolicId != null) {
                    Long ids = this.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(newSymbolicId);
                    if (!Intrinsics.areEqual(beforeSymbolicId, newSymbolicId) && ids != null) {
                        WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(ids);
                        WorkspaceEntity existingEntity = existingEntityData.createEntity(this);
                        this.removeEntity(existingEntity);
                        LOG.error(StringsKt.trimIndent((String)("\n              modifyEntity: persistent id already exists. Replacing entity with the new one.\n              Old entity: " + existingEntityData + "\n              Persistent id: " + copiedData + "\n              \n              Broken consistency: " + this.getBrokenConsistency$intellij_platform_workspace_storage() + "\n            ")), (Throwable)new SymbolicIdAlreadyExistsException(newSymbolicId));
                    }
                } else {
                    LOG.error("Persistent id expected for entity: " + copiedData);
                }
            }
            this.changeLog.addReplaceDataEvent$intellij_platform_workspace_storage(entityId, copiedData, originalEntityData, true);
            if (((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty().contains("entitySource")) {
                EntitySource newSource = copiedData.getEntitySource();
                ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspace_storage().getEntitySourceIndex$intellij_platform_workspace_storage()).index$intellij_platform_workspace_storage(entityId, newSource);
                VirtualFileUrl virtualFileUrl = newSource.getVirtualFileUrl();
                if (virtualFileUrl != null) {
                    VirtualFileUrl it = virtualFileUrl;
                    boolean bl5 = false;
                    this.getIndexes$intellij_platform_workspace_storage().getVirtualFileIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(entityId, "entitySource", it);
                }
            }
            Object updatedEntity = copiedData.createEntity(this);
            if (!((Collection)((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty()).isEmpty()) {
                this.getIndexes$intellij_platform_workspace_storage().updateSymbolicIdIndexes(this, (WorkspaceEntity)updatedEntity, beforeSymbolicId, copiedData, (ModifiableWorkspaceEntityBase)modifiableEntity);
                this.trackChangedSoftLinks$intellij_platform_workspace_storage();
            }
            obj = updatedEntity;
        }
        finally {
            this.finishWriting();
        }
        Object updatedEntity = obj;
        value$iv = (T)updatedEntity;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntity(@NotNull WorkspaceEntity e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AtomicLong arg0$iv = removeEntityTimeMs;
        boolean bl2 = false;
        Boolean value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            this.startWriting();
            if (e instanceof ModifiableWorkspaceEntityBase && ((ModifiableWorkspaceEntityBase)((Object)e)).getDiff() != this) {
                throw new IllegalStateException("Trying to remove entity from a different builder".toString());
            }
            Logger $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl5 = false;
                logger.debug("Removing " + e.getClass() + "...", t$iv);
            }
            WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)e;
            bl = MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(this, ((WorkspaceEntityBase)e).getId(), null, 2, null);
        }
        finally {
            this.finishWriting();
        }
        boolean result = bl;
        value$iv = result;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter, @NotNull EntityStorage replaceWith) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
        AtomicLong arg0$iv = replaceBySourceTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.startWriting();
            AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)replaceWith;
            ReplaceBySourceAsTree rbsEngine = new ReplaceBySourceAsTree();
            if (this.keepLastRbsEngine) {
                this.engine = rbsEngine;
            }
            Function1<? super ReplaceBySourceAsTree, Unit> function1 = this.upgradeEngine;
            if (function1 != null) {
                Function1<? super ReplaceBySourceAsTree, Unit> it = function1;
                boolean bl4 = false;
                it.invoke((Object)rbsEngine);
            }
            rbsEngine.replace(this, (AbstractEntityStorage)replaceWith, sourceFilter);
        }
        finally {
            this.finishWriting();
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    @Override
    @NotNull
    public Set<ReferenceChange<?>> collectSymbolicEntityIdsChanges() {
        Set result = new LinkedHashSet();
        for (SymbolicEntityId<?> entry : this.changeLog.addedSymbolicIds$intellij_platform_workspace_storage()) {
            result.add(new ReferenceChange.Added(entry));
        }
        for (SymbolicEntityId<?> entry : this.changeLog.removedSymbolicIds$intellij_platform_workspace_storage()) {
            result.add(new ReferenceChange.Removed(entry));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Class<?>, List<EntityChange<?>>> collectChanges() {
        void var3_3;
        Map map2;
        AtomicLong arg0$iv = collectChangesTimeMs;
        boolean bl = false;
        Map value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.changeLog.getChangeLog$intellij_platform_workspace_storage().isEmpty()) {
            map2 = MapsKt.emptyMap();
        } else {
            HashMap<Object, List> hashMap;
            HashMap firstAddedIndex = new HashMap();
            try {
                this.startWriting();
                HashMap<Object, List> result = new HashMap<Object, List>();
                for (Map.Entry<Long, ChangeEntry> entry : this.changeLog.getChangeLog$intellij_platform_workspace_storage().entrySet()) {
                    List list;
                    List $this$collectChanges_u24lambda_u240_u242;
                    long entityId = ((Number)entry.getKey()).longValue();
                    ChangeEntry change = entry.getValue();
                    ChangeEntry changeEntry = change;
                    if (changeEntry instanceof ChangeEntry.AddEntity) {
                        List list2;
                        WorkspaceEntityBase addedEntity = UtilsKt.asBase(((ChangeEntry.AddEntity)change).getEntityData().createEntity(this));
                        Class<WorkspaceEntity> entityInterface = ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(entityId));
                        $this$collectChanges_u24lambda_u240_u242 = list2 = result.computeIfAbsent(entityInterface, arg_0 -> MutableEntityStorageImpl.collectChanges$lambda$0$1(MutableEntityStorageImpl::collectChanges$lambda$0$0, arg_0));
                        boolean bl4 = false;
                        $this$collectChanges_u24lambda_u240_u242.add(new EntityChange.Added<WorkspaceEntity>(addedEntity));
                        if (!((Map)firstAddedIndex).containsKey(entityInterface)) {
                            ((Map)firstAddedIndex).put(entityInterface, $this$collectChanges_u24lambda_u240_u242.size() - 1);
                        }
                        list = list2;
                        continue;
                    }
                    if (changeEntry instanceof ChangeEntry.RemoveEntity) {
                        WorkspaceEntityData<? extends WorkspaceEntity> removedData;
                        if (this.originalSnapshot.entityDataById$intellij_platform_workspace_storage(((ChangeEntry.RemoveEntity)change).getId()) == null) continue;
                        WorkspaceEntityBase removedEntity = UtilsKt.asBase(removedData.createEntity(this.originalSnapshot));
                        Class<WorkspaceEntity> entityInterface = ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(entityId));
                        List $this$collectChanges_u24lambda_u240_u245 = $this$collectChanges_u24lambda_u240_u242 = result.computeIfAbsent(entityInterface, arg_0 -> MutableEntityStorageImpl.collectChanges$lambda$0$4(MutableEntityStorageImpl::collectChanges$lambda$0$3, arg_0));
                        boolean bl5 = false;
                        $this$collectChanges_u24lambda_u240_u245.add(0, new EntityChange.Removed<WorkspaceEntity>(removedEntity));
                        if (((Map)firstAddedIndex).containsKey(entityInterface)) {
                            ((Map)firstAddedIndex).put(entityInterface, ((Number)MapsKt.getValue((Map)firstAddedIndex, entityInterface)).intValue() + 1);
                        }
                        list = $this$collectChanges_u24lambda_u240_u242;
                        continue;
                    }
                    if (changeEntry instanceof ChangeEntry.ReplaceEntity) {
                        List list3;
                        WorkspaceEntityData<? extends WorkspaceEntity> oldData;
                        if (this.originalSnapshot.entityDataById$intellij_platform_workspace_storage(entityId) == null) continue;
                        WorkspaceEntityBase replacedData = UtilsKt.asBase(oldData.createEntity(this.originalSnapshot));
                        WorkspaceEntity replaceToData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(entityId).createEntity(this);
                        Class<WorkspaceEntity> entityInterface = ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(entityId));
                        List $this$collectChanges_u24lambda_u240_u248 = list3 = result.computeIfAbsent(entityInterface, arg_0 -> MutableEntityStorageImpl.collectChanges$lambda$0$7(MutableEntityStorageImpl::collectChanges$lambda$0$6, arg_0));
                        boolean bl6 = false;
                        Integer n = firstAddedIndex.getOrDefault(entityInterface, $this$collectChanges_u24lambda_u240_u248.size());
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
                        $this$collectChanges_u24lambda_u240_u248.add(((Number)n).intValue(), new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData));
                        if (((Map)firstAddedIndex).containsKey(entityInterface)) {
                            ((Map)firstAddedIndex).put(entityInterface, ((Number)MapsKt.getValue((Map)firstAddedIndex, entityInterface)).intValue() + 1);
                        }
                        list = list3;
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                hashMap = result;
            }
            finally {
                this.finishWriting();
            }
            map2 = hashMap;
        }
        value$iv = map2;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasSameEntities() {
        void var3_3;
        boolean bl;
        AtomicLong arg0$iv = hasSameEntitiesTimeMs;
        boolean bl2 = false;
        Boolean value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.changeLog.getChangeLog$intellij_platform_workspace_storage().isEmpty()) {
            bl = true;
        } else {
            Object object;
            ImmutableEntityStorageImpl original = this.originalSnapshot;
            ArrayList<WorkspaceEntityData<? extends WorkspaceEntity>> adds = new ArrayList<WorkspaceEntityData<? extends WorkspaceEntity>>();
            Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
            Map removes = map2;
            Map<Long, ChangeEntry> $this$forEach$iv = this.changeLog.getChangeLog$intellij_platform_workspace_storage();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Long, ChangeEntry>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2;
                List list;
                Object element$iv;
                Object object3 = element$iv = iterator.next();
                boolean bl5 = false;
                ChangeEntry value = object3.getValue();
                if (value instanceof ChangeEntry.AddEntity) {
                    adds.add(((ChangeEntry.AddEntity)value).getEntityData());
                    continue;
                }
                if (!(value instanceof ChangeEntry.RemoveEntity)) continue;
                List existingValue = (List)removes.get(((ChangeEntry.RemoveEntity)value).getOldData());
                Map map3 = removes;
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = ((ChangeEntry.RemoveEntity)value).getOldData();
                if (existingValue != null) {
                    list = new ArrayList(CollectionsKt.plus((Collection)existingValue, ((ChangeEntry.RemoveEntity)value).getOldData()));
                } else {
                    object2 = new WorkspaceEntityData[]{((ChangeEntry.RemoveEntity)value).getOldData()};
                    list = CollectionsKt.mutableListOf((Object[])object2);
                }
                object2 = list;
                map3.put(workspaceEntityData, object2);
            }
            ArrayList idsToRemove = new ArrayList();
            Iterable $this$forEach$iv2 = adds;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                boolean hasRemovedMapping;
                boolean bl6;
                long initialEntityId;
                WorkspaceEntityData found;
                long newEntityId;
                List possibleRemovedSameEntity;
                WorkspaceEntityData addedEntityData;
                block25: {
                    WorkspaceEntityData workspaceEntityData;
                    boolean hasMapping;
                    Object element$iv2;
                    boolean bl7;
                    block23: {
                        addedEntityData = (WorkspaceEntityData)element$iv;
                        boolean bl8 = false;
                        if (removes.isEmpty()) continue;
                        possibleRemovedSameEntity = (List)removes.get(addedEntityData);
                        newEntityId = addedEntityData.createEntityId();
                        Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> $this$any$iv = this.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage();
                        boolean $i$f$any = false;
                        if ($this$any$iv.isEmpty()) {
                            bl7 = false;
                        } else {
                            Iterator<Map.Entry<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>>> iterator2 = $this$any$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                object = element$iv2 = iterator2.next();
                                boolean bl9 = false;
                                MutableExternalEntityMappingImpl<?> value = object.getValue();
                                if (!(value.getDataByEntityId$intellij_platform_workspace_storage(newEntityId) != null)) continue;
                                bl7 = true;
                                break block23;
                            }
                            bl7 = false;
                        }
                    }
                    if (hasMapping = bl7) continue;
                    List list = possibleRemovedSameEntity;
                    if (list != null) {
                        Object v5;
                        block24: {
                            Iterable $this$firstOrNull$iv = list;
                            boolean $i$f$firstOrNull = false;
                            element$iv2 = $this$firstOrNull$iv.iterator();
                            while (element$iv2.hasNext()) {
                                Object element$iv3 = element$iv2.next();
                                WorkspaceEntityData possibleRemovedSame = (WorkspaceEntityData)element$iv3;
                                boolean bl10 = false;
                                if (!this.same(original, newEntityId, possibleRemovedSame.createEntityId())) continue;
                                v5 = element$iv3;
                                break block24;
                            }
                            v5 = null;
                        }
                        workspaceEntityData = v5;
                    } else {
                        workspaceEntityData = null;
                    }
                    if ((found = workspaceEntityData) == null) continue;
                    initialEntityId = found.createEntityId();
                    Map<ExternalMappingKey<?>, ImmutableExternalEntityMappingImpl<?>> $this$any$iv = original.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage();
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl6 = false;
                    } else {
                        Iterator<Map.Entry<ExternalMappingKey<?>, ImmutableExternalEntityMappingImpl<?>>> iterator3 = $this$any$iv.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            Map.Entry<ExternalMappingKey<?>, ImmutableExternalEntityMappingImpl<?>> element$iv4;
                            Map.Entry<ExternalMappingKey<?>, ImmutableExternalEntityMappingImpl<?>> entry = element$iv4 = iterator3.next();
                            boolean bl11 = false;
                            ImmutableExternalEntityMappingImpl<?> value = entry.getValue();
                            if (!(value.getDataByEntityId$intellij_platform_workspace_storage(initialEntityId) != null)) continue;
                            bl6 = true;
                            break block25;
                        }
                        bl6 = false;
                    }
                }
                if (hasRemovedMapping = bl6) continue;
                possibleRemovedSameEntity.remove(found);
                if (possibleRemovedSameEntity.isEmpty()) {
                    removes.remove(addedEntityData);
                }
                ((Collection)idsToRemove).add(TuplesKt.to((Object)newEntityId, (Object)initialEntityId));
            }
            HashSet<Long> collapsibleChanges = new HashSet<Long>();
            Iterable $this$forEach$iv3 = idsToRemove;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                Pair pair = (Pair)element$iv;
                boolean bl12 = false;
                long l = ((Number)pair.component1()).longValue();
                long initial = ((Number)pair.component2()).longValue();
                collapsibleChanges.add(l);
                collapsibleChanges.add(initial);
                Map<ConnectionId, ParentEntityId> $this$forEach$iv4 = this.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(l));
                boolean $i$f$forEach4 = false;
                object = $this$forEach$iv4.entrySet().iterator();
                while (object.hasNext()) {
                    Object object4;
                    Object object5;
                    Pair it;
                    Pair pair2;
                    Map.Entry element$iv5;
                    Map.Entry entry = element$iv5 = (Map.Entry)object.next();
                    boolean bl13 = false;
                    ConnectionId connection = (ConnectionId)entry.getKey();
                    long parent = ((ParentEntityId)entry.getValue()).unbox-impl();
                    ChangeEntry changedParent = this.changeLog.getChangeLog$intellij_platform_workspace_storage().get(parent);
                    if (!(changedParent instanceof ChangeEntry.ReplaceEntity)) continue;
                    ChangeEntry.ReplaceEntity.Data data = ((ChangeEntry.ReplaceEntity)changedParent).getData();
                    ChangeEntry.ReplaceEntity.Data data2 = ((ChangeEntry.ReplaceEntity)changedParent).getData();
                    if (!Intrinsics.areEqual(data != null ? data.getNewData() : null, data2 != null ? data2.getOldData() : null)) continue;
                    PersistentMap<ConnectionId, ParentEntityId> persistentMap = ((ChangeEntry.ReplaceEntity)changedParent).getReferences();
                    boolean bl14 = persistentMap != null && (persistentMap = persistentMap.getNewParents()) != null ? persistentMap.isEmpty() : false;
                    if (!bl14 || !((ChangeEntry.ReplaceEntity)changedParent).getReferences().getRemovedParents().isEmpty()) continue;
                    if ((Pair)CollectionsKt.singleOrNull((Iterable)((Iterable)((ChangeEntry.ReplaceEntity)changedParent).getReferences().getRemovedChildren())) != null) {
                        it = pair2;
                        boolean bl15 = false;
                        object5 = Intrinsics.areEqual((Object)it.getFirst(), (Object)connection) && ((ChildEntityId)it.getSecond()).unbox-impl() == initial ? pair2 : null;
                    } else {
                        object5 = null;
                    }
                    if (object5 == null) continue;
                    if ((Pair)CollectionsKt.singleOrNull((Iterable)((Iterable)((ChangeEntry.ReplaceEntity)changedParent).getReferences().getNewChildren())) != null) {
                        it = pair2;
                        boolean bl16 = false;
                        object4 = Intrinsics.areEqual((Object)it.getFirst(), (Object)connection) && ((ChildEntityId)it.getSecond()).unbox-impl() == l ? pair2 : null;
                    } else {
                        object4 = null;
                    }
                    if (object4 == null) continue;
                    collapsibleChanges.add(parent);
                }
            }
            bl = Intrinsics.areEqual(collapsibleChanges, this.changeLog.getChangeLog$intellij_platform_workspace_storage().keySet());
        }
        value$iv = bl;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return var3_3.booleanValue();
    }

    private final boolean same(AbstractEntityStorage originalImpl, long addedEntityId, long removedEntityId) {
        boolean bl;
        block8: {
            if (addedEntityId == removedEntityId) {
                return true;
            }
            if (EntityIdKt.getClazz(addedEntityId) != EntityIdKt.getClazz(removedEntityId)) {
                return false;
            }
            Map<ConnectionId, ParentEntityId> addedParents = this.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(addedEntityId));
            Map<ConnectionId, ParentEntityId> removeParents = originalImpl.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(removedEntityId));
            if (!Intrinsics.areEqual(addedParents.keySet(), removeParents.keySet())) {
                return false;
            }
            Iterable $this$all$iv = addedParents.entrySet();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl3 = false;
                    ConnectionId connectionId = (ConnectionId)entry.getKey();
                    long addedParentEntityId = ((ParentEntityId)entry.getValue()).unbox-impl();
                    ParentEntityId parentEntityId = removeParents.get(connectionId);
                    Intrinsics.checkNotNull((Object)parentEntityId);
                    long removedParentEntityId = parentEntityId.unbox-impl();
                    if (ParentEntityId.equals-impl0(addedParentEntityId, removedParentEntityId)) {
                        bl2 = true;
                    } else {
                        ChangeEntry addedParentInfo = this.changeLog.getChangeLog$intellij_platform_workspace_storage().get(addedParentEntityId);
                        ChangeEntry removedParentInfo = this.changeLog.getChangeLog$intellij_platform_workspace_storage().get(removedParentEntityId);
                        bl2 = addedParentInfo instanceof ChangeEntry.AddEntity && removedParentInfo instanceof ChangeEntry.RemoveEntity ? this.same(originalImpl, addedParentEntityId, removedParentEntityId) : false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ImmutableEntityStorage toSnapshot() {
        void var3_3;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        AtomicLong arg0$iv = toSnapshotTimeMs;
        boolean bl = false;
        ImmutableEntityStorageImpl value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ImmutableEntitiesBarrel newEntities = this.getEntitiesByType$intellij_platform_workspace_storage().toImmutable();
        RefsTable newRefs = this.getRefs$intellij_platform_workspace_storage().toImmutable();
        ImmutableStorageIndexes newIndexes = this.getIndexes$intellij_platform_workspace_storage().toImmutable();
        TracedSnapshotCacheImpl cache = new TracedSnapshotCacheImpl();
        ImmutableEntityStorageImpl snapshot = new ImmutableEntityStorageImpl(newEntities, newRefs, newIndexes, cache);
        Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> $this$mapValues$iv = this.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage();
        boolean $i$f$mapValues = false;
        Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl4 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl5 = false;
            Set<Long> set = ((MutableExternalEntityMappingImpl)it.getValue()).getIndexLogBunches$intellij_platform_workspace_storage().getChanges().keySet();
            map4.put(k, set);
        }
        Map externalMappingChangelog = destination$iv$iv$iv;
        ChangeOnWorkspaceBuilderChangeLog changes = new ChangeOnWorkspaceBuilderChangeLog(this.changeLog, externalMappingChangelog);
        cache.pullCache(snapshot, this.originalSnapshot.getSnapshotCache$intellij_platform_workspace_storage(), changes);
        value$iv = snapshot;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (ImmutableEntityStorage)var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceChildren(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity.Builder<? extends WorkspaceEntity> parent, @NotNull List<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>> newChildren) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(newChildren, (String)"newChildren");
        try {
            this.startWriting();
            switch (WhenMappings.$EnumSwitchMapping$0[connectionId.getConnectionType().ordinal()]) {
                case 1: {
                    Long existingChildId;
                    long parentId = UtilsKt.asBase(parent).getId();
                    if (!(newChildren.size() <= 1)) {
                        boolean $i$a$-check-MutableEntityStorageImpl$replaceChildren$22 = false;
                        String $i$a$-check-MutableEntityStorageImpl$replaceChildren$22 = "ONE_TO_ONE connection may have only one child";
                        throw new IllegalStateException($i$a$-check-MutableEntityStorageImpl$replaceChildren$22.toString());
                    }
                    ModifiableWorkspaceEntityBase modifiableWorkspaceEntityBase = (ModifiableWorkspaceEntityBase)CollectionsKt.singleOrNull(newChildren);
                    ChildEntityId childId = modifiableWorkspaceEntityBase != null && (modifiableWorkspaceEntityBase = UtilsKt.asBase(modifiableWorkspaceEntityBase)) != null ? ChildEntityId.box-impl(RefsTableKt.asChild(modifiableWorkspaceEntityBase.getId())) : null;
                    ChildEntityId childEntityId = (ChildEntityId)CollectionsKt.singleOrNull(this.getRefs$intellij_platform_workspace_storage().getChildrenByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentId)));
                    Long l = existingChildId = childEntityId != null ? Long.valueOf(childEntityId.unbox-impl()) : null;
                    if (!(connectionId.isParentNullable() || existingChildId == null || childId != null && childId.unbox-impl() == existingChildId.longValue())) {
                        MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(this, existingChildId, null, 2, null);
                    }
                    if (childId != null) {
                        UtilsKt.checkCircularDependency(connectionId, EntityIdKt.getArrayId(childId.unbox-impl()), EntityIdKt.getArrayId(parentId), this);
                        List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToOneChildOfParent-V33mNh8(connectionId, parentId, childId.unbox-impl());
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                        return;
                    } else {
                        List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().removeRefsByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentId));
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                        return;
                    }
                }
                case 2: {
                    void $this$mapTo$iv$iv;
                    long parentId = UtilsKt.asBase(parent).getId();
                    Iterable $this$map$iv = newChildren;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        WorkspaceEntity.Builder builder = (WorkspaceEntity.Builder)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(ChildEntityId.box-impl(RefsTableKt.asChild(UtilsKt.asBase(it).getId())));
                    }
                    List childrenIds = (List)((Object)destination$iv$iv);
                    if (!connectionId.isParentNullable()) {
                        Set existingChildren = CollectionsKt.toMutableSet((Iterable)this.getRefs$intellij_platform_workspace_storage().getChildrenByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentId)));
                        Iterable $this$forEach$iv = childrenIds;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            long it = ((ChildEntityId)element$iv).unbox-impl();
                            boolean bl = false;
                            existingChildren.remove(ChildEntityId.box-impl(it));
                        }
                        $this$forEach$iv = existingChildren;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            long it = ((ChildEntityId)element$iv).unbox-impl();
                            boolean bl = false;
                            MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(this, it, null, 2, null);
                        }
                    }
                    Iterable $this$forEach$iv = childrenIds;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        long it = ((ChildEntityId)element$iv).unbox-impl();
                        boolean bl = false;
                        UtilsKt.checkCircularDependency(connectionId, EntityIdKt.getArrayId(it), EntityIdKt.getArrayId(parentId), this);
                    }
                    List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToManyChildrenOfParent(connectionId, parentId, childrenIds);
                    UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                    return;
                }
                case 3: {
                    void $this$mapTo$iv$iv;
                    long parentId = RefsTableKt.asParent(UtilsKt.asBase(parent).getId());
                    Iterable $this$map$iv = newChildren;
                    boolean $i$f$map = false;
                    Iterable $i$f$forEach = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        WorkspaceEntity.Builder bl = (WorkspaceEntity.Builder)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(ChildEntityId.box-impl(RefsTableKt.asChild(UtilsKt.asBase(it).getId())));
                    }
                    List childrenIds = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = childrenIds;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        long it = ((ChildEntityId)element$iv).unbox-impl();
                        boolean bl = false;
                        UtilsKt.checkCircularDependency(it, parentId, this);
                    }
                    List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToAbstractManyChildrenOfParent-GnhP5Uc(connectionId, parentId, childrenIds);
                    UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                    return;
                }
                case 4: {
                    ChildEntityId childId;
                    long parentId = RefsTableKt.asParent(UtilsKt.asBase(parent).getId());
                    if (!(newChildren.size() <= 1)) {
                        boolean $i$a$-check-MutableEntityStorageImpl$replaceChildren$72 = false;
                        String $i$a$-check-MutableEntityStorageImpl$replaceChildren$72 = "ABSTRACT_ONE_TO_ONE connection may have only one child";
                        throw new IllegalStateException($i$a$-check-MutableEntityStorageImpl$replaceChildren$72.toString());
                    }
                    ModifiableWorkspaceEntityBase modifiableWorkspaceEntityBase = (ModifiableWorkspaceEntityBase)CollectionsKt.singleOrNull(newChildren);
                    ChildEntityId childEntityId = modifiableWorkspaceEntityBase != null && (modifiableWorkspaceEntityBase = UtilsKt.asBase(modifiableWorkspaceEntityBase)) != null ? ChildEntityId.box-impl(RefsTableKt.asChild(modifiableWorkspaceEntityBase.getId())) : (childId = null);
                    if (childId != null) {
                        List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToAbstractOneChildOfParent-0Hr_qaU(connectionId, parentId, childId.unbox-impl());
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                        return;
                    } else {
                        List<Modification> operation = this.getRefs$intellij_platform_workspace_storage().removeRefsByParent-ePHS_xw(connectionId, parentId);
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)operation, connectionId);
                        return;
                    }
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        finally {
            this.finishWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChild(@NotNull ConnectionId connectionId, @Nullable WorkspaceEntity.Builder<? extends WorkspaceEntity> parent, @NotNull WorkspaceEntity.Builder<? extends WorkspaceEntity> child) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        try {
            this.startWriting();
            switch (WhenMappings.$EnumSwitchMapping$0[connectionId.getConnectionType().ordinal()]) {
                case 1: {
                    List<Modification> modifications;
                    WorkspaceEntityData<?> existingChild;
                    WorkspaceEntity.Builder<? extends WorkspaceEntity> builder = parent;
                    ParentEntityId parentId = builder != null && (builder = UtilsKt.asBase(builder)) != null ? ParentEntityId.box-impl(RefsTableKt.asParent(((ModifiableWorkspaceEntityBase)builder).getId())) : null;
                    long childId = UtilsKt.asBase(child).getId();
                    if (!connectionId.isParentNullable() && parentId != null && (existingChild = this.getOneChildData(connectionId, UtilsKt.asBase(parent).getId())) != null && existingChild.createEntityId() != UtilsKt.asBase(child).getId()) {
                        MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(this, existingChild.createEntityId(), null, 2, null);
                    }
                    if (parentId != null) {
                        UtilsKt.checkCircularDependency(connectionId, EntityIdKt.getArrayId(childId), EntityIdKt.getArrayId(parentId.unbox-impl()), this);
                        modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToOneParentOfChild(connectionId, childId, parentId.unbox-impl());
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                        return;
                    } else {
                        modifications = this.getRefs$intellij_platform_workspace_storage().removeOneToOneRefByChild(connectionId, childId);
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                        return;
                    }
                }
                case 2: {
                    ParentEntityId parentId;
                    long childId = RefsTableKt.asChild(UtilsKt.asBase(child).getId());
                    WorkspaceEntity.Builder<? extends WorkspaceEntity> builder = parent;
                    ParentEntityId parentEntityId = builder != null && (builder = UtilsKt.asBase(builder)) != null ? ParentEntityId.box-impl(RefsTableKt.asParent(((ModifiableWorkspaceEntityBase)builder).getId())) : (parentId = null);
                    if (parentId != null) {
                        UtilsKt.checkCircularDependency(connectionId, EntityIdKt.getArrayId(childId), EntityIdKt.getArrayId(parentId.unbox-impl()), this);
                        List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToManyParentOfChild-b-W3xc0(connectionId, childId, parentId.unbox-impl());
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                        return;
                    } else {
                        Modification modification = this.getRefs$intellij_platform_workspace_storage().removeOneToManyRefsByChild-35tkxxE(connectionId, childId);
                        if (modification == null) return;
                        UtilsKt.createReplaceEventsForUpdates(this, CollectionsKt.listOf((Object)modification), connectionId);
                        return;
                    }
                }
                case 3: {
                    ParentEntityId parentId;
                    long childId = RefsTableKt.asChild(UtilsKt.asBase(child).getId());
                    WorkspaceEntity.Builder<? extends WorkspaceEntity> builder = parent;
                    ParentEntityId parentEntityId = builder != null && (builder = UtilsKt.asBase(builder)) != null ? ParentEntityId.box-impl(RefsTableKt.asParent(((ModifiableWorkspaceEntityBase)builder).getId())) : (parentId = null);
                    if (parentId != null) {
                        UtilsKt.checkCircularDependency(childId, parentId.unbox-impl(), this);
                        List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToAbstractManyParentOfChild-bAjmN0I(connectionId, childId, parentId.unbox-impl());
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                        return;
                    } else {
                        Modification modification = this.getRefs$intellij_platform_workspace_storage().removeOneToAbstractManyRefsByChild-35tkxxE(connectionId, childId);
                        if (modification == null) return;
                        UtilsKt.createReplaceEventsForUpdates(this, CollectionsKt.listOf((Object)modification), connectionId);
                        return;
                    }
                }
                case 4: {
                    WorkspaceEntityData<?> existingChild;
                    WorkspaceEntity.Builder<? extends WorkspaceEntity> builder = parent;
                    ParentEntityId parentId = builder != null && (builder = UtilsKt.asBase(builder)) != null ? ParentEntityId.box-impl(RefsTableKt.asParent(((ModifiableWorkspaceEntityBase)builder).getId())) : null;
                    long childId = RefsTableKt.asChild(UtilsKt.asBase(child).getId());
                    if (!connectionId.isParentNullable() && parentId != null && (existingChild = this.getOneChildData(connectionId, UtilsKt.asBase(parent).getId())) != null && existingChild.createEntityId() != UtilsKt.asBase(child).getId()) {
                        MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(this, existingChild.createEntityId(), null, 2, null);
                    }
                    if (parentId != null) {
                        List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToAbstractOneParentOfChild-bAjmN0I(connectionId, childId, parentId.unbox-impl());
                        UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                        return;
                    } else {
                        Modification modification = this.getRefs$intellij_platform_workspace_storage().removeOneToAbstractOneRefByChild-35tkxxE(connectionId, childId);
                        if (modification == null) return;
                        UtilsKt.createReplaceEventsForUpdates(this, CollectionsKt.listOf((Object)modification), connectionId);
                        return;
                    }
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        finally {
            this.finishWriting();
        }
    }

    @Override
    @Nullable
    public WorkspaceEntity.Builder<?> getOneChildBuilder(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity.Builder<?> parent) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        WorkspaceEntityData<?> workspaceEntityData = this.getOneChildData(connectionId, ((ModifiableWorkspaceEntityBase)parent).getId());
        return workspaceEntityData != null ? workspaceEntityData.wrapAsModifiable(this) : null;
    }

    @Override
    @NotNull
    public Sequence<WorkspaceEntity.Builder<?>> getManyChildrenBuilders(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity.Builder<?> parent) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        return SequencesKt.map(this.getManyChildrenData(connectionId, ((ModifiableWorkspaceEntityBase)parent).getId()), arg_0 -> MutableEntityStorageImpl.getManyChildrenBuilders$lambda$0(this, arg_0));
    }

    @Override
    @Nullable
    public WorkspaceEntity.Builder<?> getParentBuilder(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity.Builder<?> child) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        WorkspaceEntityData<?> workspaceEntityData = this.getParentData(connectionId, ((ModifiableWorkspaceEntityBase)child).getId());
        return workspaceEntityData != null ? workspaceEntityData.wrapAsModifiable(this) : null;
    }

    @Override
    public boolean hasChanges() {
        return !this.changeLog.getChangeLog$intellij_platform_workspace_storage().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyChangesFrom(@NotNull MutableEntityStorage builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        AtomicLong arg0$iv = applyChangesFromTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.startWriting();
            MutableEntityStorageImpl cfr_ignored_0 = (MutableEntityStorageImpl)builder;
            ApplyChangesFromOperation applyChangesFromOperation = new ApplyChangesFromOperation(this, (MutableEntityStorageImpl)builder);
            Function1<? super ApplyChangesFromOperation, Unit> function1 = this.upgradeApplyChangesFromEngine;
            if (function1 != null) {
                function1.invoke((Object)applyChangesFromOperation);
            }
            applyChangesFromOperation.applyChangesFrom();
        }
        finally {
            this.finishWriting();
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> MutableExternalEntityMapping<T> getMutableExternalMapping(@NotNull ExternalMappingKey<T> identifier) {
        MutableExternalEntityMappingImpl mutableExternalEntityMappingImpl;
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        AtomicLong arg0$iv = getMutableExternalMappingTimeMs;
        boolean bl = false;
        MutableExternalEntityMappingImpl value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.startWriting();
            MutableExternalEntityMappingImpl mutableExternalEntityMappingImpl2 = this.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage().computeIfAbsent(identifier, arg_0 -> MutableEntityStorageImpl.getMutableExternalMapping$lambda$0$1(MutableEntityStorageImpl::getMutableExternalMapping$lambda$0$0, arg_0));
            Intrinsics.checkNotNull((Object)mutableExternalEntityMappingImpl2, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.external.MutableExternalEntityMappingImpl<T of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.getMutableExternalMapping>");
            MutableExternalEntityMappingImpl mapping = mutableExternalEntityMappingImpl2;
            mapping.setTypedEntityStorage$intellij_platform_workspace_storage(this);
            mutableExternalEntityMappingImpl = mapping;
        }
        finally {
            this.finishWriting();
        }
        value$iv = mutableExternalEntityMappingImpl;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final MutableVirtualFileUrlIndex getMutableVirtualFileUrlIndex() {
        void var3_3;
        VirtualFileIndex.MutableVirtualFileIndex mutableVirtualFileIndex;
        AtomicLong arg0$iv = getMutableVFUrlIndexTimeMs;
        boolean bl = false;
        VirtualFileIndex.MutableVirtualFileIndex value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.startWriting();
            VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex = this.getIndexes$intellij_platform_workspace_storage().getVirtualFileIndex$intellij_platform_workspace_storage();
            virtualFileIndex.setTypedEntityStorage$intellij_platform_workspace_storage(this);
            mutableVirtualFileIndex = virtualFileIndex;
        }
        finally {
            this.finishWriting();
        }
        value$iv = mutableVirtualFileIndex;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (MutableVirtualFileUrlIndex)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyChangesFromProtection(AbstractEntityStorage builder) {
        Object object;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            boolean bl = false;
            object.trace("Applying applyChangesFrom. Builder: " + builder);
        }
        if (builder.getStorageIsAlreadyApplied$intellij_platform_workspace_storage()) {
            LOG.error("Builder is already applied.\n Info: \n" + builder.getApplyInfo$intellij_platform_workspace_storage());
        } else {
            builder.setStorageIsAlreadyApplied$intellij_platform_workspace_storage(true);
            if (LOG.isTraceEnabled()) {
                void $this$applyChangesFromProtection_u24lambda_u241;
                StringBuilder stringBuilder;
                StringBuilder $i$f$trace2 = stringBuilder = new StringBuilder();
                object = builder;
                boolean bl = false;
                $this$applyChangesFromProtection_u24lambda_u241.append("Applying builder using applyChangesFrom. Previous stack trace >>>>").append('\n');
                $this$applyChangesFromProtection_u24lambda_u241.append(ExceptionUtil.currentStackTrace()).append('\n');
                $this$applyChangesFromProtection_u24lambda_u241.append("<<<<").append('\n');
                ((AbstractEntityStorage)object).setApplyInfo$intellij_platform_workspace_storage(stringBuilder.toString());
            }
        }
    }

    public final boolean removeEntityByEntityId$intellij_platform_workspace_storage(long idx, @NotNull Function1<? super Long, Boolean> entityFilter) {
        Intrinsics.checkNotNullParameter(entityFilter, (String)"entityFilter");
        Object[] objectArray = new Long[]{idx};
        Set accumulator = SetsKt.mutableSetOf((Object[])objectArray);
        if (!this.getEntitiesByType$intellij_platform_workspace_storage().exists(idx)) {
            return false;
        }
        this.accumulateEntitiesToRemove(idx, accumulator, entityFilter);
        Iterable $this$forEach$iv = accumulator;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long id = ((Number)element$iv).longValue();
            boolean bl = false;
            this.removeSingleEntity$intellij_platform_workspace_storage(id, false, id == idx);
        }
        return true;
    }

    public static /* synthetic */ boolean removeEntityByEntityId$intellij_platform_workspace_storage$default(MutableEntityStorageImpl mutableEntityStorageImpl, long l, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = MutableEntityStorageImpl::removeEntityByEntityId$lambda$0;
        }
        return mutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage(l, (Function1<? super Long, Boolean>)function1);
    }

    public final void removeSingleEntity$intellij_platform_workspace_storage(long id, boolean updateChangelogForChildren, boolean updateChangelogForParents) {
        Map<ConnectionId, ParentEntityId> parents;
        WorkspaceEntityData<WorkspaceEntity> workspaceEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this, id);
        Intrinsics.checkNotNull(workspaceEntityData, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<com.intellij.platform.workspace.storage.WorkspaceEntity>");
        WorkspaceEntityData<WorkspaceEntity> originalEntityData = workspaceEntityData;
        Map<ConnectionId, List<ChildEntityId>> children = this.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(id));
        Iterable $this$forEach$iv = children.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConnectionId connectionId = (ConnectionId)element$iv;
            boolean bl = false;
            List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().removeRefsByParent-ePHS_xw(connectionId, RefsTableKt.asParent(id));
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("Perform modifications on children refs for " + connectionId + ": " + modifications);
            }
            if (!updateChangelogForChildren) continue;
            UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
        }
        Map<ConnectionId, ParentEntityId> $this$forEach$iv2 = parents = this.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(id));
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<ConnectionId, ParentEntityId>> iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ConnectionId, ParentEntityId> element$iv;
            Map.Entry<ConnectionId, ParentEntityId> entry = element$iv = iterator.next();
            boolean bl = false;
            ConnectionId connectionId = entry.getKey();
            long parentId = entry.getValue().unbox-impl();
            List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().removeParentToChildRef-0Hr_qaU(connectionId, parentId, RefsTableKt.asChild(id));
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("Perform modifications on parent refs for " + connectionId + ": " + modifications);
            }
            if (!updateChangelogForParents) continue;
            UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
        }
        WorkspaceEntityData<? extends WorkspaceEntity> entityData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(id);
        if (entityData instanceof SoftLinkable) {
            this.getIndexes$intellij_platform_workspace_storage().removeFromSoftLinksIndex((SoftLinkable)((Object)entityData));
            this.trackChangedSoftLinks$intellij_platform_workspace_storage();
        }
        this.getIndexes$intellij_platform_workspace_storage().entityRemoved(id);
        this.changeLog.addRemoveEvent$intellij_platform_workspace_storage(id, originalEntityData);
        this.getEntitiesByType$intellij_platform_workspace_storage().remove(EntityIdKt.getArrayId(id), EntityIdKt.getClazz(id));
    }

    private final void startWriting() {
        Thread currentThread = Thread.currentThread();
        if (this.writingFlag.getAndSet(true) && this.threadId != null) {
            Long l = this.threadId;
            long l2 = currentThread.getId();
            if (l == null || l != l2) {
                LOG.error(StringsKt.trimIndent((String)("\n            Concurrent write to builder from the following threads\n            First Thread: " + this.threadName + "\n            Second Thread: " + currentThread.getName() + "\n            Previous stack trace: " + this.stackTrace + "\n          ")));
                this.trackStackTrace = true;
            }
        }
        if (this.trackStackTrace || LOG.isTraceEnabled()) {
            this.stackTrace = ExceptionUtil.currentStackTrace();
        }
        this.threadId = currentThread.getId();
        this.threadName = currentThread.getName();
    }

    private final void finishWriting() {
        this.writingFlag.set(false);
        this.stackTrace = null;
        this.threadId = null;
        this.threadName = null;
    }

    private final void accumulateEntitiesToRemove(long id, Set<Long> accumulator, Function1<? super Long, Boolean> entityFilter) {
        Map<ConnectionId, List<ChildEntityId>> children = this.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(id));
        Iterator<Map.Entry<ConnectionId, List<ChildEntityId>>> iterator = children.entrySet().iterator();
        while (iterator.hasNext()) {
            List<ChildEntityId> childrenIds = iterator.next().getValue();
            Iterator<ChildEntityId> iterator2 = childrenIds.iterator();
            while (iterator2.hasNext()) {
                long childId = iterator2.next().unbox-impl();
                if (accumulator.contains(childId) || !((Boolean)entityFilter.invoke((Object)childId)).booleanValue()) continue;
                this.accumulateEntitiesToRemove(childId, accumulator, entityFilter);
                accumulator.add(childId);
            }
        }
    }

    public final void trackChangedSoftLinks$intellij_platform_workspace_storage() {
        this.changeLog.addAddedIds$intellij_platform_workspace_storage(this.getIndexes$intellij_platform_workspace_storage().getSoftLinks$intellij_platform_workspace_storage().addedValues$intellij_platform_workspace_storage());
        this.changeLog.addRemovedIds$intellij_platform_workspace_storage(this.getIndexes$intellij_platform_workspace_storage().getSoftLinks$intellij_platform_workspace_storage().removedValues$intellij_platform_workspace_storage());
        this.getIndexes$intellij_platform_workspace_storage().getSoftLinks$intellij_platform_workspace_storage().clearTrackedValues$intellij_platform_workspace_storage();
    }

    private static final WorkspaceEntity entities$lambda$0$0(MutableEntityStorageImpl this$0, WorkspaceEntityData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createEntity(this$0);
    }

    private static final boolean referrers$lambda$0$0(int $classId, long it) {
        return EntityIdKt.getClazz(it) == $classId;
    }

    private static final WorkspaceEntity referrers$lambda$0$1(MutableEntityStorageImpl this$0, long it) {
        WorkspaceEntity workspaceEntity = this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(it).createEntity(this$0);
        Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type R of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.referrers");
        return workspaceEntity;
    }

    private static final WorkspaceEntity entitiesBySource$lambda$0$0$0(MutableEntityStorageImpl this$0, long it) {
        return this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(it).createEntity(this$0);
    }

    private static final Sequence entitiesBySource$lambda$0$0(EntityStorageInternalIndex.MutableEntityStorageInternalIndex $index, MutableEntityStorageImpl this$0, EntitySource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        List<Long> list = $index.getIdsByEntry$intellij_platform_workspace_storage(source);
        if (list == null) {
            throw new IllegalStateException(("Entity source " + source + " expected to be in the index").toString());
        }
        List<Long> entityIds = list;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)entityIds), arg_0 -> MutableEntityStorageImpl.entitiesBySource$lambda$0$0$0(this$0, arg_0));
    }

    private static final List collectChanges$lambda$0$0(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List collectChanges$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List collectChanges$lambda$0$3(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List collectChanges$lambda$0$4(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List collectChanges$lambda$0$6(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List collectChanges$lambda$0$7(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final WorkspaceEntity.Builder getManyChildrenBuilders$lambda$0(MutableEntityStorageImpl this$0, WorkspaceEntityData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.wrapAsModifiable(this$0);
    }

    private static final MutableExternalEntityMappingImpl getMutableExternalMapping$lambda$0$0(ExternalMappingKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MutableExternalEntityMappingImpl();
    }

    private static final MutableExternalEntityMappingImpl getMutableExternalMapping$lambda$0$1(Function1 $tmp0, Object p0) {
        return (MutableExternalEntityMappingImpl)$tmp0.invoke(p0);
    }

    private static final boolean removeEntityByEntityId$lambda$0(long it) {
        return true;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MutableEntityStorageImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        instancesCounter = new AtomicLong();
        getEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        getReferrersTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        hasReferrersTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        resolveTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        getEntitiesBySourceTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        addEntityTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        putEntityTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        modifyEntityTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        removeEntityTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        replaceBySourceTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        collectChangesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        hasSameEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        toSnapshotTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        applyChangesFromTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        getMutableExternalMappingTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        getMutableVFUrlIndexTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        MutableEntityStorageImpl.Companion.setupOpenTelemetryReporting(TelemetryManager.Companion.getMeter(PlatformScopesKt.JPS));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0015\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0017\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "instancesCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "getEntitiesTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "getReferrersTimeMs", "hasReferrersTimeMs", "resolveTimeMs", "getEntitiesBySourceTimeMs", "addEntityTimeMs", "putEntityTimeMs", "modifyEntityTimeMs", "removeEntityTimeMs", "replaceBySourceTimeMs", "collectChangesTimeMs", "hasSameEntitiesTimeMs", "toSnapshotTimeMs", "applyChangesFromTimeMs", "getMutableExternalMappingTimeMs", "getMutableVFUrlIndexTimeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement instancesCountCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.instances.count").buildObserver();
            ObservableLongMeasurement getEntitiesTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.entities.ms").buildObserver();
            ObservableLongMeasurement getReferrersTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.referrers.ms").buildObserver();
            ObservableLongMeasurement hasReferrersTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.hasReferrers.ms").buildObserver();
            ObservableLongMeasurement resolveTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.resolve.ms").buildObserver();
            ObservableLongMeasurement getEntitiesBySourceTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.entities.by.source.ms").buildObserver();
            ObservableLongMeasurement addEntityTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.add.entity.ms").buildObserver();
            ObservableLongMeasurement putEntityTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.put.entity.ms").buildObserver();
            ObservableLongMeasurement modifyEntityTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.modify.entity.ms").buildObserver();
            ObservableLongMeasurement removeEntityTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.remove.entity.ms").buildObserver();
            ObservableLongMeasurement replaceBySourceTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.replace.by.source.ms").buildObserver();
            ObservableLongMeasurement collectChangesTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.collect.changes.ms").buildObserver();
            ObservableLongMeasurement hasSameEntitiesTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.has.same.entities.ms").buildObserver();
            ObservableLongMeasurement toSnapshotTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.to.snapshot.ms").buildObserver();
            ObservableLongMeasurement applyChangesFromTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.apply.changes.from.ms").buildObserver();
            ObservableLongMeasurement getMutableExternalMappingTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.mutable.ext.mapping.ms").buildObserver();
            ObservableLongMeasurement getMutableVFUrlIndexTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.mutable.vfurl.index.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{getEntitiesTimeCounter, getReferrersTimeCounter, hasReferrersTimeCounter, resolveTimeCounter, getEntitiesBySourceTimeCounter, addEntityTimeCounter, putEntityTimeCounter, modifyEntityTimeCounter, removeEntityTimeCounter, replaceBySourceTimeCounter, collectChangesTimeCounter, hasSameEntitiesTimeCounter, toSnapshotTimeCounter, applyChangesFromTimeCounter, getMutableExternalMappingTimeCounter, getMutableVFUrlIndexTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(instancesCountCounter, getEntitiesTimeCounter, getReferrersTimeCounter, hasReferrersTimeCounter, resolveTimeCounter, getEntitiesBySourceTimeCounter, addEntityTimeCounter, putEntityTimeCounter, modifyEntityTimeCounter, removeEntityTimeCounter, replaceBySourceTimeCounter, collectChangesTimeCounter, hasSameEntitiesTimeCounter, toSnapshotTimeCounter, applyChangesFromTimeCounter, getMutableExternalMappingTimeCounter, getMutableVFUrlIndexTimeCounter), (ObservableMeasurement)instancesCountCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $instancesCountCounter, ObservableLongMeasurement $getEntitiesTimeCounter, ObservableLongMeasurement $getReferrersTimeCounter, ObservableLongMeasurement $hasReferrersTimeCounter, ObservableLongMeasurement $resolveTimeCounter, ObservableLongMeasurement $getEntitiesBySourceTimeCounter, ObservableLongMeasurement $addEntityTimeCounter, ObservableLongMeasurement $putEntityTimeCounter, ObservableLongMeasurement $modifyEntityTimeCounter, ObservableLongMeasurement $removeEntityTimeCounter, ObservableLongMeasurement $replaceBySourceTimeCounter, ObservableLongMeasurement $collectChangesTimeCounter, ObservableLongMeasurement $hasSameEntitiesTimeCounter, ObservableLongMeasurement $toSnapshotTimeCounter, ObservableLongMeasurement $applyChangesFromTimeCounter, ObservableLongMeasurement $getMutableExternalMappingTimeCounter, ObservableLongMeasurement $getMutableVFUrlIndexTimeCounter) {
            $instancesCountCounter.record(instancesCounter.get());
            $getEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getEntitiesTimeMs));
            $getReferrersTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getReferrersTimeMs));
            $hasReferrersTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(hasReferrersTimeMs));
            $resolveTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(resolveTimeMs));
            $getEntitiesBySourceTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getEntitiesBySourceTimeMs));
            $addEntityTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(addEntityTimeMs));
            $putEntityTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(putEntityTimeMs));
            $modifyEntityTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(modifyEntityTimeMs));
            $removeEntityTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(removeEntityTimeMs));
            $replaceBySourceTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(replaceBySourceTimeMs));
            $collectChangesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(collectChangesTimeMs));
            $hasSameEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(hasSameEntitiesTimeMs));
            $toSnapshotTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(toSnapshotTimeMs));
            $applyChangesFromTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(applyChangesFromTimeMs));
            $getMutableExternalMappingTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getMutableExternalMappingTimeMs));
            $getMutableVFUrlIndexTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getMutableVFUrlIndexTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionId.ConnectionType.values().length];
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_ONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_MANY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

