/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.cache;

import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLog;
import com.intellij.platform.workspace.storage.impl.cache.ChangeOnVersionedChange;
import com.intellij.platform.workspace.storage.impl.cache.ChangeOnWorkspaceBuilderChangeLog;
import com.intellij.platform.workspace.storage.impl.cache.EntityStorageChange;
import com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCache;
import com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheImpl;
import com.intellij.platform.workspace.storage.impl.query.MatchList;
import com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0005H\u0000\u001a\u0012\u0010\n\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0000\u00a8\u0006\f"}, d2={"cache", "Lcom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCache;", "createTraces", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "Lcom/intellij/platform/workspace/storage/trace/ReadTraceHashSet;", "Lcom/intellij/platform/workspace/storage/impl/cache/EntityStorageChange;", "snapshot", "Lcom/intellij/platform/workspace/storage/instrumentation/ImmutableEntityStorageInstrumentation;", "makeTokensForDiff", "Lcom/intellij/platform/workspace/storage/impl/query/MatchList;", "collapse", "", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nTracedSnapshotCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracedSnapshotCache.kt\ncom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCacheKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1915#2,2:241\n*S KotlinDebug\n*F\n+ 1 TracedSnapshotCache.kt\ncom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCacheKt\n*L\n116#1:241,2\n*E\n"})
public final class TracedSnapshotCacheKt {
    @ApiStatus.Internal
    @NotNull
    public static final TracedSnapshotCache cache() {
        return new TracedSnapshotCacheImpl();
    }

    @NotNull
    public static final LongOpenHashSet createTraces(@NotNull EntityStorageChange $this$createTraces, @NotNull ImmutableEntityStorageInstrumentation snapshot) {
        LongOpenHashSet longOpenHashSet;
        Intrinsics.checkNotNullParameter((Object)$this$createTraces, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        EntityStorageChange entityStorageChange = $this$createTraces;
        if (entityStorageChange instanceof ChangeOnWorkspaceBuilderChangeLog) {
            longOpenHashSet = ((ChangeOnWorkspaceBuilderChangeLog)$this$createTraces).createTraces$intellij_platform_workspace_storage(snapshot);
        } else if (entityStorageChange instanceof ChangeOnVersionedChange) {
            longOpenHashSet = ((ChangeOnVersionedChange)$this$createTraces).createTraces$intellij_platform_workspace_storage(snapshot);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return longOpenHashSet;
    }

    @NotNull
    public static final MatchList makeTokensForDiff(@NotNull EntityStorageChange $this$makeTokensForDiff) {
        MatchList matchList;
        Intrinsics.checkNotNullParameter((Object)$this$makeTokensForDiff, (String)"<this>");
        EntityStorageChange entityStorageChange = $this$makeTokensForDiff;
        if (entityStorageChange instanceof ChangeOnWorkspaceBuilderChangeLog) {
            matchList = ((ChangeOnWorkspaceBuilderChangeLog)$this$makeTokensForDiff).makeTokensForDiff$intellij_platform_workspace_storage();
        } else if (entityStorageChange instanceof ChangeOnVersionedChange) {
            matchList = ((ChangeOnVersionedChange)$this$makeTokensForDiff).makeTokensForDiff$intellij_platform_workspace_storage();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return matchList;
    }

    @NotNull
    public static final EntityStorageChange collapse(@NotNull List<? extends EntityStorageChange> $this$collapse) {
        EntityStorageChange entityStorageChange;
        Intrinsics.checkNotNullParameter($this$collapse, (String)"<this>");
        if ($this$collapse.isEmpty()) {
            throw new IllegalStateException("Nothing to collapse".toString());
        }
        if ($this$collapse.size() == 1) {
            return $this$collapse.get(0);
        }
        EntityStorageChange firstChange = $this$collapse.get(0);
        EntityStorageChange entityStorageChange2 = firstChange;
        if (entityStorageChange2 instanceof ChangeOnWorkspaceBuilderChangeLog) {
            WorkspaceBuilderChangeLog targetChangelog = new WorkspaceBuilderChangeLog();
            HashMap targetMap = new HashMap();
            Iterable $this$forEach$iv = $this$collapse;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityStorageChange it = (EntityStorageChange)element$iv;
                boolean bl = false;
                if (!(it instanceof ChangeOnWorkspaceBuilderChangeLog)) {
                    throw new IllegalStateException("Check failed.");
                }
                ((ChangeOnWorkspaceBuilderChangeLog)it).addTo$intellij_platform_workspace_storage(targetChangelog, targetMap);
            }
            entityStorageChange = new ChangeOnWorkspaceBuilderChangeLog(targetChangelog, targetMap);
        } else if (entityStorageChange2 instanceof ChangeOnVersionedChange) {
            if ($this$collapse.size() > 1) {
                throw new IllegalStateException("We should not collect more than one changelog".toString());
            }
            entityStorageChange = firstChange;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        EntityStorageChange target = entityStorageChange;
        return target;
    }
}

