/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jdbc.inspection;

import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.spring.data.jdbc.SpringDataJdbcUtilsKt;
import com.intellij.spring.data.jdbc.inspection.fix.AddKeyColumnFix;
import com.intellij.spring.data.utils.SpringDataBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/data/jdbc/inspection/SpringDataJdbcMappedCollectionKeyColumnInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getProblemDescriptor", "uMember", "Lorg/jetbrains/uast/UDeclaration;", "getFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "annotationPsi", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringDataJdbcMappedCollectionKeyColumnInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataJdbcMappedCollectionKeyColumnInspection.kt\ncom/intellij/spring/data/jdbc/inspection/SpringDataJdbcMappedCollectionKeyColumnInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SUastUtils.kt\ncom/intellij/jpa/jpb/model/util/SUastUtils\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1#2:56\n93#3:57\n37#4,2:58\n1807#5,3:60\n*S KotlinDebug\n*F\n+ 1 SpringDataJdbcMappedCollectionKeyColumnInspection.kt\ncom/intellij/spring/data/jdbc/inspection/SpringDataJdbcMappedCollectionKeyColumnInspection\n*L\n25#1:57\n33#1:58,2\n38#1:60,3\n*E\n"})
public final class SpringDataJdbcMappedCollectionKeyColumnInspection
extends LocalInspectionTool {
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Module module = PsiUtilsKt.module((PsiFile)file);
        if (module != null) {
            Module it = module;
            int n = 0;
            bl = SpringDataJdbcUtilsKt.hasSpringDataJdbcSupport(it);
        } else {
            bl = false;
        }
        if (!bl) {
            return new ProblemDescriptor[0];
        }
        PsiClass[] psiClassArray = file instanceof PsiClassOwner ? (PsiClass[])file : null;
        if (psiClassArray == null || (psiClassArray = psiClassArray.getClasses()) == null) {
            return new ProblemDescriptor[0];
        }
        PsiClass[] classes = psiClassArray;
        List result = new ArrayList();
        for (PsiClass clazz : classes) {
            ProblemDescriptor it;
            UClass uClass;
            PsiElement $this$toUElementWithType$iv = (PsiElement)clazz;
            boolean $i$f$toUElementWithType = false;
            if ((UClass)UastContextKt.toUElement((PsiElement)$this$toUElementWithType$iv, UClass.class) == null) continue;
            for (UField uField : uClass.getFields()) {
                if (this.getProblemDescriptor((UDeclaration)uField, manager, isOnTheFly) == null) continue;
                boolean bl2 = false;
                result.add(it);
            }
            for (UField uField : uClass.getMethods()) {
                if (this.getProblemDescriptor((UDeclaration)uField, manager, isOnTheFly) == null) continue;
                boolean bl3 = false;
                result.add(it);
            }
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProblemDescriptor[0]);
    }

    private final ProblemDescriptor getProblemDescriptor(UDeclaration uMember, InspectionManager manager, boolean isOnTheFly) {
        String[] $i$f$any2;
        UMethod psiType;
        boolean bl;
        UAnnotation annotation;
        block10: {
            UAnnotation uAnnotation = uMember.findAnnotation("org.springframework.data.relational.core.mapping.MappedCollection");
            if (uAnnotation == null) {
                return null;
            }
            annotation = uAnnotation;
            Iterable $this$any$iv = annotation.getAttributeValues();
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UNamedExpression it = (UNamedExpression)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"keyColumn")) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        UMethod uMethod = uMember instanceof UMethod ? (UMethod)uMember : null;
        if (uMethod == null || (uMethod = uMethod.getReturnType()) == null) {
            UField uField = uMember instanceof UField ? (UField)uMember : null;
            if (uField != null) {
                uMethod = uField.getType();
            } else {
                return null;
            }
        }
        if (AnalysisUastUtilKt.isInheritorOf((PsiType)(psiType = uMethod), (String[])($i$f$any2 = new String[]{"java.util.List", "java.util.Map"}))) {
            PsiElement psiElement = annotation.getSourcePsi();
            if (psiElement == null) {
                return null;
            }
            PsiElement annotationPsi = psiElement;
            return manager.createProblemDescriptor(annotationPsi, SpringDataBundle.message("spring.data.jdbc.mapped.collection.key.column.inspection.description", new Object[0]), isOnTheFly, this.getFixes(annotationPsi), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return null;
    }

    private final LocalQuickFix[] getFixes(PsiElement annotationPsi) {
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new AddKeyColumnFix(annotationPsi)};
        return localQuickFixArray;
    }
}

