/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.logical;

import com.intellij.ide.structureView.logical.PropertyElementProvider;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.repository.RepositorySearch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/data/logical/SpringRepositoryEntityPropertyProvider;", "Lcom/intellij/ide/structureView/logical/PropertyElementProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "<init>", "()V", "propertyName", "", "getPropertyName", "()Ljava/lang/String;", "isApplicable", "", "parent", "getElements", "", "intellij.spring.data"})
public final class SpringRepositoryEntityPropertyProvider
implements PropertyElementProvider<SpringBeanLogicalModel, OrmEntity> {
    @NotNull
    private final String propertyName;

    public SpringRepositoryEntityPropertyProvider() {
        this.propertyName = "manages";
    }

    @NotNull
    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getSpringBean() instanceof SpringRepository || parent.getSpringBean() instanceof SpringRepositoryDefinition;
    }

    @NotNull
    public List<OrmEntity> getElements(@NotNull SpringBeanLogicalModel parent) {
        OrmEntity ormEntity;
        block8: {
            PsiClass psiClass;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            CommonSpringBean commonSpringBean = parent.getSpringBean();
            SpringStereotypeElement springStereotypeElement = commonSpringBean instanceof SpringStereotypeElement ? (SpringStereotypeElement)commonSpringBean : null;
            if (springStereotypeElement == null) {
                return CollectionsKt.emptyList();
            }
            SpringStereotypeElement repository = springStereotypeElement;
            PsiClass psiClass2 = repository.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"getPsiElement(...)");
            PsiClass repositoryClass = psiClass2;
            SpringStereotypeElement springStereotypeElement2 = repository;
            if (springStereotypeElement2 instanceof SpringRepository) {
                Project project = repositoryClass.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                psiClass = RepositorySearch.Companion.getInstance(project).getDomainClass(repositoryClass);
            } else if (springStereotypeElement2 instanceof SpringRepositoryDefinition) {
                psiClass = ((SpringRepositoryDefinition)repository).getDomainClass();
            } else {
                return CollectionsKt.emptyList();
            }
            PsiClass entityClass = psiClass;
            if (entityClass == null) {
                return CollectionsKt.emptyList();
            }
            Project project = repositoryClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            for (OrmSearcher it : (Iterable)OrmSearcher.Companion.getAllForProject(project)) {
                boolean bl = false;
                OrmEntity ormEntity2 = it.findEntityForClass(entityClass);
                if (ormEntity2 == null) continue;
                ormEntity = ormEntity2;
                break block8;
            }
            ormEntity = null;
        }
        if (ormEntity == null) {
            return CollectionsKt.emptyList();
        }
        OrmEntity ormEntity3 = ormEntity;
        return CollectionsKt.listOf(ormEntity3);
    }
}

