/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractValueUsageTransformer;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/UnitToVoidLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractValueUsageTransformer;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "useAsStatement", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "shouldVoidify", "", "expr", "Lorg/jetbrains/kotlin/ir/IrStatement;", "voidify", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nUnitToVoidLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitToVoidLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/UnitToVoidLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1924#2,3:152\n1924#2,3:155\n*S KotlinDebug\n*F\n+ 1 UnitToVoidLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/UnitToVoidLowering\n*L\n124#1:152,3\n132#1:155,3\n*E\n"})
public final class UnitToVoidLowering
extends AbstractValueUsageTransformer
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final WasmSymbols symbols;

    public UnitToVoidLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context.getIrBuiltIns(), false, 2, null);
        this.context = context;
        this.builtIns = this.context.getIrBuiltIns();
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final WasmSymbols getSymbols() {
        return this.symbols;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
    }

    @NotNull
    protected IrExpression useAsStatement(@NotNull IrExpression $this$useAsStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$useAsStatement, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$useAsStatement.getType(), (Object)this.builtIns.getUnitType())) {
            return $this$useAsStatement;
        }
        if (this.shouldVoidify((IrStatement)$this$useAsStatement)) {
            IrStatement irStatement = this.voidify((IrStatement)$this$useAsStatement);
            Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irStatement;
        }
        return $this$useAsStatement;
    }

    private final boolean shouldVoidify(IrStatement expr) {
        if (!(expr instanceof IrExpression)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)((IrExpression)expr).getType(), (Object)this.symbols.getVoidType()) || Intrinsics.areEqual((Object)((IrExpression)expr).getType(), (Object)this.builtIns.getNothingType())) {
            return false;
        }
        IrExpression irExpression = (IrExpression)expr;
        return irExpression instanceof IrContainerExpression ? !((Collection)((IrContainerExpression)expr).getStatements()).isEmpty() && this.shouldVoidify((IrStatement)CollectionsKt.last((List)((IrContainerExpression)expr).getStatements())) : (irExpression instanceof IrWhen || irExpression instanceof IrTry ? true : (irExpression instanceof IrTypeOperatorCall ? ((IrTypeOperatorCall)expr).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT : false));
    }

    /*
     * WARNING - void declaration
     */
    private final IrStatement voidify(IrStatement expr) {
        if (!(expr instanceof IrExpression)) {
            return expr;
        }
        if (Intrinsics.areEqual((Object)((IrExpression)expr).getType(), (Object)this.symbols.getVoidType()) || Intrinsics.areEqual((Object)((IrExpression)expr).getType(), (Object)this.builtIns.getNothingType())) {
            return expr;
        }
        IrExpression irExpression = (IrExpression)expr;
        if (irExpression instanceof IrContainerExpression) {
            ((IrContainerExpression)expr).setType(this.symbols.getVoidType());
            IrStatement irStatement = (IrStatement)CollectionsKt.lastOrNull((List)((IrContainerExpression)expr).getStatements());
            if (irStatement != null) {
                IrStatement last = irStatement;
                boolean bl = false;
                ((IrContainerExpression)expr).getStatements().set(CollectionsKt.getLastIndex((List)((IrContainerExpression)expr).getStatements()), this.voidify(last));
            }
            return expr;
        }
        if (irExpression instanceof IrWhen) {
            ((IrWhen)expr).setType(this.symbols.getVoidType());
            Iterable $this$forEachIndexed$iv = ((IrWhen)expr).getBranches();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void branch;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrBranch irBranch = (IrBranch)item$iv;
                int i = n;
                boolean bl = false;
                IrBranch irBranch2 = (IrBranch)((IrWhen)expr).getBranches().get(i);
                IrStatement irStatement = this.voidify((IrStatement)branch.getResult());
                Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                irBranch2.setResult((IrExpression)irStatement);
            }
            return expr;
        }
        if (irExpression instanceof IrTry) {
            ((IrTry)expr).setType(this.symbols.getVoidType());
            IrTry irTry = (IrTry)expr;
            IrStatement irStatement = this.voidify((IrStatement)((IrTry)expr).getTryResult());
            Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            irTry.setTryResult((IrExpression)irStatement);
            Iterable $this$forEachIndexed$iv = ((IrTry)expr).getCatches();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void catch_;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrCatch branch = (IrCatch)item$iv;
                int i = n;
                boolean bl = false;
                IrCatch irCatch = (IrCatch)((IrTry)expr).getCatches().get(i);
                IrStatement irStatement2 = this.voidify((IrStatement)catch_.getResult());
                Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                irCatch.setResult((IrExpression)irStatement2);
            }
            return expr;
        }
        if (irExpression instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)expr).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT) {
            return this.voidify((IrStatement)((IrTypeOperatorCall)expr).getArgument());
        }
        IrExpression $this$voidify_u24lambda_u243 = irExpression = BuildersKt.IrCallImpl$default((int)expr.getStartOffset(), (int)expr.getEndOffset(), (IrType)this.symbols.getVoidType(), (IrSimpleFunctionSymbol)this.symbols.findVoidConsumer(((IrExpression)expr).getType()), (int)0, null, null, (int)96, null);
        boolean bl = false;
        $this$voidify_u24lambda_u243.getArguments().set(0, (Object)expr);
        return (IrStatement)irExpression;
    }
}

