/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtVirtualFile;
import org.jetbrains.kotlin.cli.jvm.modules.JavaVersionUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0006H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0006\u0010\u0013\u001a\u00020\u000fR/\u0010\u0004\u001a#\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "<init>", "()V", "roots", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "getProtocol", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "refresh", "", "asynchronous", "", "refreshAndFindFileByPath", "clearRoots", "Companion", "cli-base"})
public final class CoreJrtFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, CoreJrtVirtualFile> roots;
    @NotNull
    private static final ConcurrentMap<String, FileSystem> globalJrtFsCache;

    public CoreJrtFileSystem() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> CoreJrtFileSystem.roots$lambda$1(arg_0 -> CoreJrtFileSystem.roots$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.roots = concurrentMap;
    }

    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pair<String, String> pair = Companion.splitPath(path);
        String jdkHomePath = (String)pair.component1();
        String pathInImage = (String)pair.component2();
        CoreJrtVirtualFile coreJrtVirtualFile = (CoreJrtVirtualFile)((Object)this.roots.get(jdkHomePath));
        if (coreJrtVirtualFile == null) {
            return null;
        }
        CoreJrtVirtualFile root = coreJrtVirtualFile;
        if (((CharSequence)pathInImage).length() == 0) {
            return root;
        }
        return root.findFileByRelativePath(pathInImage);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    public final void clearRoots() {
        this.roots.clear();
    }

    private static final CoreJrtVirtualFile roots$lambda$0(CoreJrtFileSystem this$0, String jdkHomePath) {
        FileSystem fileSystem = (FileSystem)globalJrtFsCache.get(jdkHomePath);
        if (fileSystem == null) {
            return null;
        }
        FileSystem fileSystem2 = fileSystem;
        Intrinsics.checkNotNull((Object)jdkHomePath);
        Path path = fileSystem2.getPath("", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new CoreJrtVirtualFile(this$0, jdkHomePath, path, null);
    }

    private static final CoreJrtVirtualFile roots$lambda$1(Function1 $tmp0, Object p0) {
        return (CoreJrtVirtualFile)((Object)$tmp0.invoke(p0));
    }

    private static final FileSystem globalJrtFsCache$lambda$0(String jdkHomePath) {
        FileSystem fileSystem;
        File jdkHome = new File(jdkHomePath);
        File file = CoreJrtFileSystem.Companion.loadJrtFsJar(jdkHome);
        if (file == null) {
            return null;
        }
        File jrtFsJar = file;
        URI rootUri = URI.create("jrt:/");
        if (JavaVersionUtilsKt.isAtLeastJava9()) {
            fileSystem = FileSystems.newFileSystem(rootUri, MapsKt.mapOf((Pair)TuplesKt.to((Object)"java.home", (Object)jdkHome.getAbsolutePath())));
        } else {
            URL[] uRLArray = new URL[]{jrtFsJar.toURI().toURL()};
            URLClassLoader classLoader = new URLClassLoader(uRLArray, null);
            fileSystem = FileSystems.newFileSystem(rootUri, MapsKt.emptyMap(), (ClassLoader)classLoader);
        }
        return fileSystem;
    }

    private static final FileSystem globalJrtFsCache$lambda$1(Function1 $tmp0, Object p0) {
        return (FileSystem)$tmp0.invoke(p0);
    }

    static {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> CoreJrtFileSystem.globalJrtFsCache$lambda$1(CoreJrtFileSystem::globalJrtFsCache$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        globalJrtFsCache = concurrentMap;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bR/\u0010\r\u001a#\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion;", "", "<init>", "()V", "loadJrtFsJar", "Ljava/io/File;", "jdkHome", "isModularJdk", "", "splitPath", "Lkotlin/Pair;", "", "path", "globalJrtFsCache", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Ljava/nio/file/FileSystem;", "Lorg/jetbrains/annotations/NotNull;", "cli-base"})
    @SourceDebugExtension(value={"SMAP\nCoreJrtFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreJrtFileSystem.kt\norg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final File loadJrtFsJar(File jdkHome) {
            File file;
            File p0 = file = new File(jdkHome, "lib/jrt-fs.jar");
            boolean bl = false;
            return p0.exists() ? file : null;
        }

        public final boolean isModularJdk(@NotNull File jdkHome) {
            Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
            return this.loadJrtFsJar(jdkHome) != null;
        }

        @NotNull
        public final Pair<String, String> splitPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            int separator = StringsKt.indexOf$default((CharSequence)path, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (separator < 0) {
                throw new IllegalArgumentException("Path in CoreJrtFileSystem must contain a separator: " + path);
            }
            String string = path.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String localPath = string;
            String string2 = path.substring(separator + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String pathInJar = string2;
            return new Pair((Object)localPath, (Object)pathInJar);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

