/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrFunctionToJsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "<init>", "()V", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "context", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrFunctionToJsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFunctionToJsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrFunctionToJsTransformer\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,45:1\n245#2:46\n245#2:47\n*S KotlinDebug\n*F\n+ 1 IrFunctionToJsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrFunctionToJsTransformer\n*L\n23#1:46\n26#1:47\n*E\n"})
public final class IrFunctionToJsTransformer
extends BaseIrElementToJsNodeTransformer<JsFunction, JsGenerationContext> {
    @NotNull
    public JsFunction visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull JsGenerationContext context) {
        JsName jsName;
        JsExpression jsExpression;
        IrClass parentClass;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        IrClass irClass = parentClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        boolean isInterfaceDefaultImpl = irClass != null ? IrUtilsKt.isInterface((IrClass)irClass) : false;
        boolean condition$iv = !isInterfaceDefaultImpl;
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            String string = AnnotationUtilsKt.getJsSymbolForOverriddenDeclaration((IrDeclarationWithName)declaration);
            jsExpression = string != null ? JsAstUtilsKt.toWellKnownSymbolAccess(string) : null;
        } else {
            jsExpression = null;
        }
        JsExpression symbolKey = jsExpression;
        boolean condition$iv2 = symbolKey == null;
        boolean $i$f$runIf2 = false;
        if (condition$iv2) {
            boolean bl = false;
            jsName = declaration.getDispatchReceiverParameter() == null || isInterfaceDefaultImpl ? (declaration.getParent() instanceof IrFunction ? context.getNameForValueDeclaration((IrDeclarationWithName)declaration) : context.getNameForStaticFunction(declaration)) : context.getNameForMemberFunction(declaration);
        } else {
            jsName = null;
        }
        JsName funcName = jsName;
        return JsAstUtilsKt.translateFunction((IrFunction)declaration, funcName, symbolKey, context);
    }

    @NotNull
    public JsFunction visitConstructor(@NotNull IrConstructor declaration, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl = declaration.isPrimary();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        JsName funcName = context.getNameForConstructor(declaration);
        return JsAstUtilsKt.translateFunction((IrFunction)declaration, funcName, null, context);
    }
}

