/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.common;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\u0012\u001a\u00020\u0001\u001a&\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u0015\u00a2\u0006\u0002\b\u0016H\u0082\b\"\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0015\u0010\u0017\u001a\u00020\t*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"isAllowedLatinLetterOrSpecial", "", "", "isAllowedSimpleDigit", "isNotAllowedSimpleCharacter", "isES5IdentifierStart", "isES5IdentifierStartFull", "isES5IdentifierPart", "isValidES5Identifier", "", "SPECIAL_KEYWORDS", "", "getSPECIAL_KEYWORDS", "()Ljava/util/Set;", "RESERVED_KEYWORDS", "getRESERVED_KEYWORDS", "makeValidES5Identifier", "name", "withHash", "mangleIfNot", "predicate", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "safeModuleName", "getSafeModuleName", "(Ljava/lang/String;)Ljava/lang/String;", "js.ast"})
@SourceDebugExtension(value={"SMAP\nIdentifierPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentifierPolicy.kt\norg/jetbrains/kotlin/js/common/IdentifierPolicyKt\n*L\n1#1,111:1\n100#1:112\n100#1:113\n*S KotlinDebug\n*F\n+ 1 IdentifierPolicy.kt\norg/jetbrains/kotlin/js/common/IdentifierPolicyKt\n*L\n85#1:112\n89#1:113\n*E\n"})
public final class IdentifierPolicyKt {
    @NotNull
    private static final Set<String> SPECIAL_KEYWORDS = SetsKt.setOf((Object)"default");
    @NotNull
    private static final Set<String> RESERVED_KEYWORDS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAllowedLatinLetterOrSpecial(char $this$isAllowedLatinLetterOrSpecial) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isAllowedLatinLetterOrSpecial) {
            if ($this$isAllowedLatinLetterOrSpecial < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isAllowedLatinLetterOrSpecial) {
            if ($this$isAllowedLatinLetterOrSpecial < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ($this$isAllowedLatinLetterOrSpecial == '_') return true;
        if ($this$isAllowedLatinLetterOrSpecial != '$') return false;
        return true;
    }

    private static final boolean isAllowedSimpleDigit(char $this$isAllowedSimpleDigit) {
        return '0' <= $this$isAllowedSimpleDigit ? $this$isAllowedSimpleDigit < ':' : false;
    }

    private static final boolean isNotAllowedSimpleCharacter(char $this$isNotAllowedSimpleCharacter) {
        boolean bl;
        switch ($this$isNotAllowedSimpleCharacter) {
            case ' ': 
            case '-': 
            case '<': 
            case '>': 
            case '?': {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isES5IdentifierStart(char $this$isES5IdentifierStart) {
        if (IdentifierPolicyKt.isAllowedLatinLetterOrSpecial($this$isES5IdentifierStart)) {
            return true;
        }
        if (IdentifierPolicyKt.isNotAllowedSimpleCharacter($this$isES5IdentifierStart)) {
            return false;
        }
        return IdentifierPolicyKt.isES5IdentifierStartFull($this$isES5IdentifierStart);
    }

    private static final boolean isES5IdentifierStartFull(char $this$isES5IdentifierStartFull) {
        return Character.isLetter($this$isES5IdentifierStartFull) || (byte)Character.getType($this$isES5IdentifierStartFull) == 10;
    }

    public static final boolean isES5IdentifierPart(char $this$isES5IdentifierPart) {
        byte by;
        if (IdentifierPolicyKt.isAllowedLatinLetterOrSpecial($this$isES5IdentifierPart)) {
            return true;
        }
        if (IdentifierPolicyKt.isAllowedSimpleDigit($this$isES5IdentifierPart)) {
            return true;
        }
        if (IdentifierPolicyKt.isNotAllowedSimpleCharacter($this$isES5IdentifierPart)) {
            return false;
        }
        return IdentifierPolicyKt.isES5IdentifierStartFull($this$isES5IdentifierPart) || (by = (byte)Character.getType($this$isES5IdentifierPart)) == 6 || by == 8 || by == 9 || by == 23 || $this$isES5IdentifierPart == '\u200c' || $this$isES5IdentifierPart == '\u200d';
    }

    public static final boolean isValidES5Identifier(@NotNull String $this$isValidES5Identifier) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidES5Identifier, (String)"<this>");
        if (((CharSequence)$this$isValidES5Identifier).length() == 0 || !IdentifierPolicyKt.isES5IdentifierStart($this$isValidES5Identifier.charAt(0))) {
            return false;
        }
        int n = $this$isValidES5Identifier.length();
        for (int idx = 1; idx < n; ++idx) {
            if (IdentifierPolicyKt.isES5IdentifierPart($this$isValidES5Identifier.charAt(idx))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final Set<String> getSPECIAL_KEYWORDS() {
        return SPECIAL_KEYWORDS;
    }

    @NotNull
    public static final Set<String> getRESERVED_KEYWORDS() {
        return RESERVED_KEYWORDS;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String makeValidES5Identifier(@NotNull String name, boolean withHash) {
        String string;
        void p0;
        char first;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (IdentifierPolicyKt.isValidES5Identifier(name)) {
            return name;
        }
        if (((CharSequence)name).length() == 0) {
            return "_";
        }
        StringBuilder builder = new StringBuilder(name.length() + (withHash ? 7 : 0));
        char $this$mangleIfNot$iv = first = StringsKt.first((CharSequence)name);
        boolean $i$f$mangleIfNot = false;
        char c = $this$mangleIfNot$iv;
        StringBuilder stringBuilder = builder;
        boolean bl = false;
        boolean bl2 = IdentifierPolicyKt.isES5IdentifierStart((char)p0);
        stringBuilder.append(bl2 ? $this$mangleIfNot$iv : (char)'_');
        int idx = 1;
        int n = StringsKt.getLastIndex((CharSequence)name);
        if (idx <= n) {
            while (true) {
                void p02;
                char c2;
                char $this$mangleIfNot$iv2 = c2 = name.charAt(idx);
                boolean $i$f$mangleIfNot2 = false;
                char c3 = $this$mangleIfNot$iv2;
                stringBuilder = builder;
                boolean bl3 = false;
                bl2 = IdentifierPolicyKt.isES5IdentifierPart((char)p02);
                stringBuilder.append(bl2 ? $this$mangleIfNot$iv2 : (char)'_');
                if (idx == n) break;
                ++idx;
            }
        }
        if (withHash) {
            StringBuilder stringBuilder2 = new StringBuilder().append((Object)builder).append('_');
            String string2 = Integer.toString(Math.abs(name.hashCode()), CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = stringBuilder2.append(string2).toString();
        } else {
            String string3 = builder.toString();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    public static /* synthetic */ String makeValidES5Identifier$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return IdentifierPolicyKt.makeValidES5Identifier(string, bl);
    }

    private static final char mangleIfNot(char $this$mangleIfNot, Function1<? super Character, Boolean> predicate) {
        boolean $i$f$mangleIfNot = false;
        return (Boolean)predicate.invoke((Object)Character.valueOf($this$mangleIfNot)) != false ? $this$mangleIfNot : (char)'_';
    }

    @NotNull
    public static final String getSafeModuleName(@NotNull String $this$safeModuleName) {
        Intrinsics.checkNotNullParameter((Object)$this$safeModuleName, (String)"<this>");
        String result = $this$safeModuleName;
        if (StringsKt.startsWith$default((CharSequence)result, (char)'<', (boolean)false, (int)2, null)) {
            String string = result.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result = string;
        }
        if (StringsKt.endsWith$default((CharSequence)result, (char)'>', (boolean)false, (int)2, null)) {
            String string = result.substring(0, result.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result = string;
        }
        return IdentifierPolicyKt.makeValidES5Identifier("kotlin_" + result, false);
    }

    static {
        Object[] objectArray = new String[]{"await", "break", "case", "catch", "continue", "debugger", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "null", "true", "false", "eval", "arguments"};
        RESERVED_KEYWORDS = SetsKt.plus(SPECIAL_KEYWORDS, (Iterable)SetsKt.setOf((Object[])objectArray));
    }
}

