/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.antlr;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.parser.ErrorReporter;
import org.jetbrains.kotlin.js.parser.JsParserException;
import org.jetbrains.kotlin.js.parser.ScopeContext;
import org.jetbrains.kotlin.js.parser.antlr.JsAstExtensionsKt;
import org.jetbrains.kotlin.js.parser.antlr.JsAstMapperVisitor;
import org.jetbrains.kotlin.js.parser.antlr.generated.JavaScriptParser;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/js/parser/antlr/JsAstMapper;", "", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "fileName", "", "reporter", "Lorg/jetbrains/kotlin/js/parser/ErrorReporter;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsScope;Ljava/lang/String;Lorg/jetbrains/kotlin/js/parser/ErrorReporter;)V", "scopeContext", "Lorg/jetbrains/kotlin/js/parser/ScopeContext;", "mapStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "statement", "Lorg/jetbrains/kotlin/js/parser/antlr/generated/JavaScriptParser$StatementContext;", "mapFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "function", "Lorg/jetbrains/kotlin/js/parser/antlr/generated/JavaScriptParser$FunctionDeclarationContext;", "mapExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/antlr/v4/runtime/ParserRuleContext;", "map", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "Companion", "js.parser"})
public final class JsAstMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileName;
    @NotNull
    private final ErrorReporter reporter;
    @NotNull
    private final ScopeContext scopeContext;

    public JsAstMapper(@NotNull JsScope scope, @NotNull String fileName, @NotNull ErrorReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.fileName = fileName;
        this.reporter = reporter;
        this.scopeContext = new ScopeContext(scope);
    }

    @NotNull
    public final JsStatement mapStatement(@NotNull JavaScriptParser.StatementContext statement) {
        Intrinsics.checkNotNullParameter((Object)((Object)statement), (String)"statement");
        JsNode jsStatement = this.map(statement);
        if (!(jsStatement instanceof JsStatement)) {
            JsAstMapper.Companion.raiseParserException("Expecting a statement", statement);
            throw new KotlinNothingValueException();
        }
        return (JsStatement)jsStatement;
    }

    @NotNull
    public final JsFunction mapFunction(@NotNull JavaScriptParser.FunctionDeclarationContext function2) {
        Intrinsics.checkNotNullParameter((Object)((Object)function2), (String)"function");
        JsNode jsFunction = this.map(function2);
        if (!(jsFunction instanceof JsFunction)) {
            JsAstMapper.Companion.raiseParserException("Expecting a function", function2);
            throw new KotlinNothingValueException();
        }
        return (JsFunction)jsFunction;
    }

    @NotNull
    public final JsExpression mapExpression(@NotNull ParserRuleContext expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JsNode jsExpression = this.map(expression2);
        if (!(jsExpression instanceof JsExpression)) {
            JsAstMapper.Companion.raiseParserException("Expecting an expression", expression2);
            throw new KotlinNothingValueException();
        }
        return (JsExpression)jsExpression;
    }

    private final JsNode map(ParserRuleContext node) {
        JsAstMapperVisitor visitor2 = new JsAstMapperVisitor(this.fileName, this.scopeContext, this.reporter);
        JsNode jsNode = (JsNode)node.accept((ParseTreeVisitor)visitor2);
        if (jsNode == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Mapping for node '");
            String string = Reflection.getOrCreateKotlinClass(node.getClass()).getSimpleName();
            if (string == null) {
                string = "anonymous";
            }
            String string2 = stringBuilder.append(string).append("' failed: non-nullable JS AST node expected, got null").toString();
            throw new IllegalStateException(string2.toString());
        }
        return jsNode;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/parser/antlr/JsAstMapper$Companion;", "", "<init>", "()V", "raiseParserException", "", "message", "", "ctx", "Lorg/antlr/v4/runtime/ParserRuleContext;", "js.parser"})
    public static final class Companion {
        private Companion() {
        }

        private final Void raiseParserException(String message, ParserRuleContext ctx) {
            throw new JsParserException("Parser encountered internal error: " + message, JsAstExtensionsKt.getStartPosition(ctx));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

