/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.stream.ChunkedStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.liveReload.WebServerPageConnectionService;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.FileResponsesKt;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/builtInWebServer/StaticFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "<init>", "()V", "pageFileExtensions", "", "", "getPageFileExtensions", "()Ljava/util/List;", "ssiProcessor", "Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "processSsi", "", "file", "Ljava/nio/file/Path;", "path", "intellij.platform.builtInServer.impl"})
public final class StaticFileHandler
extends WebServerFileHandler {
    @NotNull
    private final List<String> pageFileExtensions;
    @Nullable
    private SsiProcessor ssiProcessor;

    public StaticFileHandler() {
        Object[] objectArray = new String[]{"html", "htm", "shtml", "stm", "shtm"};
        this.pageFileExtensions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getPageFileExtensions() {
        return this.pageFileExtensions;
    }

    @Override
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        block12: {
            byte[] byArray;
            String extraSuffix;
            Path ioFile;
            String nameSequence;
            Path path;
            block11: {
                Intrinsics.checkNotNullParameter((Object)pathInfo, (String)"pathInfo");
                Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
                if (pathInfo.getIoFile() != null) break block11;
                VirtualFile virtualFile = pathInfo.getFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                if (!virtualFile.isInLocalFileSystem()) break block12;
            }
            if ((path = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                Path path2 = virtualFile.toNioPath();
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
            }
            if (StringsKt.endsWith((String)(nameSequence = ((Object)(ioFile = path).getFileName()).toString()), (String)".shtml", (boolean)true) || StringsKt.endsWith((String)nameSequence, (String)".stm", (boolean)true) || StringsKt.endsWith((String)nameSequence, (String)".shtm", (boolean)true)) {
                String string = PathUtilRt.getParentPath((String)((Object)canonicalPath).toString());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
                this.processSsi(ioFile, string, project, request, channel, extraHeaders);
                return true;
            }
            String string = extraSuffix = WebServerPageConnectionService.Companion.getInstance().fileRequested(request, true, () -> ((PathInfo)pathInfo).getOrResolveVirtualFile());
            if (string != null) {
                String string2 = string;
                Object object = pathInfo.getFile();
                if (object == null || (object = object.getCharset()) == null) {
                    object = Charsets.UTF_8;
                }
                byte[] byArray2 = string2.getBytes((Charset)object);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            } else {
                byArray = null;
            }
            byte[] extraBuffer = byArray;
            FileResponses.INSTANCE.sendFile((HttpRequest)request, channel, ioFile, extraHeaders, extraBuffer);
            return true;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile file = virtualFile;
        HttpRequest httpRequest = (HttpRequest)request;
        long l = file.getTimeStamp();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        HttpResponse httpResponse = FileResponses.INSTANCE.prepareSend(httpRequest, channel, l, string, extraHeaders);
        if (httpResponse == null) {
            return true;
        }
        HttpResponse response = httpResponse;
        boolean isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)((HttpRequest)request));
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD)) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file.getLength());
        }
        channel.write((Object)response);
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD)) {
            channel.write((Object)new ChunkedStream(file.getInputStream()));
        }
        FileResponsesKt.flushChunkedResponse((Channel)channel, (boolean)isKeepAlive);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processSsi(Path file, String path, Project project, FullHttpRequest request, Channel channel, HttpHeaders extraHeaders) {
        boolean releaseBuffer;
        boolean isKeepAlive;
        ByteBuf buffer;
        block8: {
            if (this.ssiProcessor == null) {
                this.ssiProcessor = new SsiProcessor();
            }
            buffer = channel.alloc().ioBuffer();
            isKeepAlive = false;
            releaseBuffer = true;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            Intrinsics.checkNotNull((Object)ssiProcessor);
            HttpRequest httpRequest = (HttpRequest)request;
            Path path2 = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            SsiExternalResolver ssiExternalResolver = new SsiExternalResolver(project, httpRequest, path, path2);
            Intrinsics.checkNotNull((Object)buffer);
            long lastModified = ssiProcessor.process(ssiExternalResolver, file, new ByteBufUtf8Writer(buffer));
            if (FileResponses.INSTANCE.prepareSend((HttpRequest)request, channel, lastModified, ((Object)file.getFileName()).toString(), extraHeaders) != null) break block8;
            buffer.release();
            return;
        }
        try {
            HttpResponse httpResponse;
            HttpResponse response = httpResponse;
            isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)((HttpRequest)request));
            if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD)) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD)) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        FileResponsesKt.flushChunkedResponse((Channel)channel, (boolean)isKeepAlive);
    }
}

