/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.SuitableRoot;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\b2\b\b\u0002\u0010\u001c\u001a\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J&\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\b2\b\b\u0002\u0010\u001c\u001a\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u0011J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020\u0011J\u001f\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u0018\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\t0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u0018\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\t0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR$\u0010\u0010\u001a\u0018\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\t\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0012\u001a\u001e\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\b\t0\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006("}, d2={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "pathToInfoCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/builtInWebServer/PathInfo;", "getPathToInfoCache$intellij_platform_builtInServer_impl", "()Lcom/github/benmanes/caffeine/cache/Cache;", "pathToExistShortTermCache", "", "getPathToExistShortTermCache$intellij_platform_builtInServer_impl", "virtualFileToPathInfo", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentToSuitableRoot", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lorg/jetbrains/builtInWebServer/SuitableRoot;", "getParentToSuitableRoot$intellij_platform_builtInServer_impl", "()Lcom/github/benmanes/caffeine/cache/LoadingCache;", "clearCache", "", "findVirtualFile", "path", "cacheResult", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "getPathInfo", "getPath", "file", "child", "doFindByRelativePath", "doFindByRelativePath$intellij_platform_builtInServer_impl", "getResolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "Companion", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nWebServerPathToFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebServerPathToFileManager.kt\norg/jetbrains/builtInWebServer/WebServerPathToFileManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
public final class WebServerPathToFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Cache<String, PathInfo> pathToInfoCache;
    @NotNull
    private final Cache<String, Boolean> pathToExistShortTermCache;
    @NotNull
    private final Cache<VirtualFile, PathInfo> virtualFileToPathInfo;
    @NotNull
    private final LoadingCache<String, List<SuitableRoot>> parentToSuitableRoot;

    public WebServerPathToFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Cache cache = Caffeine.newBuilder().maximumSize(16384L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.pathToInfoCache = cache;
        Cache cache2 = Caffeine.newBuilder().maximumSize(16384L).expireAfterAccess(5L, TimeUnit.SECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.pathToExistShortTermCache = cache2;
        Cache cache3 = Caffeine.newBuilder().maximumSize(16384L).expireAfterAccess(11L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"build(...)");
        this.virtualFileToPathInfo = cache3;
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize(16384L).expireAfterAccess(10L, TimeUnit.MINUTES).build(arg_0 -> WebServerPathToFileManager.parentToSuitableRoot$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.parentToSuitableRoot = loadingCache;
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.project);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                block0: for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        Intrinsics.checkNotNullExpressionValue((Object)((VFileContentChangeEvent)vFileEvent).getFile(), (String)"getFile(...)");
                        for (WebServerRootsProvider rootsProvider : WebServerRootsProvider.Companion.getEP_NAME().getExtensionList()) {
                            VirtualFile file;
                            if (!rootsProvider.isClearCacheOnFileContentChanged(file)) continue;
                            this.clearCache();
                            continue block0;
                        }
                        continue;
                    }
                    this.clearCache();
                    break;
                }
            }
        });
        MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect();
        Topic topic2 = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.clearCache();
            }
        });
        MessageBusConnection messageBusConnection3 = this.project.getMessageBus().connect();
        Topic topic3 = AdditionalLibraryRootsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        messageBusConnection3.subscribe(topic3, (arg_0, arg_1, arg_2, arg_3) -> WebServerPathToFileManager._init_$lambda$0(this, arg_0, arg_1, arg_2, arg_3));
    }

    @NotNull
    public final Cache<String, PathInfo> getPathToInfoCache$intellij_platform_builtInServer_impl() {
        return this.pathToInfoCache;
    }

    @NotNull
    public final Cache<String, Boolean> getPathToExistShortTermCache$intellij_platform_builtInServer_impl() {
        return this.pathToExistShortTermCache;
    }

    @NotNull
    public final LoadingCache<String, List<SuitableRoot>> getParentToSuitableRoot$intellij_platform_builtInServer_impl() {
        return this.parentToSuitableRoot;
    }

    private final void clearCache() {
        this.pathToInfoCache.invalidateAll();
        this.virtualFileToPathInfo.invalidateAll();
        this.pathToExistShortTermCache.invalidateAll();
        this.parentToSuitableRoot.invalidateAll();
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path, boolean cacheResult, @NotNull PathQuery pathQuery) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
        PathInfo pathInfo = this.getPathInfo(path, cacheResult, pathQuery);
        return pathInfo != null ? pathInfo.getOrResolveVirtualFile() : null;
    }

    public static /* synthetic */ VirtualFile findVirtualFile$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, PathQuery pathQuery, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            pathQuery = WebServerPathToFileManagerKt.getDefaultPathQuery();
        }
        return webServerPathToFileManager.findVirtualFile(string, bl, pathQuery);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path, boolean cacheResult, @NotNull PathQuery pathQuery) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
        PathInfo pathInfo = (PathInfo)this.pathToInfoCache.getIfPresent((Object)path);
        if (pathInfo == null || !pathInfo.isValid()) {
            if (Intrinsics.areEqual((Object)this.pathToExistShortTermCache.getIfPresent((Object)path), (Object)false)) {
                return null;
            }
            pathInfo = this.doFindByRelativePath$intellij_platform_builtInServer_impl(path, pathQuery);
            if (cacheResult) {
                if (pathInfo != null && pathInfo.isValid()) {
                    this.pathToInfoCache.put((Object)path, (Object)pathInfo);
                } else {
                    this.pathToExistShortTermCache.put((Object)path, (Object)false);
                }
            }
        }
        return pathInfo;
    }

    public static /* synthetic */ PathInfo getPathInfo$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, PathQuery pathQuery, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            pathQuery = WebServerPathToFileManagerKt.getDefaultPathQuery();
        }
        return webServerPathToFileManager.getPathInfo(string, bl, pathQuery);
    }

    @Nullable
    public final String getPath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PathInfo pathInfo = this.getPathInfo(file);
        return pathInfo != null ? pathInfo.getPath() : null;
    }

    @Nullable
    public final PathInfo getPathInfo(@NotNull VirtualFile child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        PathInfo result = (PathInfo)this.virtualFileToPathInfo.getIfPresent((Object)child);
        if (result == null) {
            Object v0;
            block3: {
                Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)WebServerRootsProvider.Companion.getEP_NAME().getExtensionList()), arg_0 -> WebServerPathToFileManager.getPathInfo$lambda$0(child, this, arg_0));
                for (Object e : sequence) {
                    PathInfo it = (PathInfo)e;
                    boolean bl = false;
                    if (!(it != null)) continue;
                    v0 = e;
                    break block3;
                }
                v0 = null;
            }
            result = v0;
            if (result != null) {
                this.virtualFileToPathInfo.put((Object)child, (Object)result);
            }
        }
        return result;
    }

    @Nullable
    public final PathInfo doFindByRelativePath$intellij_platform_builtInServer_impl(@NotNull String path, @NotNull PathQuery pathQuery) {
        PathInfo result;
        block3: {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
                Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)WebServerRootsProvider.Companion.getEP_NAME().getExtensionList()), arg_0 -> WebServerPathToFileManager.doFindByRelativePath$lambda$0(path, this, pathQuery, arg_0));
                for (Object e : sequence) {
                    PathInfo it = (PathInfo)e;
                    boolean bl = false;
                    if (!(it != null)) continue;
                    v0 = e;
                    break block2;
                }
                v0 = null;
            }
            PathInfo pathInfo = v0;
            if (pathInfo == null) {
                return null;
            }
            result = pathInfo;
            VirtualFile virtualFile = result.getFile();
            if (virtualFile == null) break block3;
            VirtualFile it = virtualFile;
            boolean bl = false;
            this.virtualFileToPathInfo.put((Object)it, (Object)result);
        }
        return result;
    }

    @NotNull
    public final FileResolver getResolver(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ((CharSequence)path).length() == 0 ? (FileResolver)WebServerPathToFileManagerKt.access$getEMPTY_PATH_RESOLVER$p() : (FileResolver)WebServerPathToFileManagerKt.access$getRELATIVE_PATH_RESOLVER$p();
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path, boolean cacheResult) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return WebServerPathToFileManager.findVirtualFile$default(this, path, cacheResult, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return WebServerPathToFileManager.findVirtualFile$default(this, path, false, null, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path, boolean cacheResult) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return WebServerPathToFileManager.getPathInfo$default(this, path, cacheResult, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return WebServerPathToFileManager.getPathInfo$default(this, path, false, null, 6, null);
    }

    private static final Module[] parentToSuitableRoot$lambda$0$0(WebServerPathToFileManager this$0) {
        return ModuleManager.Companion.getInstance(this$0.project).getModules();
    }

    private static final List parentToSuitableRoot$lambda$0(WebServerPathToFileManager this$0, String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        SmartList suitableRoots = new SmartList();
        String moduleQualifier = null;
        Module[] modules = (Module[])ActionsKt.runReadAction(() -> WebServerPathToFileManager.parentToSuitableRoot$lambda$0$0(this$0));
        for (RootProvider rootProvider : RootProvider.getEntries()) {
            for (Module module : modules) {
                if (module.isDisposed()) continue;
                for (VirtualFile root : rootProvider.getRoots(ProjectUtil.getRootManager((Module)module))) {
                    if (root.findChild(path) == null) continue;
                    if (moduleQualifier == null) {
                        moduleQualifier = DefaultWebServerRootsProviderKt.getModuleNameQualifier(this$0.project, module);
                    }
                    suitableRoots.add((Object)new SuitableRoot(root, moduleQualifier));
                }
            }
        }
        return (List)suitableRoots;
    }

    private static final void _init_$lambda$0(WebServerPathToFileManager this$0, String string, Collection collection, Collection collection2, String string2) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)collection2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
        this$0.clearCache();
    }

    private static final PathInfo getPathInfo$lambda$0(VirtualFile $child, WebServerPathToFileManager this$0, WebServerRootsProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPathInfo($child, this$0.project);
    }

    private static final PathInfo doFindByRelativePath$lambda$0(String $path, WebServerPathToFileManager this$0, PathQuery $pathQuery, WebServerRootsProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.resolve($path, this$0.project, $pathQuery);
    }

    @JvmStatic
    @NotNull
    public static final WebServerPathToFileManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.builtInServer.impl"})
    @SourceDebugExtension(value={"SMAP\nWebServerPathToFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebServerPathToFileManager.kt\norg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,193:1\n30#2,2:194\n*S KotlinDebug\n*F\n+ 1 WebServerPathToFileManager.kt\norg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion\n*L\n101#1:194,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WebServerPathToFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WebServerPathToFileManager> serviceClass$iv = WebServerPathToFileManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WebServerPathToFileManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

