/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AppIcon;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.NettyKt;
import com.intellij.xml.util.XmlStringUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerAuth;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestServiceKt;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b&\u0018\u0000 :2\u00020\u0001:\u0001:B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u0012H%J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0014J \u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0016J4\u0010*\u001a\u00020+*\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001e\u001a\u00020/2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u00101\u001a\u0004\u0018\u000102H\u0002J\u0018\u00103\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0014J \u00104\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u00103\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0015J$\u00105\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020/2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0012072\u0006\u00108\u001a\u00020\u0012J\"\u00109\u001a\u0004\u0018\u00010\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H&R\u001b\u0010\u0004\u001a\u00020\u00058DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u0018\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u000f\u001a$\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0014\u001a'\u0012\u000e\u0012\f0\u0012\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\r\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\r0\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006;"}, d2={"Lorg/jetbrains/ide/RestService;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "abuseCounter", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/util/concurrent/atomic/AtomicInteger;", "trustedOrigins", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lkotlin/Pair;", "", "", "hostLocks", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/annotations/NotNull;", "isBlockUnknownHosts", "isPrefixlessAllowed", "()Z", "reportErrorsAsPlainText", "getReportErrorsAsPlainText", "getServiceName", "isSupported", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "isMethodSupported", "method", "Lio/netty/handler/codec/http/HttpMethod;", "getMaxRequestsPerMinute", "", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "sendError", "", "Lio/netty/handler/codec/http/HttpResponseStatus;", "channel", "Lio/netty/channel/Channel;", "Lio/netty/handler/codec/http/HttpRequest;", "description", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "isHostTrusted", "getRequesterId", "isHostInPredefinedHosts", "trustedPredefinedHosts", "", "systemPropertyKey", "execute", "Companion", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nRestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestService.kt\norg/jetbrains/ide/RestService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,382:1\n42#2,3:383\n1#3:386\n13#4:387\n*S KotlinDebug\n*F\n+ 1 RestService.kt\norg/jetbrains/ide/RestService\n*L\n281#1:383,3\n74#1:387\n*E\n"})
public abstract class RestService
extends HttpRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy gson$delegate = LazyKt.lazy(RestService::gson_delegate$lambda$0);
    @NotNull
    private final LoadingCache<Object, AtomicInteger> abuseCounter;
    @NotNull
    private final Cache<Pair<String, String>, Boolean> trustedOrigins;
    @NotNull
    private final ConcurrentMap<String, Object> hostLocks;
    private boolean isBlockUnknownHosts;
    @JvmField
    @NotNull
    public static final Logger LOG;
    @NotNull
    public static final String PREFIX = "api";

    public RestService() {
        LoadingCache loadingCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(RestService::abuseCounter$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.abuseCounter = loadingCache;
        Cache cache = Caffeine.newBuilder().maximumSize(1024L).expireAfterWrite(1L, TimeUnit.DAYS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.trustedOrigins = cache;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakKeyWeakValueMap(...)");
        this.hostLocks = concurrentMap;
    }

    @NotNull
    protected final Gson getGson() {
        Lazy lazy = this.gson$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Gson)object;
    }

    protected boolean isPrefixlessAllowed() {
        return false;
    }

    protected boolean getReportErrorsAsPlainText() {
        return false;
    }

    @NlsSafe
    @NotNull
    protected abstract String getServiceName();

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpMethod httpMethod = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"method(...)");
        if (!this.isMethodSupported(httpMethod)) {
            return false;
        }
        String uri = request.uri();
        if (this.isPrefixlessAllowed()) {
            Intrinsics.checkNotNull((Object)uri);
            if (HttpRequestHandler.Companion.checkPrefix(uri, this.getServiceName())) {
                return true;
            }
        }
        String serviceName = this.getServiceName();
        int minLength = 5 + serviceName.length();
        if (uri.length() >= minLength && uri.charAt(0) == '/') {
            Intrinsics.checkNotNull((Object)uri);
            if (StringsKt.regionMatches((String)uri, (int)1, (String)PREFIX, (int)0, (int)3, (boolean)true) && StringsKt.regionMatches((String)uri, (int)5, (String)serviceName, (int)0, (int)serviceName.length(), (boolean)true)) {
                if (uri.length() == minLength) {
                    return true;
                }
                char c = uri.charAt(minLength);
                return c == '/' || c == '?';
            }
        }
        return false;
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method == HttpMethod.GET;
    }

    protected int getMaxRequestsPerMinute() {
        return Registry.Companion.intValue("ide.rest.api.requests.per.minute", 30);
    }

    /*
     * Unable to fully structure code
     */
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (!this.isHostTrusted(request, urlDecoder)) {
                v0 = HttpResponseStatus.FORBIDDEN;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FORBIDDEN");
                v1 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"channel(...)");
                RestService.sendError$default(this, v0, v1, (HttpRequest)request, null, null, 12, null);
                return true;
            }
            v2 = this.abuseCounter.get(this.getRequesterId(urlDecoder, request, context));
            Intrinsics.checkNotNull((Object)v2);
            counter = (AtomicInteger)v2;
            if (counter.incrementAndGet() > this.getMaxRequestsPerMinute()) {
                v3 = HttpResponseStatus.TOO_MANY_REQUESTS;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"TOO_MANY_REQUESTS");
                v4 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"channel(...)");
                RestService.sendError$default(this, v3, v4, (HttpRequest)request, null, null, 12, null);
                return true;
            }
            error = this.execute(urlDecoder, request, context);
            if (error != null) {
                v5 = HttpResponseStatus.BAD_REQUEST;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"BAD_REQUEST");
                v6 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"channel(...)");
                RestService.sendError$default(this, v5, v6, (HttpRequest)request, error, null, 8, null);
            }
        }
        catch (Throwable e) {
            status = null;
            if (e instanceof MalformedJsonException) ** GOTO lbl-1000
            if (e instanceof IllegalStateException) {
                v7 = e.getMessage();
                Intrinsics.checkNotNull((Object)v7);
                ** if (!StringsKt.startsWith$default((String)v7, (String)"Expected a ", (boolean)false, (int)2, null)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                RestService.LOG.warn(e);
                status = HttpResponseStatus.BAD_REQUEST;
                ** GOTO lbl44
            }
lbl-1000:
            // 2 sources

            {
                RestService.LOG.error(e);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
lbl44:
            // 2 sources

            Intrinsics.checkNotNull((Object)status);
            v8 = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"channel(...)");
            RestService.sendError$default(this, status, v8, (HttpRequest)request, XmlStringUtil.escapeString((String)ExceptionUtil.getThrowableText((Throwable)e)), null, 8, null);
        }
        return true;
    }

    private final void sendError(HttpResponseStatus $this$sendError, Channel channel, HttpRequest request, String description, HttpHeaders extraHeaders) {
        if (this.getReportErrorsAsPlainText()) {
            Responses.sendPlainText((HttpResponseStatus)$this$sendError, (Channel)channel, (HttpRequest)request, (String)description, (HttpHeaders)extraHeaders);
        } else {
            Responses.send((HttpResponseStatus)$this$sendError, (Channel)channel, (HttpRequest)request, (String)description, (HttpHeaders)extraHeaders);
        }
    }

    static /* synthetic */ void sendError$default(RestService restService, HttpResponseStatus httpResponseStatus, Channel channel, HttpRequest httpRequest, String string, HttpHeaders httpHeaders, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendError");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        restService.sendError(httpResponseStatus, channel, httpRequest, string, httpHeaders);
    }

    protected boolean isHostTrusted(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) throws InterruptedException, InvocationTargetException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        return this.isHostTrusted(request);
    }

    @NotNull
    protected Object getRequesterId(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws InterruptedException, InvocationTargetException {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SocketAddress socketAddress = context.channel().remoteAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
        return inetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Deprecated(message="Use {@link #isHostTrusted(FullHttpRequest, QueryStringDecoder)}")
    protected boolean isHostTrusted(@NotNull FullHttpRequest request) throws InterruptedException, InvocationTargetException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        $i$f$service = false;
        serviceClass$iv = BuiltInWebServerAuth.class;
        v0 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (v0 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (((BuiltInWebServerAuth)v0).isRequestSigned$intellij_platform_builtInServer_impl((HttpRequest)request) || this.isOriginAllowed((HttpRequest)request) == HttpRequestHandler.OriginCheckResult.ALLOW) {
            return true;
        }
        v1 = NettyKt.getOrigin((HttpRequest)((HttpRequest)request));
        if (v1 == null) {
            v1 = NettyKt.getReferrer((HttpRequest)((HttpRequest)request));
        }
        referrer = v1;
        host = null;
        scheme = null;
        var5_6 = referrer;
        if (var5_6 == null || StringsKt.isBlank((CharSequence)var5_6) != false) {
            host = null;
            scheme = null;
        } else {
            try {
                uri = new URI(referrer);
                var6_8 = uri.getHost();
                if (StringsKt.isBlank((CharSequence)var6_8)) {
                    $i$a$-ifBlank-RestService$isHostTrusted$1 = false;
                    v2 = null;
                } else {
                    v2 = var6_8;
                }
                host = (String)v2;
                var6_8 = uri.getScheme();
                if (StringsKt.isBlank((CharSequence)var6_8)) {
                    $i$a$-ifBlank-RestService$isHostTrusted$2 = false;
                    v3 = null;
                } else {
                    v3 = var6_8;
                }
                scheme = (String)v3;
            }
            catch (URISyntaxException <unused var>) {
                return false;
            }
        }
        if ((v4 = host) == null) {
            v4 = "";
        }
        lock = this.hostLocks.computeIfAbsent(v4, (Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isHostTrusted$lambda$3(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isHostTrusted$lambda$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()));
        Intrinsics.checkNotNull((Object)lock);
        var7_10 = lock;
        synchronized (var7_10) {
            block23: {
                block22: {
                    block21: {
                        $i$a$-synchronized-RestService$isHostTrusted$4 = false;
                        if (host != null && scheme != null) break block21;
                        if (this.isBlockUnknownHosts) {
                            var16_12 = false;
                            return var16_12;
                        }
                        break block22;
                    }
                    if (!RestServiceKt.access$isLocalhost(host)) break block22;
                    var15_13 = true;
                    return var15_13;
                }
                if (host == null) ** GOTO lbl-1000
                v5 = scheme;
                if (v5 == null) lbl-1000:
                // 2 sources

                {
                    v6 = null;
                } else {
                    v6 = key = TuplesKt.to((Object)host, (Object)v5);
                }
                if (key == null) ** GOTO lbl-1000
                v7 = (Boolean)this.trustedOrigins.getIfPresent((Object)key);
                if (v7 == null) break block23;
                it = v7;
                $i$a$-let-RestService$isHostTrusted$4$1 = false;
                var14_18 = it;
                return var14_18;
            }
            isTrusted = new Ref.BooleanRef();
            ApplicationManager.getApplication().invokeAndWait((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, isHostTrusted$lambda$4$1(java.lang.String org.jetbrains.ide.RestService kotlin.jvm.internal.Ref$BooleanRef kotlin.Pair ), ()V)((String)host, (RestService)this, (Ref.BooleanRef)isTrusted, (Pair)key), ModalityState.any());
            var13_20 = isTrusted.element;
            return var13_20;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isHostInPredefinedHosts(@NotNull HttpRequest request, @NotNull Set<String> trustedPredefinedHosts, @NotNull String systemPropertyKey) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(trustedPredefinedHosts, (String)"trustedPredefinedHosts");
        Intrinsics.checkNotNullParameter((Object)systemPropertyKey, (String)"systemPropertyKey");
        String origin = NettyKt.getOrigin((HttpRequest)request);
        if (origin == null) {
            string = null;
        } else {
            String string2;
            try {
                String string3;
                object = new URI(origin);
                URI it = object;
                boolean bl = false;
                Object object2 = Intrinsics.areEqual((Object)it.getScheme(), (Object)"https") ? object : null;
                if (object2 != null && (object2 = ((URI)object2).getHost()) != null) {
                    CharSequence charSequence;
                    CharSequence charSequence2 = (CharSequence)object2;
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl2 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    string3 = (String)charSequence;
                } else {
                    string3 = null;
                }
                string2 = string3;
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
            string = string2;
        }
        String originHost = string;
        String hostName = NettyKt.getHostName((HttpRequest)request);
        if (hostName != null && !RestServiceKt.access$isLocalhost(hostName)) {
            LOG.error("Expected 'request.hostName' to be localhost. hostName='" + hostName + "', origin='" + origin + "'");
        }
        if (originHost == null) return false;
        if (trustedPredefinedHosts.contains(originHost)) return true;
        String string4 = System.getProperty(systemPropertyKey, "");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
        object = new char[1];
        object[0] = 44;
        if (SequencesKt.contains((Sequence)StringsKt.splitToSequence$default((CharSequence)string4, (char[])object, (boolean)false, (int)0, (int)6, null), (Object)originHost)) return true;
        if (!RestServiceKt.access$isLocalhost(originHost)) return false;
        return true;
    }

    @Nullable
    public abstract String execute(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;

    private static final Gson gson_delegate$lambda$0() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    private static final AtomicInteger abuseCounter$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new AtomicInteger();
    }

    private static final void isHostTrusted$lambda$4$1(String $host, RestService this$0, Ref.BooleanRef $isTrusted, Pair $key) {
        String string;
        AppIcon.getInstance().requestAttention(null, true);
        if ($host == null) {
            var6_4 = new Object[]{this$0.getServiceName()};
            string = IdeBundle.message((String)"warning.use.rest.api.0.and.trust.host.unknown", (Object[])var6_4);
        } else {
            var6_4 = new Object[]{this$0.getServiceName(), $host};
            string = IdeBundle.message((String)"warning.use.rest.api.0.and.trust.host.1", (Object[])var6_4);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String message = string2;
        $isTrusted.element = ProjectUtil.INSTANCE.showYesNoDialog(message, "title.use.rest.api");
        if ($key != null) {
            this$0.trustedOrigins.put((Object)$key, (Object)$isTrusted.element);
        } else if (!$isTrusted.element) {
            String string3 = IdeBundle.message((String)"warning.use.rest.api.block.unknown.hosts", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this$0.isBlockUnknownHosts = ProjectUtil.INSTANCE.showYesNoDialog(string3, "title.use.rest.api");
        }
    }

    private static final Object isHostTrusted$lambda$2(String it) {
        return new Object();
    }

    private static final Object isHostTrusted$lambda$3(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    @JvmStatic
    public static final void activateLastFocusedFrame() {
        Companion.activateLastFocusedFrame();
    }

    @JvmStatic
    @NotNull
    public static final JsonReader createJsonReader(@NotNull FullHttpRequest request) {
        return Companion.createJsonReader(request);
    }

    @JvmStatic
    @NotNull
    public static final JsonWriter createJsonWriter(@NotNull OutputStream out) {
        return Companion.createJsonWriter(out);
    }

    @JvmStatic
    @Nullable
    public static final Project getLastFocusedOrOpenedProject() {
        return Companion.getLastFocusedOrOpenedProject();
    }

    @JvmStatic
    public static final void sendOk(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Companion.sendOk(request, context);
    }

    @JvmStatic
    public static final void sendStatus(@NotNull HttpResponseStatus status, boolean keepAlive, @NotNull Channel channel) {
        Companion.sendStatus(status, keepAlive, channel);
    }

    @JvmStatic
    public static final void send(@NotNull BufferExposingByteArrayOutputStream byteOut, @NotNull HttpRequest request, @NotNull ChannelHandlerContext context) {
        Companion.send(byteOut, request, context);
    }

    @JvmStatic
    public static final void sendResponse(@NotNull HttpRequest request, @NotNull ChannelHandlerContext context, @NotNull HttpResponse response) {
        Companion.sendResponse(request, context, response);
    }

    @JvmStatic
    @Nullable
    public static final String getStringParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        return Companion.getStringParameter(name, urlDecoder);
    }

    @JvmStatic
    public static final int getIntParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        return Companion.getIntParameter(name, urlDecoder);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder, boolean defaultValue) {
        return Companion.getBooleanParameter(name, urlDecoder, defaultValue);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        return Companion.getBooleanParameter(name, urlDecoder);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RestService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J \u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J \u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J \u0010\"\u001a\u00020\t2\u0006\u0010\f\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0007J\u001a\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0007J\u0018\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0007J\"\u0010+\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010,\u001a\u00020\u001bH\u0007J\u000e\u0010-\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/ide/RestService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PREFIX", "", "activateLastFocusedFrame", "", "createJsonReader", "Lcom/google/gson/stream/JsonReader;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "createJsonWriter", "Lcom/google/gson/stream/JsonWriter;", "out", "Ljava/io/OutputStream;", "getLastFocusedOrOpenedProject", "Lcom/intellij/openapi/project/Project;", "sendOk", "context", "Lio/netty/channel/ChannelHandlerContext;", "sendStatus", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "keepAlive", "", "channel", "Lio/netty/channel/Channel;", "send", "byteOut", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "Lio/netty/handler/codec/http/HttpRequest;", "sendResponse", "response", "Lio/netty/handler/codec/http/HttpResponse;", "getStringParameter", "name", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "getIntParameter", "", "getBooleanParameter", "defaultValue", "parameterMissedErrorMessage", "intellij.platform.builtInServer.impl"})
    @SourceDebugExtension(value={"SMAP\nRestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestService.kt\norg/jetbrains/ide/RestService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1#2:383\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void activateLastFocusedFrame() {
            block0: {
                IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
                Window window = ideFrame instanceof Window ? (Window)ideFrame : null;
                if (window == null) break block0;
                window.toFront();
            }
        }

        @JvmStatic
        @NotNull
        public final JsonReader createJsonReader(@NotNull FullHttpRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            InputStream inputStream = (InputStream)new ByteBufInputStream(request.content());
            Charset charset = Charsets.UTF_8;
            InputStream $this$createJsonReader_u24lambda_u240 = inputStream = new JsonReader((Reader)new InputStreamReader(inputStream, charset));
            boolean bl = false;
            $this$createJsonReader_u24lambda_u240.setStrictness(Strictness.LENIENT);
            return inputStream;
        }

        @JvmStatic
        @NotNull
        public final JsonWriter createJsonWriter(@NotNull OutputStream out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            OutputStream outputStream = out;
            Charset charset = Charsets.UTF_8;
            OutputStream $this$createJsonWriter_u24lambda_u240 = outputStream = new JsonWriter((Writer)new OutputStreamWriter(outputStream, charset));
            boolean bl = false;
            $this$createJsonWriter_u24lambda_u240.setIndent("  ");
            return outputStream;
        }

        @JvmStatic
        @Nullable
        public final Project getLastFocusedOrOpenedProject() {
            IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            if (ideFrame == null || (ideFrame = ideFrame.getProject()) == null) {
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                ideFrame = (Project)ArraysKt.firstOrNull((Object[])projectArray);
            }
            return ideFrame;
        }

        @JvmStatic
        public final void sendOk(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            boolean bl = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            this.sendStatus(httpResponseStatus, bl, channel);
        }

        @JvmStatic
        public final void sendStatus(@NotNull HttpResponseStatus status, boolean keepAlive, @NotNull Channel channel) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Responses.responseStatus((HttpResponseStatus)status, (boolean)keepAlive, (Channel)channel);
        }

        @JvmStatic
        public final void send(@NotNull BufferExposingByteArrayOutputStream byteOut, @NotNull HttpRequest request, @NotNull ChannelHandlerContext context) {
            Intrinsics.checkNotNullParameter((Object)byteOut, (String)"byteOut");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            FullHttpResponse response = Responses.response((String)"application/json", (ByteBuf)Unpooled.wrappedBuffer((byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size()));
            this.sendResponse(request, context, (HttpResponse)response);
        }

        @JvmStatic
        public final void sendResponse(@NotNull HttpRequest request, @NotNull ChannelHandlerContext context, @NotNull HttpResponse response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Responses.addNoCache((HttpResponse)response);
            response.headers().set("X-Frame-Options", (Object)"Deny");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponse)response, (Channel)channel, (HttpRequest)request, null, (int)4, null);
        }

        @JvmStatic
        @Nullable
        public final String getStringParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            List list = (List)urlDecoder.parameters().get(name);
            return list != null ? (String)CollectionsKt.lastOrNull((List)list) : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final int getIntParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            String string = this.getStringParameter(name, urlDecoder);
            Object object = string;
            if (string == null) return -1;
            CharSequence charSequence2 = (CharSequence)object;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            String string2 = (String)charSequence;
            object = string2;
            if (string2 == null) return -1;
            Integer n = StringsKt.toIntOrNull((String)object);
            object = n;
            if (n == null) return -1;
            int n2 = (Integer)object;
            return n2;
        }

        @JvmStatic
        @JvmOverloads
        public final boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            List list = (List)urlDecoder.parameters().get(name);
            if (list == null) {
                return defaultValue;
            }
            List values = list;
            String string = (String)CollectionsKt.lastOrNull((List)values);
            if (string == null) {
                return true;
            }
            String value = string;
            return Boolean.parseBoolean(value);
        }

        public static /* synthetic */ boolean getBooleanParameter$default(Companion companion, String string, QueryStringDecoder queryStringDecoder, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.getBooleanParameter(string, queryStringDecoder, bl);
        }

        @NotNull
        public final String parameterMissedErrorMessage(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return "Parameter \"" + name + "\" is not specified";
        }

        @JvmStatic
        @JvmOverloads
        public final boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            return org.jetbrains.ide.RestService$Companion.getBooleanParameter$default(this, name, urlDecoder, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

