/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.NettyKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.Attribute;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.DelegatingHttpRequestHandlerKt;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

@ChannelHandler.Sharable
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/io/DelegatingHttpRequestHandler;", "Lorg/jetbrains/io/SimpleChannelInboundHandlerAdapter;", "Lio/netty/handler/codec/http/FullHttpRequest;", "<init>", "()V", "messageReceived", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "request", "process", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "exceptionCaught", "cause", "", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nDelegatingHttpRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelegatingHttpRequestHandler.kt\norg/jetbrains/io/DelegatingHttpRequestHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n13#2:69\n60#2,5:70\n13#2:75\n*S KotlinDebug\n*F\n+ 1 DelegatingHttpRequestHandler.kt\norg/jetbrains/io/DelegatingHttpRequestHandler\n*L\n22#1:69\n22#1:70,5\n64#1:75\n*E\n"})
public final class DelegatingHttpRequestHandler
extends SimpleChannelInboundHandlerAdapter<FullHttpRequest> {
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuiltInServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            logger2.debug("\n\nIN HTTP: " + request + "\n\n", t$iv);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return;
        }
        if (!this.process(context, request, new QueryStringDecoder(request.uri()))) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            HttpResponse httpResponse = Responses.createStatusResponse$default((HttpResponseStatus)httpResponseStatus, (HttpRequest)((HttpRequest)request), null, (boolean)false, (int)12, null);
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (int)4, null);
        }
    }

    private final boolean process(ChannelHandlerContext context, FullHttpRequest request, QueryStringDecoder urlDecoder) {
        HttpRequestHandler handler2;
        HttpRequestHandler prevHandler;
        if (NettyKt.isWriteFromBrowserWithoutOrigin((HttpRequest)((HttpRequest)request))) {
            return false;
        }
        Attribute prevHandlerAttribute = context.channel().attr(DelegatingHttpRequestHandlerKt.access$getPREV_HANDLER$p());
        WeakReference weakReference = (WeakReference)prevHandlerAttribute.get();
        Object object = prevHandler = weakReference != null ? (HttpRequestHandler)weakReference.get() : null;
        if (prevHandler != null) {
            if (DelegatingHttpRequestHandler.process$checkAndProcess(prevHandler, request, urlDecoder, context)) {
                return true;
            }
            prevHandlerAttribute.set(null);
        }
        if ((handler2 = (HttpRequestHandler)HttpRequestHandler.Companion.getEP_NAME().findFirstSafe(arg_0 -> DelegatingHttpRequestHandler.process$lambda$1(arg_0 -> DelegatingHttpRequestHandler.process$lambda$0(request, urlDecoder, context, arg_0), arg_0))) != null) {
            prevHandlerAttribute.set(new WeakReference<HttpRequestHandler>(handler2));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        try {
            context.channel().attr(DelegatingHttpRequestHandlerKt.access$getPREV_HANDLER$p()).set(null);
        }
        finally {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(BuiltInServer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            NettyUtil.logAndClose((Throwable)cause, (Logger)logger, (Channel)context.channel());
        }
    }

    private static final boolean process$checkAndProcess(HttpRequestHandler $this$process_u24checkAndProcess, FullHttpRequest $request, QueryStringDecoder $urlDecoder, ChannelHandlerContext $context) {
        return $this$process_u24checkAndProcess.isSupported($request) && $this$process_u24checkAndProcess.isAccessible((HttpRequest)$request) && $this$process_u24checkAndProcess.process($urlDecoder, $request, $context);
    }

    private static final boolean process$lambda$0(FullHttpRequest $request, QueryStringDecoder $urlDecoder, ChannelHandlerContext $context, HttpRequestHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DelegatingHttpRequestHandler.process$checkAndProcess(it, $request, $urlDecoder, $context);
    }

    private static final boolean process$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

