/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.IntObjectMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoop;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.jsonRpc.ExceptionHandler;

public abstract class Client
extends UserDataHolderBase {
    protected final Channel channel;
    final IntObjectMap<AsyncPromise<Object>> messageCallbackMap;

    protected Client(@NotNull Channel channel) {
        if (channel == null) {
            Client.$$$reportNull$$$0(0);
        }
        this.messageCallbackMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.channel = channel;
    }

    @NotNull
    public final EventLoop getEventLoop() {
        EventLoop eventLoop = this.channel.eventLoop();
        if (eventLoop == null) {
            Client.$$$reportNull$$$0(1);
        }
        return eventLoop;
    }

    @NotNull
    public final ByteBufAllocator getByteBufAllocator() {
        ByteBufAllocator byteBufAllocator = this.channel.alloc();
        if (byteBufAllocator == null) {
            Client.$$$reportNull$$$0(2);
        }
        return byteBufAllocator;
    }

    @NotNull
    protected abstract ChannelFuture send(@NotNull ByteBuf var1);

    public abstract void sendHeartbeat();

    @Nullable
    final <T> Promise<T> send(int messageId, @NotNull ByteBuf message) {
        if (message == null) {
            Client.$$$reportNull$$$0(3);
        }
        ChannelFuture channelFuture = this.send(message);
        if (messageId == -1) {
            return null;
        }
        AsyncPromise promise = new AsyncPromise().onError(error -> this.messageCallbackMap.remove(messageId));
        channelFuture.addListener(future -> {
            if (!future.isSuccess()) {
                Throwable cause = future.cause();
                if (cause == null) {
                    promise.setError("No success");
                } else {
                    promise.setError(cause);
                }
            }
        });
        this.messageCallbackMap.put(messageId, (Object)promise);
        return promise;
    }

    final void rejectAsyncResults(@NotNull ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            Client.$$$reportNull$$$0(4);
        }
        if (!this.messageCallbackMap.isEmpty()) {
            for (AsyncPromise promise : this.messageCallbackMap.values()) {
                try {
                    promise.setError("rejected");
                }
                catch (Throwable e) {
                    exceptionHandler.exceptionCaught(e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/jsonRpc/Client";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/jsonRpc/Client";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventLoop";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteBufAllocator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rejectAsyncResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

