/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.ArtifactProblemFix;
import com.intellij.database.dataSource.ClasspathModificationTracker;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.EelParametersTuner;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.run.EelDatabaseHelperKt;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0010H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J8\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u00102\u0006\u0010\t\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0002J*\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0014\u0010'\u001a\n (*\u0004\u0018\u00010\u00140\u0014*\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/database/dataSource/DatabaseDriverClasspathManagerImpl;", "Lcom/intellij/database/dataSource/DatabaseDriverClasspathManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getNativeLibraryPaths", "", "Lcom/intellij/util/ui/classpath/SimpleClasspathElement;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "context", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactContext;", "getAdditionalClasspathElements", "getClasspathElements", "getElements", "", "artifact", "Lcom/intellij/database/dataSource/DatabaseDriver$ArtifactRef;", "inDir", "Ljava/nio/file/Path;", "hasDriverFiles", "", "getArtifactProblemsFix", "Lcom/intellij/database/dataSource/ArtifactProblemFix;", "createArtifactTransferFix", "driverName", "", "fixes", "Lkotlin/Function0;", "", "collectTransferRunnables", "isValidFiles", "collectPathsToTransfer", "localClassPath", "localNativeLibs", "collectPathsToTransferFrom", "elements", "dir", "urlToPath", "kotlin.jvm.PlatformType", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseDriverClasspathManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseDriverClasspathManagerImpl.kt\ncom/intellij/database/dataSource/DatabaseDriverClasspathManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,119:1\n1391#2:120\n1480#2,5:121\n1586#2:127\n1661#2,3:128\n1807#2,3:133\n1391#2:136\n1480#2,5:137\n1586#2:142\n1661#2,3:143\n1391#2:146\n1480#2,5:147\n1586#2:152\n1661#2,3:153\n1391#2:156\n1480#2,5:157\n1586#2:162\n1661#2,3:163\n1391#2:166\n1480#2,5:167\n1586#2:172\n1661#2,3:173\n1786#2,3:176\n1915#2,2:179\n1#3:126\n37#4,2:131\n*S KotlinDebug\n*F\n+ 1 DatabaseDriverClasspathManagerImpl.kt\ncom/intellij/database/dataSource/DatabaseDriverClasspathManagerImpl\n*L\n47#1:120\n47#1:121,5\n56#1:127\n56#1:128,3\n62#1:133,3\n82#1:136\n82#1:137,5\n82#1:142\n82#1:143,3\n83#1:146\n83#1:147,5\n83#1:152\n83#1:153,3\n91#1:156\n91#1:157,5\n91#1:162\n91#1:163,3\n92#1:166\n92#1:167,5\n92#1:172\n92#1:173,3\n93#1:176,3\n106#1:179,2\n58#1:131,2\n*E\n"})
public final class DatabaseDriverClasspathManagerImpl
implements DatabaseDriverClasspathManager {
    @NotNull
    private final Project project;

    public DatabaseDriverClasspathManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public List<SimpleClasspathElement> getNativeLibraryPaths(@NotNull DatabaseDriver driver, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.useEel()) {
            List list = driver.getNativeLibraryPaths();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNativeLibraryPaths(...)");
            return list;
        }
        if (!EelDatabaseHelperKt.hasNativeLibsDir(this.project)) {
            return new ArrayList();
        }
        return this.getElements(EelDatabaseHelperKt.getNativeLibsDir(this.project, driver));
    }

    @NotNull
    public List<SimpleClasspathElement> getAdditionalClasspathElements(@NotNull DatabaseDriver driver, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.useEel()) {
            List list = driver.getAdditionalClasspathElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalClasspathElements(...)");
            return list;
        }
        if (!EelDatabaseHelperKt.hasAdditionalClasspathDir(this.project)) {
            return new ArrayList();
        }
        return this.getElements(EelDatabaseHelperKt.getAdditionalClasspathDir(this.project, driver));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SimpleClasspathElement> getClasspathElements(@NotNull DatabaseDriver driver, @NotNull DatabaseArtifactContext context) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list = driver.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArtifacts(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DatabaseDriver.ArtifactRef it = (DatabaseDriver.ArtifactRef)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = this.getElements(it, context);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.getAdditionalClasspathElements(driver, context)));
    }

    private final List<SimpleClasspathElement> getElements(DatabaseDriver.ArtifactRef artifact, DatabaseArtifactContext context) {
        Object object;
        block3: {
            block2: {
                object = artifact.getArtifactVersion();
                if (object == null) break block2;
                Version it = object;
                boolean bl = false;
                List list = DatabaseArtifactManager.getClasspathElements((String)artifact.getId(), (Version)it, (DatabaseArtifactContext)context);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleClasspathElement> getElements(Path inDir) {
        void $this$mapTo$iv$iv;
        List<Path> list = Files.list(inDir).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(VfsUtilCore.pathToUrl((String)EelNioBridgeServiceKt.asEelPath((Path)it).toString()));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        List list2 = SimpleClasspathElementFactory.createElements((String[])Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createElements(...)");
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasDriverFiles(@NotNull DatabaseDriver driver, @NotNull DatabaseArtifactContext context) {
        DatabaseDriver.ArtifactRef it;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.getAdditionalClasspathElements(driver, context).isEmpty()) return true;
        List list = driver.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArtifacts(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (DatabaseDriver.ArtifactRef)element$iv;
            boolean bl = false;
        } while (!it.hasElements(context));
        boolean bl = true;
        if (!bl) return false;
        if (!this.isValidFiles(driver, context)) return false;
        return true;
    }

    @Nullable
    public ArtifactProblemFix getArtifactProblemsFix(@NotNull DatabaseDriver driver, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.useEel()) {
            return null;
        }
        return this.collectTransferRunnables(driver);
    }

    private final ArtifactProblemFix createArtifactTransferFix(String driverName, List<? extends Function0<Unit>> fixes) {
        String string = DatabaseBundle.message((String)"DataSourceConfigurable.transfer.driver", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message((String)"DataSourceConfigurable.drivers.not.transferred", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = DatabaseBundle.message((String)"DataSourceConfigurable.transferring.driver.files", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = DatabaseBundle.message((String)"notification.content.href.action0.transfer.missing.driver.files", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        Object[] objectArray = new Object[]{driverName};
        String string5 = DatabaseBundle.message((String)"transfer.missing.a.href.action1", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        return new ArtifactProblemFix(string, string2, string3, string4, string5, fixes);
    }

    /*
     * WARNING - void declaration
     */
    private final ArtifactProblemFix collectTransferRunnables(DatabaseDriver driver) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object list$iv$iv;
        SimpleClasspathElement it;
        Iterable $this$flatMapTo$iv$iv2;
        List list = driver.getAdditionalClasspathElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalClasspathElements(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (SimpleClasspathElement)element$iv$iv;
            boolean bl = false;
            List list2 = it.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getClassesRootUrls(...)");
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            list$iv$iv = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.urlToPath((String)it));
        }
        List localClassPath = (List)destination$iv$iv;
        List list3 = driver.getNativeLibraryPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getNativeLibraryPaths(...)");
        Iterable $this$flatMap$iv2 = list3;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SimpleClasspathElement it2 = (SimpleClasspathElement)element$iv$iv;
            boolean bl = false;
            List list4 = it2.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getClassesRootUrls(...)");
            Iterable list$iv$iv2 = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            String list$iv$iv2 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it3);
            collection.add(this.urlToPath((String)it3));
        }
        List localNativeLibs = (List)destination$iv$iv2;
        String string = StringUtil.escapeXmlEntities((String)driver.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        String driverName = string;
        List<Function0<Unit>> fixes = this.collectPathsToTransfer(driver, localClassPath, localNativeLibs);
        return fixes.isEmpty() ? null : this.createArtifactTransferFix(driverName, fixes);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidFiles(DatabaseDriver driver, DatabaseArtifactContext context) {
        Path it;
        boolean bl;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv2;
        Object list$iv$iv;
        SimpleClasspathElement it2;
        void $this$flatMapTo$iv$iv;
        List list = driver.getAdditionalClasspathElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalClasspathElements(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it2 = (SimpleClasspathElement)element$iv$iv;
            boolean bl2 = false;
            List list2 = it2.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getClassesRootUrls(...)");
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)collection2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)collection2;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv2;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            collection = collection3;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it2);
            collection.add(this.urlToPath((String)it2));
        }
        List localClassPath = (List)collection3;
        List list3 = driver.getNativeLibraryPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getNativeLibraryPaths(...)");
        Iterable $this$flatMap$iv2 = list3;
        boolean $i$f$flatMap2 = false;
        Iterable iterable2 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : iterable2) {
            SimpleClasspathElement it3 = (SimpleClasspathElement)element$iv$iv;
            boolean bl4 = false;
            List list4 = it3.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getClassesRootUrls(...)");
            Iterable list$iv$iv2 = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$map2 = false;
        void var7_11 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : var7_11) {
            void it4;
            String list$iv$iv2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)it4);
            collection.add(this.urlToPath((String)it4));
        }
        List localNativeLibs = (List)destination$iv$iv;
        if (context.useEel()) return this.collectPathsToTransfer(driver, localClassPath, localNativeLibs).isEmpty();
        Iterable $this$all$iv = localClassPath;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                Path it5 = (Path)element$iv;
                boolean bl6 = false;
                if (Files.exists(it5, new LinkOption[0])) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        $this$all$iv = localNativeLibs;
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (Path)element$iv;
            boolean bl7 = false;
        } while (Files.exists(it, new LinkOption[0]));
        return false;
    }

    private final List<Function0<Unit>> collectPathsToTransfer(DatabaseDriver driver, List<? extends Path> localClassPath, List<? extends Path> localNativeLibs) {
        return CollectionsKt.plus((Collection)this.collectPathsToTransferFrom(localClassPath, EelDatabaseHelperKt.getAdditionalClasspathDir(this.project, driver)), (Iterable)this.collectPathsToTransferFrom(localNativeLibs, EelDatabaseHelperKt.getNativeLibsDir(this.project, driver)));
    }

    private final List<Function0<Unit>> collectPathsToTransferFrom(List<? extends Path> elements, Path dir) {
        ClasspathModificationTracker modificationService = ClasspathModificationTracker.Companion.getInstance();
        ArrayList<Function0> result = new ArrayList<Function0>();
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Path expected = dir.resolve(PathsKt.getName((Path)it));
            Function0<Unit> callback = modificationService.checkAndGetUpdateCallback(it);
            if (Files.exists(expected, new LinkOption[0]) && callback == null) continue;
            result.add(() -> DatabaseDriverClasspathManagerImpl.collectPathsToTransferFrom$lambda$0$0(it, expected, callback));
        }
        return result;
    }

    private final Path urlToPath(String $this$urlToPath) {
        return Path.of(StringsKt.removePrefix((String)$this$urlToPath, (CharSequence)"file://"), new String[0]);
    }

    private static final Unit collectPathsToTransferFrom$lambda$0$0(Path $it, Path $expected, Function0 $callback) {
        block0: {
            Intrinsics.checkNotNull((Object)$expected);
            EelPathUtils.transferLocalContentToRemote$default((Path)$it, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit($expected)), (EelPathUtils.FileTransferAttributesStrategy)((EelPathUtils.FileTransferAttributesStrategy)EelParametersTuner.Companion.getAllPermissions()), null, (int)8, null);
            Function0 function0 = $callback;
            if (function0 == null) break block0;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }
}

