/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.ClasspathModificationTracker;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.run.EelDatabaseHelperKt;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.project.Project;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.util.PathsList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/EelParametersTuner;", "Lcom/intellij/database/run/ConsoleRunContextParametersTuner;", "<init>", "()V", "tuneParams", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "Companion", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nEelParametersTuner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelParametersTuner.kt\ncom/intellij/database/dataSource/EelParametersTuner\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,52:1\n37#2,2:53\n*S KotlinDebug\n*F\n+ 1 EelParametersTuner.kt\ncom/intellij/database/dataSource/EelParametersTuner\n*L\n50#1:53,2\n*E\n"})
public final class EelParametersTuner
implements ConsoleRunContextParametersTuner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EelPathUtils.FileTransferAttributesStrategy.RequirePosixPermissions allPermissions;

    @Override
    public void tuneParams(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull SimpleJavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        PathsList pathsList = params.getClassPath();
        Intrinsics.checkNotNullExpressionValue((Object)pathsList, (String)"getClassPath(...)");
        Companion.transferPathListIfNeeded(project, pathsList, dataSource);
    }

    static {
        Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PosixFilePermission[] posixFilePermissionArray = thisCollection$iv.toArray(new PosixFilePermission[0]);
        allPermissions = EelPathUtils.FileTransferAttributesStrategy.Companion.copyWithRequiredPosixPermissions(Arrays.copyOf(posixFilePermissionArray, posixFilePermissionArray.length));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/EelParametersTuner$Companion;", "", "<init>", "()V", "transferPathListIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "list", "Lcom/intellij/util/PathsList;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "copyIfNeeded", "", "stringPath", "classpathDir", "Ljava/nio/file/Path;", "modificationService", "Lcom/intellij/database/dataSource/ClasspathModificationTracker;", "allPermissions", "Lcom/intellij/platform/eel/provider/utils/EelPathUtils$FileTransferAttributesStrategy$RequirePosixPermissions;", "getAllPermissions", "()Lcom/intellij/platform/eel/provider/utils/EelPathUtils$FileTransferAttributesStrategy$RequirePosixPermissions;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nEelParametersTuner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelParametersTuner.kt\ncom/intellij/database/dataSource/EelParametersTuner$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1915#2,2:53\n1915#2,2:55\n*S KotlinDebug\n*F\n+ 1 EelParametersTuner.kt\ncom/intellij/database/dataSource/EelParametersTuner$Companion\n*L\n30#1:53,2\n34#1:55,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void transferPathListIfNeeded(@NotNull Project project, @NotNull PathsList list, @NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            if (!DatabaseArtifactContext.Companion.getInstance(project, dataSource).useEel()) {
                return;
            }
            ClasspathModificationTracker modificationService = ClasspathModificationTracker.Companion.getInstance();
            Path classpathDir = EelDatabaseHelperKt.getClassPathDir(project);
            List toRemove = new ArrayList();
            List toAdd = new ArrayList();
            List list2 = list.getPathList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPathList(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                toAdd.add(Companion.copyIfNeeded(StringsKt.removePrefix((String)it, (CharSequence)"file://"), classpathDir, modificationService));
                toRemove.add(it);
            }
            $this$forEach$iv = toRemove;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                list.remove(p0);
            }
            list.addAll(toAdd);
        }

        private final String copyIfNeeded(String stringPath, Path classpathDir, ClasspathModificationTracker modificationService) {
            Path path = Path.of(stringPath, new String[0]);
            Intrinsics.checkNotNull((Object)path);
            if (Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)path), (Object)EelProviderUtil.getEelDescriptor((Path)classpathDir))) {
                return EelNioBridgeServiceKt.asEelPath((Path)path).toString();
            }
            Path expectedPath = classpathDir.resolve(path.getFileName());
            if (!Files.exists(expectedPath, new LinkOption[0]) || modificationService.checkAndUpdate(path)) {
                Intrinsics.checkNotNull((Object)expectedPath);
                EelPathUtils.transferLocalContentToRemote$default((Path)path, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit(expectedPath)), (EelPathUtils.FileTransferAttributesStrategy)((EelPathUtils.FileTransferAttributesStrategy)this.getAllPermissions()), null, (int)8, null);
            }
            Intrinsics.checkNotNull((Object)expectedPath);
            return EelNioBridgeServiceKt.asEelPath((Path)expectedPath).toString();
        }

        @NotNull
        public final EelPathUtils.FileTransferAttributesStrategy.RequirePosixPermissions getAllPermissions() {
            return allPermissions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<PosixFilePermission> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])PosixFilePermission.values());
        }
    }
}

