/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u001e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u001a.\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0007H\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"savePathMappingsAndScheduleUpload", "", "project", "Lcom/intellij/openapi/project/Project;", "webServerConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "pathMappings", "", "Lcom/jetbrains/plugins/webDeployment/config/DeploymentPathMapping;", "uploadChanges", "", "scheduleAutoUploadChanges", "publishConfig", "Lcom/jetbrains/plugins/webDeployment/config/PublishConfig;", "enableAutoUploadChanges", "disableAutoUploadChanges", "uploadPublishConfigToServer", "uploadToServer", "server", "Lcom/jetbrains/plugins/webDeployment/config/Deployable;", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "invokeLaterNonModal", "runnable", "Lkotlin/Function0;", "intellij.remoteRun"})
@SourceDebugExtension(value={"SMAP\nWebDeploymentConfigurationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebDeploymentConfigurationUtil.kt\ncom/jetbrains/plugins/remotesdk/WebDeploymentConfigurationUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1642#2,10:98\n1915#2:108\n1916#2:110\n1652#2:111\n1#3:109\n*S KotlinDebug\n*F\n+ 1 WebDeploymentConfigurationUtil.kt\ncom/jetbrains/plugins/remotesdk/WebDeploymentConfigurationUtilKt\n*L\n66#1:98,10\n66#1:108\n66#1:110\n66#1:111\n66#1:109\n*E\n"})
public final class WebDeploymentConfigurationUtilKt {
    public static final void savePathMappingsAndScheduleUpload(@Nullable Project project, @NotNull WebServerConfig webServerConfig, @NotNull List<? extends DeploymentPathMapping> pathMappings, boolean uploadChanges) {
        Intrinsics.checkNotNullParameter((Object)webServerConfig, (String)"webServerConfig");
        Intrinsics.checkNotNullParameter(pathMappings, (String)"pathMappings");
        String string = webServerConfig.getId();
        if (string == null) {
            throw new IllegalStateException("Deployment server config id must not be null");
        }
        String serverId = string;
        if (!((Collection)pathMappings).isEmpty() && project != null && !project.isDefault()) {
            PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
            publishConfig.setPathMappings(serverId, pathMappings);
            if (uploadChanges) {
                Intrinsics.checkNotNull((Object)publishConfig);
                WebDeploymentConfigurationUtilKt.scheduleAutoUploadChanges(project, webServerConfig, publishConfig);
            }
        }
    }

    private static final void scheduleAutoUploadChanges(Project project, WebServerConfig webServerConfig, PublishConfig publishConfig) {
        WebDeploymentConfigurationUtilKt.invokeLaterNonModal((Function0<Unit>)((Function0)() -> WebDeploymentConfigurationUtilKt.scheduleAutoUploadChanges$lambda$0(project, webServerConfig, publishConfig)));
    }

    public static final void enableAutoUploadChanges(@NotNull Project project, @NotNull WebServerConfig webServerConfig, @NotNull PublishConfig publishConfig) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)webServerConfig, (String)"webServerConfig");
        Intrinsics.checkNotNullParameter((Object)publishConfig, (String)"publishConfig");
        publishConfig.setDefaultGroupOrServerName(webServerConfig.getName());
        publishConfig.setAutoUploadState(PublishConfig.AutoUploadState.ALWAYS);
        MessageBus messageBus = project.getMessageBus();
        Topic topic = WebDeploymentTopics.DEPLOYMENT_CONFIG;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DEPLOYMENT_CONFIG");
        ((DeploymentConfigChangeListener)messageBus.syncPublisher(topic)).optionsChanged();
    }

    public static final void disableAutoUploadChanges(@NotNull Project project, @NotNull PublishConfig publishConfig) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)publishConfig, (String)"publishConfig");
        publishConfig.setDefaultGroupOrServerName(null);
        MessageBus messageBus = project.getMessageBus();
        Topic topic = WebDeploymentTopics.DEPLOYMENT_CONFIG;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DEPLOYMENT_CONFIG");
        ((DeploymentConfigChangeListener)messageBus.syncPublisher(topic)).optionsChanged();
    }

    /*
     * WARNING - void declaration
     */
    public static final void uploadPublishConfigToServer(@NotNull Project project, @NotNull WebServerConfig webServerConfig, @NotNull PublishConfig publishConfig) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)webServerConfig, (String)"webServerConfig");
        Intrinsics.checkNotNullParameter((Object)publishConfig, (String)"publishConfig");
        Deployable server = Deployable.create((WebServerConfig)webServerConfig, (Project)project);
        List list = publishConfig.getPathMappings(webServerConfig.getId());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathMappings(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DeploymentPathMapping it = (DeploymentPathMapping)element$iv$iv;
            boolean bl2 = false;
            if (LocalFileSystem.getInstance().findFileByPath(it.getLocalPath()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)server);
        WebDeploymentConfigurationUtilKt.uploadToServer(project, server, publishConfig, roots);
    }

    private static final void uploadToServer(Project project, Deployable server, PublishConfig publishConfig, List<? extends VirtualFile> roots) {
        Object[] objectArray = new Object[]{StringUtil.notNullize((String)server.getName())};
        String string = WDBundle.message((String)"upload.to", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        objectArray = ConnectionOwnerFactory.createConnectionOwner((Project)project);
        DeploymentRevisionTracker deploymentRevisionTracker = ProjectDeploymentRevisionTracker.getInstance((Project)project);
        TransferTask.ListBased transferTask2 = new TransferTask.ListBased(project, publishConfig, server, title, roots, (ConnectionOwner)objectArray, deploymentRevisionTracker){
            final /* synthetic */ List<VirtualFile> $roots;
            {
                this.$roots = $roots;
                super($project, $super_call_param$1, true, $publishConfig, $server, $title, true, true, true, $super_call_param$2);
            }

            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles((ExecutionContext)context, (Collection)this.$roots);
                Intrinsics.checkNotNullExpressionValue((Object)resultWithErrors, (String)"scanFiles(...)");
                return resultWithErrors;
            }
        };
        FileTransferToolWindow.printWithTimestamp((Project)project, (Mappable)((Mappable)server), (String)title, (ConsoleViewContentType)ConsoleViewContentType.SYSTEM_OUTPUT, (PublishConfig.TraceLevel)publishConfig.getTraceLevel());
        ProgressManager.getInstance().run((Task)transferTask2);
    }

    private static final void invokeLaterNonModal(Function0<Unit> runnable) {
        ApplicationManager.getApplication().invokeLater(() -> WebDeploymentConfigurationUtilKt.invokeLaterNonModal$lambda$0(runnable), ModalityState.nonModal());
    }

    private static final Unit scheduleAutoUploadChanges$lambda$0(Project $project, WebServerConfig $webServerConfig, PublishConfig $publishConfig) {
        WebDeploymentConfigurationUtilKt.uploadPublishConfigToServer($project, $webServerConfig, $publishConfig);
        WebDeploymentConfigurationUtilKt.enableAutoUploadChanges($project, $webServerConfig, $publishConfig);
        return Unit.INSTANCE;
    }

    private static final void invokeLaterNonModal$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

