/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModelBase;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.model.MavenProfile;

public class MavenModel
extends MavenModelBase {
    private MavenId myMavenId;
    private MavenParent myParent;
    private String myPackaging;
    private String myName;
    @NotNull
    private @NotNull List<@NotNull MavenProfile> myProfiles;
    private final MavenBuild myBuild;

    public MavenModel() {
        this.myProfiles = new CopyOnWriteArrayList<MavenProfile>();
        this.myMavenId = new MavenId("Unknown", "Unknown", "Unknown");
        this.myBuild = new MavenBuild();
    }

    protected MavenModel(@NotNull MavenModel other) {
        if (other == null) {
            MavenModel.$$$reportNull$$$0(0);
        }
        super(other);
        this.myProfiles = new CopyOnWriteArrayList<MavenProfile>();
        this.myMavenId = other.myMavenId;
        this.myParent = other.myParent;
        this.myPackaging = other.myPackaging;
        this.myName = other.myName;
        this.myProfiles = new CopyOnWriteArrayList<MavenProfile>();
        for (MavenProfile p : other.myProfiles) {
            this.myProfiles.add(p.copy());
        }
        this.myBuild = other.myBuild.copy();
    }

    @Override
    public MavenModel copy() {
        return new MavenModel(this);
    }

    public MavenId getMavenId() {
        return this.myMavenId;
    }

    public void setMavenId(MavenId mavenId) {
        this.myMavenId = mavenId;
    }

    public MavenParent getParent() {
        return this.myParent;
    }

    public void setParent(MavenParent parent) {
        this.myParent = parent;
    }

    public String getPackaging() {
        return this.myPackaging;
    }

    public void setPackaging(String packaging) {
        this.myPackaging = packaging;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public List<MavenProfile> getProfiles() {
        return Collections.unmodifiableList(this.myProfiles);
    }

    public void setProfiles(List<MavenProfile> profiles) {
        this.myProfiles = new CopyOnWriteArrayList<MavenProfile>(profiles);
    }

    public MavenBuild getBuild() {
        return this.myBuild;
    }

    public String toString() {
        return "{mavenId=" + this.myMavenId + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/idea/maven/model/MavenModel", "<init>"));
    }
}

