/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class BlockBraceFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            BlockBraceFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiCodeBlock) {
            PsiCodeBlock block = (PsiCodeBlock)psiElement;
            if (BlockBraceFixer.afterUnmatchedBrace(editor, psiElement.getContainingFile().getFileType())) {
                int stopOffset = block.getTextRange().getEndOffset();
                PsiStatement[] statements = block.getStatements();
                if (statements.length > 0) {
                    stopOffset = statements[0].getTextRange().getEndOffset();
                }
                editor.getDocument().insertString(stopOffset, (CharSequence)"}");
            }
        }
    }

    static boolean afterUnmatchedBrace(Editor editor, FileType fileType) {
        return EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace((Editor)editor, (int)editor.getCaretModel().getOffset(), (FileType)fileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/BlockBraceFixer", "apply"));
    }
}

