/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class WhileConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            WhileConditionFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)psiElement;
            Document doc = editor.getDocument();
            PsiJavaToken rParenth = whileStatement.getRParenth();
            PsiJavaToken lParenth = whileStatement.getLParenth();
            PsiExpression condition = whileStatement.getCondition();
            if (condition == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(whileStatement.getTextRange().getStartOffset()));
                    PsiStatement block = whileStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, whileStatement.getTextRange().getEndOffset());
                    doc.replaceString(whileStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"while ()");
                    processor.registerUnresolvedError(whileStatement.getTextRange().getStartOffset() + "while (".length());
                } else {
                    processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/WhileConditionFixer", "apply"));
    }
}

