/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.debugger.impl.shared.actions;

import com.intellij.CommonBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.java.debugger.impl.shared.engine.JavaValueTextModificationPreparatorKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.messages.XDebuggerImplBundle;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.tree.actions.XFetchValueActionBase;
import com.intellij.xdebugger.impl.ui.tree.actions.XFetchValueSplitActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ViewTextActionBase
extends XFetchValueSplitActionBase {
    protected void handle(Project project, String value) {
    }

    @NotNull
    protected XFetchValueActionBase.ValueCollector createCollector(@NotNull AnActionEvent e) {
        if (e == null) {
            ViewTextActionBase.$$$reportNull$$$0(0);
        }
        final XValueNodeImpl node = this.getStringNode(e);
        return new XFetchValueActionBase.ValueCollector(this, e.getProject()){
            MyDialog dialog;
            {
                super((XFetchValueActionBase)this$0, arg0);
                this.dialog = null;
            }

            public void handleInCollector(Project project, String value) {
                String text = value;
                if (this.dialog == null) {
                    this.dialog = new MyDialog(project, text, node);
                    this.dialog.setTitle(node != null ? XDebuggerImplBundle.message((String)"action.Debugger.ViewEditText.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.Debugger.ViewText.text", (Object[])new Object[0]));
                    this.dialog.show();
                }
                this.dialog.setText(text);
            }
        };
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ViewTextActionBase.$$$reportNull$$$0(1);
        }
        super.update(e);
        if (this.getStringNode(e) != null) {
            e.getPresentation().setText(XDebuggerImplBundle.lazyMessage((String)"action.Debugger.ViewEditText.text", (Object[])new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ViewTextActionBase.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    protected abstract XValueNodeImpl getStringNode(@NotNull AnActionEvent var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/debugger/impl/shared/actions/ViewTextActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/debugger/impl/shared/actions/ViewTextActionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCollector";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class MyDialog
    extends DialogWrapper {
        private final TextViewer myTextViewer;
        private final XValueNodeImpl myStringNode;

        private MyDialog(Project project, String initialValue, XValueNodeImpl stringNode) {
            super(project, false);
            this.myStringNode = stringNode;
            this.setModal(false);
            this.setCancelButtonText(CommonBundle.message((String)"button.without.mnemonic.close", (Object[])new Object[0]));
            this.setOKButtonText(CommonBundle.message((String)"button.set", (Object[])new Object[0]));
            this.getOKAction().setEnabled(false);
            this.setCrossClosesWindow(true);
            this.myTextViewer = new TextViewer(initialValue, project, this.myStringNode == null);
            this.myTextViewer.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e.getNewLength() + e.getOldLength() > 0) {
                        this.getOKAction().setEnabled(true);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/java/debugger/impl/shared/actions/ViewTextActionBase$MyDialog$1", "documentChanged"));
                }
            });
            this.init();
        }

        public void setText(String text) {
            this.myTextViewer.setText(text);
        }

        protected void doOKAction() {
            if (this.myStringNode != null) {
                DebuggerUIUtil.setTreeNodeValue((XValueNodeImpl)this.myStringNode, (XExpression)XExpressionImpl.fromText((String)JavaValueTextModificationPreparatorKt.convertToJavaStringLiteral(this.myTextViewer.getText())), errorMessage -> Messages.showErrorDialog((Component)this.myStringNode.getTree(), (String)errorMessage));
            }
            super.doOKAction();
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray;
            if (this.myStringNode != null) {
                Action[] actionArray2 = new Action[2];
                actionArray2[0] = this.getOKAction();
                actionArray = actionArray2;
                actionArray2[1] = this.getCancelAction();
            } else {
                Action[] actionArray3 = new Action[1];
                actionArray = actionArray3;
                actionArray3[0] = this.getCancelAction();
            }
            if (actionArray == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myTextViewer;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.debugger.actions.ViewTextAction";
        }

        protected JComponent createCenterPanel() {
            BorderLayoutPanel panel = JBUI.Panels.simplePanel((Component)this.myTextViewer);
            panel.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
            return panel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/java/debugger/impl/shared/actions/ViewTextActionBase$MyDialog", "createActions"));
        }
    }
}

