/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.syntax.lexer;

import com.intellij.java.syntax.element.JavaDocSyntaxElementType;
import com.intellij.java.syntax.element.JavaSyntaxTokenType;
import com.intellij.java.syntax.lexer.LexerPositionImpl;
import com.intellij.java.syntax.lexer.LiteralType;
import com.intellij.java.syntax.lexer._JavaLexer;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.element.SyntaxTokenTypes;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.LexerPosition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.text.CharArrayUtilKmp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020\u0016H\u0002J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0002J'\u0010*\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000b2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u0016H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010(\u001a\u00020\u000f2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0002J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0002J\u0010\u00106\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0002J\u0018\u00107\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u000bH\u0002J\u0018\u00109\u001a\u0002012\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020-H\u0002J\u0010\u0010;\u001a\u00020-2\u0006\u0010(\u001a\u00020\u000fH\u0002J\u0010\u0010<\u001a\u00020-2\u0006\u0010(\u001a\u00020\u000fH\u0002J\b\u0010=\u001a\u00020\u000bH\u0016J\b\u0010>\u001a\u00020\u000fH\u0016J\f\u0010?\u001a\u00020\u000f*\u00020\tH\u0002J\u0014\u0010@\u001a\u00020\u0016*\u00020\t2\u0006\u0010A\u001a\u00020\u000fH\u0002J\f\u0010B\u001a\u00020\u000f*\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/java/syntax/lexer/JavaLexer;", "Lcom/intellij/platform/syntax/lexer/Lexer;", "level", "Lcom/intellij/pom/java/LanguageLevel;", "<init>", "(Lcom/intellij/pom/java/LanguageLevel;)V", "myFlexLexer", "Lcom/intellij/java/syntax/lexer/_JavaLexer;", "myStateStack", "Lcom/intellij/util/fastutil/ints/IntArrayList;", "myBuffer", "", "myBufferArray", "", "myBufferIndex", "", "myBufferEndOffset", "myTokenEndOffset", "myTokenType", "Lcom/intellij/platform/syntax/SyntaxElementType;", "mySymbolLength", "start", "", "buffer", "startOffset", "endOffset", "initialState", "buf", "end", "getState", "getTokenType", "getTokenStart", "getTokenEnd", "advance", "getCurrentPosition", "Lcom/intellij/platform/syntax/lexer/LexerPosition;", "restore", "position", "locateToken", "getWhitespaces", "offset", "getSimpleWhitespaces", "getChars", "charsToDetect", "endChar", "", "(ILjava/lang/CharSequence;Ljava/lang/Character;)I", "flexLocateToken", "locateLiteralEnd", "", "literalType", "Lcom/intellij/java/syntax/lexer/LiteralType;", "getClosingMarkdownComment", "getClosingComment", "getLineTerminator", "getCharSeqAt", "charSequence", "isLocatedCharAt", "charToDetect", "charAt", "locateCharAt", "getBufferSequence", "getBufferEnd", "topInt", "push", "value", "popInt", "intellij.java.syntax"})
@SourceDebugExtension(value={"SMAP\nJavaLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaLexer.kt\ncom/intellij/java/syntax/lexer/JavaLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,429:1\n1#2:430\n*E\n"})
public final class JavaLexer
implements Lexer {
    @NotNull
    private final _JavaLexer myFlexLexer;
    @NotNull
    private final IntArrayList myStateStack;
    private CharSequence myBuffer;
    @Nullable
    private char[] myBufferArray;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private int myTokenEndOffset;
    @Nullable
    private SyntaxElementType myTokenType;
    private int mySymbolLength;

    public JavaLexer(@NotNull LanguageLevel level) {
        this.myFlexLexer = new _JavaLexer(level);
        this.myStateStack = new IntArrayList(1);
        this.mySymbolLength = 1;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtilKmp.fromSequenceWithoutCopying((CharSequence)buffer);
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.mySymbolLength = 1;
        this.push(this.myStateStack, initialState);
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
            charSequence = null;
        }
        this.myFlexLexer.reset(charSequence, startOffset, endOffset, 0);
    }

    public void start(@NotNull CharSequence buf, int start, int end) {
        this.start(buf, start, end, 0);
    }

    public void start(@NotNull CharSequence buf) {
        this.start(buf, 0, buf.length());
    }

    public int getState() {
        return this.topInt(this.myStateStack);
    }

    @Nullable
    public SyntaxElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myBufferIndex;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEndOffset;
    }

    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        int offset = this.getTokenStart();
        int intState = this.getState();
        return new LexerPositionImpl(offset, intState);
    }

    public void restore(@NotNull LexerPosition position) {
        this.start(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), position.getState());
    }

    private final void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        if (this.myTokenEndOffset == this.myBufferEndOffset) {
            this.myBufferIndex = this.myBufferEndOffset;
            return;
        }
        this.myBufferIndex = this.myTokenEndOffset;
        char c = this.locateCharAt(this.myBufferIndex);
        block0 : switch (c) {
            case '\u001a': {
                if (this.myBufferIndex + this.mySymbolLength == this.myBufferEndOffset) {
                    this.myTokenType = SyntaxTokenTypes.getWHITE_SPACE();
                    this.myTokenEndOffset = this.myBufferIndex + this.mySymbolLength;
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.myTokenType = SyntaxTokenTypes.getWHITE_SPACE();
                this.myTokenEndOffset = this.getWhitespaces(this.myBufferIndex + this.mySymbolLength);
                break;
            }
            case '{': {
                int count1 = this.topInt(this.myStateStack) >> 16;
                if (count1 > 0) {
                    this.push(this.myStateStack, this.popInt(this.myStateStack) & 1 | count1 + 1 << 16);
                }
                this.myTokenType = JavaSyntaxTokenType.LBRACE;
                this.myTokenEndOffset = this.myBufferIndex + this.mySymbolLength;
                break;
            }
            case '}': {
                int count2 = this.topInt(this.myStateStack) >> 16;
                boolean updateToken = true;
                if (count2 > 0) {
                    if (count2 != 1) {
                        this.push(this.myStateStack, this.popInt(this.myStateStack) & 1 | count2 - 1 << 16);
                    } else {
                        boolean fragment;
                        int state = this.popInt(this.myStateStack);
                        if (this.myStateStack.getSize() == 0) {
                            this.push(this.myStateStack, 0);
                        }
                        this.myTokenType = (state & 1) != 0 ? ((fragment = this.locateLiteralEnd(this.myBufferIndex + this.mySymbolLength, LiteralType.TEXT_BLOCK)) ? JavaSyntaxTokenType.TEXT_BLOCK_TEMPLATE_MID : JavaSyntaxTokenType.TEXT_BLOCK_TEMPLATE_END) : ((fragment = this.locateLiteralEnd(this.myBufferIndex + this.mySymbolLength, LiteralType.STRING)) ? JavaSyntaxTokenType.STRING_TEMPLATE_MID : JavaSyntaxTokenType.STRING_TEMPLATE_END);
                        updateToken = false;
                    }
                }
                if (!updateToken) break;
                this.myTokenType = JavaSyntaxTokenType.RBRACE;
                this.myTokenEndOffset = this.myBufferIndex + this.mySymbolLength;
                break;
            }
            case '/': {
                if (this.myBufferIndex + this.mySymbolLength >= this.myBufferEndOffset) {
                    this.myTokenType = JavaSyntaxTokenType.DIV;
                    this.myTokenEndOffset = this.myBufferEndOffset;
                    break;
                }
                int l1 = this.mySymbolLength;
                char nextChar = this.locateCharAt(this.myBufferIndex + l1);
                switch (nextChar) {
                    case '/': {
                        int l2 = this.mySymbolLength;
                        if (this.myBufferIndex + l1 + l2 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2) == '/') {
                            this.myTokenType = JavaDocSyntaxElementType.DOC_MARKDOWN_COMMENT;
                            this.myTokenEndOffset = this.getClosingMarkdownComment(this.myBufferIndex + l1 + l2);
                            break block0;
                        }
                        this.myTokenType = JavaSyntaxTokenType.END_OF_LINE_COMMENT;
                        this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + l1 + l2);
                        break block0;
                    }
                    case '*': {
                        int l2 = this.mySymbolLength;
                        if (this.myBufferIndex + l1 + l2 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2) == '*') {
                            int l3 = this.mySymbolLength;
                            if (this.myBufferIndex + l1 + l2 + l3 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2 + l3) == '/') {
                                this.myTokenType = JavaSyntaxTokenType.C_STYLE_COMMENT;
                                this.myTokenEndOffset = this.myBufferIndex + l1 + l2 + l3 + this.mySymbolLength;
                                break block0;
                            }
                            this.myTokenType = JavaDocSyntaxElementType.DOC_COMMENT;
                            this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + l1 + l2 + l3);
                            break block0;
                        }
                        this.myTokenType = JavaSyntaxTokenType.C_STYLE_COMMENT;
                        this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + l1 + l2 + this.mySymbolLength);
                        break block0;
                    }
                }
                this.flexLocateToken();
                break;
            }
            case '#': {
                if (this.myBufferIndex == 0 && this.mySymbolLength == 1 && this.myBufferEndOffset > 1 && this.charAt(1) == '!') {
                    this.myTokenType = JavaSyntaxTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(2);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\'': {
                this.myTokenType = JavaSyntaxTokenType.CHARACTER_LITERAL;
                this.locateLiteralEnd(this.myBufferIndex + this.mySymbolLength, LiteralType.CHAR);
                break;
            }
            case '\"': {
                int l1 = this.mySymbolLength;
                if (this.myBufferIndex + l1 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1) == '\"') {
                    int l2 = this.mySymbolLength;
                    if (this.myBufferIndex + l1 + l2 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2) == '\"') {
                        boolean fragment = this.locateLiteralEnd(this.myBufferIndex + l1 + l2 + this.mySymbolLength, LiteralType.TEXT_BLOCK);
                        this.myTokenType = fragment ? JavaSyntaxTokenType.TEXT_BLOCK_TEMPLATE_BEGIN : JavaSyntaxTokenType.TEXT_BLOCK_LITERAL;
                        break;
                    }
                    this.myTokenType = JavaSyntaxTokenType.STRING_LITERAL;
                    this.myTokenEndOffset = this.myBufferIndex + l1 + l2;
                    break;
                }
                boolean fragment = this.locateLiteralEnd(this.myBufferIndex + l1, LiteralType.STRING);
                this.myTokenType = fragment ? JavaSyntaxTokenType.STRING_TEMPLATE_BEGIN : JavaSyntaxTokenType.STRING_LITERAL;
                break;
            }
            default: {
                this.flexLocateToken();
            }
        }
        if (this.myTokenEndOffset > this.myBufferEndOffset) {
            this.myTokenEndOffset = this.myBufferEndOffset;
        }
    }

    private final int getWhitespaces(int offset) {
        return this.getChars(offset, " \t\n\r\f", Character.valueOf('\u001a'));
    }

    private final int getSimpleWhitespaces(int offset) {
        return this.getChars(offset, " \t", null);
    }

    private final int getChars(int offset, CharSequence charsToDetect, Character endChar) {
        int pos = offset;
        while (pos < this.myBufferEndOffset) {
            boolean detected = false;
            char c = this.locateCharAt(pos);
            int n = charsToDetect.length();
            for (int i = 0; i < n; ++i) {
                if (charsToDetect.charAt(i) != c) continue;
                pos += this.mySymbolLength;
                detected = true;
                break;
            }
            if (!detected && endChar != null && pos + this.mySymbolLength == this.myBufferEndOffset) {
                char c2 = c;
                if (endChar.charValue() == c2) {
                    pos += this.mySymbolLength;
                    break;
                }
            }
            if (detected) continue;
            break;
        }
        return pos;
    }

    private final void flexLocateToken() {
        this.myFlexLexer.goTo(this.myBufferIndex);
        this.myTokenType = this.myFlexLexer.advance();
        this.myTokenEndOffset = this.myFlexLexer.getTokenEnd();
    }

    private final boolean locateLiteralEnd(int offset, LiteralType literalType) {
        int pos = 0;
        pos = offset;
        while (pos < this.myBufferEndOffset) {
            char c = this.locateCharAt(pos);
            if (c == '\\') {
                if ((pos += this.mySymbolLength) < this.myBufferEndOffset && this.locateCharAt(pos) == '{' && literalType != LiteralType.CHAR) {
                    this.myTokenEndOffset = pos += this.mySymbolLength;
                    if (this.topInt(this.myStateStack) == 0) {
                        this.popInt(this.myStateStack);
                    }
                    if (literalType == LiteralType.TEXT_BLOCK) {
                        this.push(this.myStateStack, 65537);
                    } else {
                        this.push(this.myStateStack, 65536);
                    }
                    return true;
                }
            } else {
                if (c == literalType.getC()) {
                    if (literalType == LiteralType.TEXT_BLOCK) {
                        int it = this.mySymbolLength;
                        boolean bl = false;
                        if ((pos += it) >= this.myBufferEndOffset || this.locateCharAt(pos) != '\"') continue;
                        it = this.mySymbolLength;
                        boolean bl2 = false;
                        if ((pos += it) >= this.myBufferEndOffset || this.locateCharAt(pos) != '\"') continue;
                        this.myTokenEndOffset = pos + this.mySymbolLength;
                        return false;
                    }
                    this.myTokenEndOffset = pos + this.mySymbolLength;
                    return false;
                }
                if ((c == '\n' || c == '\r') && this.mySymbolLength == 1 && literalType != LiteralType.TEXT_BLOCK) {
                    this.myTokenEndOffset = pos;
                    return false;
                }
            }
            pos += this.mySymbolLength;
        }
        this.myTokenEndOffset = pos;
        return false;
    }

    private final int getClosingMarkdownComment(int offset) {
        int pos = offset;
        while (pos < this.myBufferEndOffset) {
            pos = this.getLineTerminator(pos);
            int newPos = this.getSimpleWhitespaces(pos + this.mySymbolLength);
            if ((newPos = this.getCharSeqAt(newPos, "///")) == -1) break;
            pos = newPos;
        }
        return pos;
    }

    private final int getClosingComment(int offset) {
        char c;
        int pos = offset;
        while (pos < this.myBufferEndOffset && ((c = this.locateCharAt(pos)) != '*' || (pos += this.mySymbolLength) >= this.myBufferEndOffset || this.locateCharAt(pos) != '/')) {
        }
        return pos + this.mySymbolLength;
    }

    private final int getLineTerminator(int offset) {
        int pos;
        block3: for (pos = offset; pos < this.myBufferEndOffset; pos += this.mySymbolLength) {
            char c = this.locateCharAt(pos);
            switch (c) {
                case '\n': 
                case '\r': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        return pos;
    }

    private final int getCharSeqAt(int offset, CharSequence charSequence) {
        int pos = offset;
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (!this.isLocatedCharAt(pos, charSequence.charAt(i))) {
                return -1;
            }
            pos += this.mySymbolLength;
        }
        return pos;
    }

    private final boolean isLocatedCharAt(int offset, char charToDetect) {
        return offset < this.myBufferEndOffset && this.locateCharAt(offset) == charToDetect;
    }

    private final char charAt(int offset) {
        char c;
        if (this.myBufferArray != null) {
            char[] it = this.myBufferArray;
            boolean bl = false;
            c = it[offset];
        } else {
            CharSequence charSequence = this.myBuffer;
            if (charSequence == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
                charSequence = null;
            }
            c = charSequence.charAt(offset);
        }
        return c;
    }

    private final char locateCharAt(int offset) {
        this.mySymbolLength = 1;
        char first = this.charAt(offset);
        if (first != '\\') {
            return first;
        }
        int pos = offset + 1;
        if (pos < this.myBufferEndOffset && this.charAt(pos) == '\\') {
            return first;
        }
        boolean escaped = true;
        int i = offset;
        while (--i >= 0 && this.charAt(i) == '\\') {
            escaped = !escaped;
        }
        if (!escaped) {
            return first;
        }
        if (pos < this.myBufferEndOffset && this.charAt(pos) != 'u') {
            return first;
        }
        while (++pos < this.myBufferEndOffset && this.charAt(pos) == 'u') {
        }
        if (pos + 3 >= this.myBufferEndOffset) {
            return first;
        }
        int result = 0;
        int max = pos + 4;
        while (pos < max) {
            result <<= 4;
            char c = this.charAt(pos);
            if (Intrinsics.compare((int)48, (int)c) <= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                result += c - 48;
            } else if (Intrinsics.compare((int)97, (int)c) <= 0 && Intrinsics.compare((int)c, (int)102) <= 0) {
                result += c - 97 + 10;
            } else if (Intrinsics.compare((int)65, (int)c) <= 0 && Intrinsics.compare((int)c, (int)70) <= 0) {
                result += c - 65 + 10;
            } else {
                return first;
            }
            ++pos;
        }
        this.mySymbolLength = pos - offset;
        return (char)result;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
            charSequence = null;
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEndOffset;
    }

    private final int topInt(IntArrayList $this$topInt) {
        return $this$topInt.get($this$topInt.getSize() - 1);
    }

    private final void push(IntArrayList $this$push, int value) {
        $this$push.add(value);
    }

    private final int popInt(IntArrayList $this$popInt) {
        return $this$popInt.removeAt($this$popInt.getSize() - 1);
    }
}

